/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.inlong.manager.web.utils.HttpContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlongRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(InlongRequestWrapper.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private String bodyParams;
    private Map<String, String[]> params;
    private Map<String, String> headers;

    public InlongRequestWrapper(HttpServletRequest request) {
        super(request);
        this.bodyParams = HttpContextUtils.getBodyString((ServletRequest)request);
        this.params = HttpContextUtils.getParameterMap(request);
        this.headers = HttpContextUtils.getHeaderMapAll(request);
    }

    public String getParameter(String name) {
        String[] strArr;
        String[] v = this.params.get(name);
        String result = v == null ? null : (v instanceof String[] ? ((strArr = v).length > 0 ? strArr[0] : null) : (v instanceof String ? (String)v : v.toString()));
        return result;
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public String[] getParameterValues(String name) {
        String[] v = this.params.get(name);
        String[] result = v == null ? null : (v instanceof String[] ? v : (v instanceof String ? new String[]{(String)v} : new String[]{v.toString()}));
        return result;
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.bodyParams.getBytes(StandardCharsets.UTF_8));
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return inputStream.read();
            }
        };
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public void addHeader(String name, String value) {
        this.headers.put(name.toLowerCase(), value);
    }

    public void addBodyParam(String key, String value) throws JsonProcessingException {
        ObjectNode objectNode = (ObjectNode)mapper.readTree(this.bodyParams);
        objectNode.put(key, value);
        this.bodyParams = objectNode.toString();
    }

    public void addParameter(String name, String value) {
        this.params.put(name, new String[]{value});
    }
}

