/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpContextUtils.class);

    public static Map<String, String> getParameterMapAll(ServletRequest request) {
        Enumeration parameters = request.getParameterNames();
        HashMap<String, String> params = new HashMap<String, String>();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = request.getParameter(parameter);
            params.put(parameter, value);
        }
        return params;
    }

    public static Map<String, String[]> getParameterMap(HttpServletRequest request) {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        String queryString = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            String[] params = queryString.split("&");
            for (int i = 0; i < params.length; ++i) {
                String key;
                int splitIndex = params[i].indexOf("=");
                if (splitIndex == -1 || paramMap.containsKey(key = params[i].substring(0, splitIndex)) || splitIndex >= params[i].length()) continue;
                String value = params[i].substring(splitIndex + 1);
                paramMap.put(key, new String[]{value});
            }
        }
        return paramMap;
    }

    public static Map<String, String> getHeaderMapAll(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String parameter = (String)headerNames.nextElement();
            String value = request.getHeader(parameter);
            headers.put(parameter, value);
        }
        return headers;
    }

    public static String getBodyString(ServletRequest request) {
        StringBuilder builder = new StringBuilder();
        try (ServletInputStream inputStream = request.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
            String line = "";
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
        }
        catch (IOException e) {
            log.error("failed to get body string of request={}", (Object)request, (Object)e);
        }
        if (builder.length() == 0) {
            return "{}";
        }
        return builder.toString();
    }
}

