/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.sink.SinkPageRequest;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-StreamSink-API"})
public class OpenStreamSinkController {
    @Autowired
    private StreamSinkService sinkService;

    @RequestMapping(value={"/sink/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get stream sink")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<StreamSink> get(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sinkId cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sinkService.get(id, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/sink/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List stream sinks by paginating")
    public Response<List<? extends StreamSink>> listByCondition(@RequestBody SinkPageRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sinkService.listByCondition(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/sink/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save stream sink")
    public Response<Integer> save(@Validated @RequestBody SinkRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sinkService.save(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/sink/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update stream sink")
    public Response<Boolean> update(@Validated(value={UpdateByIdValidation.class}) @RequestBody SinkRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sinkService.update(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/sink/delete/{id}"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete stream sink")
    @ApiImplicitParams(value={@ApiImplicitParam(name="startProcess", dataTypeClass=boolean.class), @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)})
    public Response<Boolean> delete(@PathVariable Integer id, @RequestParam(required=false, defaultValue="false") boolean startProcess) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sinkId cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sinkService.delete(id, Boolean.valueOf(startProcess), LoginUserUtils.getLoginUser()));
    }
}

