/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfig;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigRequest;
import org.apache.inlong.common.pojo.dataproxy.DataProxyNodeResponse;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.repository.DataProxyConfigRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-DataProxy-API"})
public class DataProxyController {
    @Autowired
    @Lazy
    private InlongClusterService clusterService;
    @Autowired
    private DataProxyConfigRepository dataProxyConfigRepository;

    @PostMapping(value={"/dataproxy/getIpList/{inlongGroupId}"})
    @ApiOperation(value="Get data proxy IP list by InlongGroupId")
    public Response<DataProxyNodeResponse> getIpList(@PathVariable String inlongGroupId, @RequestParam(required=false) String protocolType) {
        return Response.success((Object)this.clusterService.getDataProxyNodes(inlongGroupId, protocolType));
    }

    @PostMapping(value={"/dataproxy/getConfig"})
    @ApiOperation(value="Get data proxy topic list")
    public Response<DataProxyConfig> getConfig(@RequestBody DataProxyConfigRequest request) {
        DataProxyConfig config = this.clusterService.getDataProxyConfig(request.getClusterTag(), request.getClusterName());
        if (CollectionUtils.isEmpty((Collection)config.getMqClusterList()) || CollectionUtils.isEmpty((Collection)config.getTopicList())) {
            return Response.fail((String)"Failed to get MQ Cluster or Topic, make sure Cluster registered or Topic existed.");
        }
        return Response.success((Object)config);
    }

    @PostMapping(value={"/dataproxy/getAllConfig"})
    @ApiOperation(value="Get all proxy config. This method was deprecated since version 1.8.0. Please use new method /dataproxy/getMetaConfig")
    @Deprecated
    public String getAllConfig(@RequestBody DataProxyConfigRequest request) {
        return this.clusterService.getAllConfig(request.getClusterName(), request.getMd5());
    }

    @PostMapping(value={"/dataproxy/getMetaConfig"})
    @ApiOperation(value="Get all DataProxy meta config")
    public String getMetaConfig(@RequestBody DataProxyConfigRequest request) {
        return this.clusterService.getMetaConfig(request.getClusterName(), request.getMd5());
    }

    @RequestMapping(value={"/changeClusterTag"}, method={RequestMethod.PUT})
    @ApiOperation(value="Change cluster tag and topic for inlong group id")
    public Response<String> changeClusterTag(@RequestParam String inlongGroupId, @RequestParam String clusterTag, @RequestParam String topic) {
        String result = this.dataProxyConfigRepository.changeClusterTag(inlongGroupId, clusterTag, topic);
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/removeBackupClusterTag"}, method={RequestMethod.PUT})
    @ApiOperation(value="Remove backup cluster tag and topic for inlong group id")
    public Response<String> removeBackupClusterTag(@RequestParam String inlongGroupId) {
        String result = this.dataProxyConfigRepository.removeBackupClusterTag(inlongGroupId);
        return Response.success((Object)result);
    }
}

