/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.trigger;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.core.job.JobWrapper;
import org.apache.inlong.agent.core.task.Task;
import org.apache.inlong.agent.db.TriggerProfileDb;
import org.apache.inlong.agent.plugin.Trigger;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerManager.class);
    private final AgentManager manager;
    private final TriggerProfileDb triggerProfileDB;
    private final ConcurrentHashMap<String, Trigger> triggerMap;
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    private final int triggerFetchInterval;
    private final int maxRunningNum;

    public TriggerManager(AgentManager manager, TriggerProfileDb triggerProfileDb) {
        this.manager = manager;
        this.triggerProfileDB = triggerProfileDb;
        this.triggerMap = new ConcurrentHashMap();
        this.triggerFetchInterval = this.conf.getInt("trigger.fetch.interval", 1);
        this.maxRunningNum = this.conf.getInt("trigger.max.running.num", 4096);
    }

    public boolean restoreTrigger(TriggerProfile triggerProfile) {
        try {
            Class<?> triggerClass = Class.forName(triggerProfile.get("job.fileJob.trigger"));
            Trigger trigger = (Trigger)triggerClass.newInstance();
            String triggerId = triggerProfile.get("job.id");
            if (this.triggerMap.containsKey(triggerId)) {
                this.deleteTrigger(triggerId, false);
                LOGGER.warn("trigger {} is running, stop it", (Object)triggerId);
            }
            this.triggerMap.put(triggerId, trigger);
            trigger.init(triggerProfile);
            trigger.run();
        }
        catch (Throwable ex) {
            LOGGER.error("add trigger error: ", ex);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public Trigger getTrigger(String triggerId) {
        return this.triggerMap.get(triggerId);
    }

    public void submitTrigger(TriggerProfile triggerProfile, boolean isNewJob) {
        if (!triggerProfile.allRequiredKeyExist() || this.triggerMap.size() > this.maxRunningNum) {
            throw new IllegalArgumentException(String.format("trigger %s not all required key exists or size %d exceed %d", triggerProfile.toJsonStr(), this.triggerMap.size(), this.maxRunningNum));
        }
        if (this.triggerProfileDB.getTriggers().stream().anyMatch(profile -> profile.getTriggerId().equals(triggerProfile.getTriggerId()))) {
            return;
        }
        LOGGER.info("submit trigger {}", (Object)triggerProfile.toJsonStr());
        this.manager.getJobManager().submitJobProfile((JobProfile)triggerProfile, true, isNewJob);
        this.triggerProfileDB.storeTrigger(triggerProfile);
        this.restoreTrigger(triggerProfile);
    }

    public void deleteTrigger(String triggerId, boolean isFrozen) {
        if (!this.triggerProfileDB.getTriggers().stream().anyMatch(profile -> profile.getTriggerId().equals(triggerId))) {
            return;
        }
        LOGGER.info("delete trigger {}", (Object)triggerId);
        Trigger trigger = this.triggerMap.remove(triggerId);
        if (trigger != null) {
            this.manager.getJobManager().deleteJob(trigger.getTriggerProfile().getInstanceId(), isFrozen);
            trigger.destroy();
        }
        this.triggerProfileDB.deleteTrigger(triggerId);
    }

    private Runnable jobFetchThread() {
        return () -> {
            Thread.currentThread().setName("TriggerManager-jobFetch");
            while (this.isRunnable()) {
                try {
                    this.triggerMap.forEach((s, trigger) -> {
                        Map profile = trigger.fetchJobProfile();
                        if (profile != null) {
                            Map<String, JobWrapper> jobWrapperMap = this.manager.getJobManager().getJobs();
                            JobWrapper job = jobWrapperMap.get(trigger.getTriggerProfile().getInstanceId());
                            if (job == null) {
                                LOGGER.error("job {} should not be null", (Object)trigger.getTriggerProfile().getInstanceId());
                                return;
                            }
                            String subTaskFile = profile.getOrDefault("job.fileJob.dir.patterns", "");
                            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)subTaskFile), (Object)String.format("Trigger %s fetched task file should not be null.", s));
                            boolean alreadyExistTask = job.exist((Predicate<Collection<Task>>)((Predicate)tasks -> tasks.stream().filter(task -> !task.getJobConf().hasKey("job.fileJob.trigger")).filter(task -> subTaskFile.equals(task.getJobConf().get("job.fileJob.dir.patterns", ""))).findAny().isPresent()));
                            if (!alreadyExistTask) {
                                LOGGER.info("Trigger job {} add new task file {}, total task {}", new Object[]{job.getJob().getName(), subTaskFile, job.getAllTasks().size()});
                                JobWrapper jobWrapper = jobWrapperMap.get(trigger.getTriggerProfile().getInstanceId());
                                JobProfile taskProfile = JobProfile.parseJsonStr((String)jobWrapper.getJob().getJobConf().toJsonStr());
                                profile.forEach((k, v) -> taskProfile.set(k, v));
                                jobWrapper.submit(taskProfile);
                            }
                        }
                    });
                    TimeUnit.SECONDS.sleep(this.triggerFetchInterval);
                }
                catch (Throwable e) {
                    LOGGER.info("ignored exception: ", e);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
                }
            }
        };
    }

    private void initTriggers() {
        List profileList = this.triggerProfileDB.getTriggers();
        for (TriggerProfile profile : profileList) {
            this.restoreTrigger(profile);
        }
    }

    private void stopTriggers() {
        this.triggerMap.forEach((s, trigger) -> trigger.destroy());
    }

    public void start() {
        this.initTriggers();
        this.submitWorker(this.jobFetchThread());
    }

    public void stop() {
        this.stopTriggers();
    }
}

