/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.core.task.Task;
import org.apache.inlong.agent.core.task.TaskWrapper;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskManager.class);
    private final ThreadPoolExecutor runningPool;
    private final AgentManager agentManager;
    private final ConcurrentHashMap<String, TaskWrapper> tasks;
    private final BlockingQueue<TaskWrapper> retryTasks;
    private final int monitorInterval;
    private final int taskMaxCapacity;
    private final int taskRetryMaxTime;
    private final long waitTime;
    private final AgentMetricItemSet taskMetrics;
    private final Map<String, String> dimensions;

    public TaskManager(AgentManager agentManager) {
        this.agentManager = agentManager;
        this.runningPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("task"));
        this.taskMetrics = new AgentMetricItemSet(((Object)((Object)this)).getClass().getSimpleName());
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("componentName", ((Object)((Object)this)).getClass().getSimpleName());
        MetricRegister.unregister((MetricItemSet)this.taskMetrics);
        MetricRegister.register((MetricItemSet)this.taskMetrics);
        this.tasks = new ConcurrentHashMap();
        AgentConfiguration conf = AgentConfiguration.getAgentConf();
        this.retryTasks = new LinkedBlockingQueue<TaskWrapper>(conf.getInt("task.retry.maxCapacity", 10000));
        this.monitorInterval = conf.getInt("task.monitor.interval", 6);
        this.taskRetryMaxTime = conf.getInt("task.retry.submit.waitSeconds", 5);
        this.taskMaxCapacity = conf.getInt("task.retry.maxCapacity", 10000);
        this.waitTime = conf.getLong("thread.pool.await.time", 300L);
    }

    public AgentMetricItem getTaskMetrics() {
        return (AgentMetricItem)this.taskMetrics.findMetricItem(this.dimensions);
    }

    public TaskWrapper getTaskWrapper(String taskId) {
        return this.tasks.get(taskId);
    }

    public void submitTask(Task task) {
        TaskWrapper taskWrapper = new TaskWrapper(this, task);
        this.submitTask(taskWrapper);
    }

    public void submitTask(TaskWrapper wrapper) {
        TaskWrapper retTaskWrapper = this.tasks.putIfAbsent(wrapper.getTask().getTaskId(), wrapper);
        if (retTaskWrapper == null) {
            boolean notSubmitted = true;
            while (notSubmitted) {
                try {
                    if (this.runningPool.isShutdown()) {
                        LOGGER.error("submit task error because thread pool is closed");
                        break;
                    }
                    this.runningPool.submit((Runnable)((Object)wrapper));
                    notSubmitted = false;
                }
                catch (Exception ex) {
                    AgentUtils.silenceSleepInMs((long)this.waitTime);
                    LOGGER.warn("reject task {}", (Object)wrapper.getTask().getTaskId(), (Object)ex);
                }
            }
            this.getTaskMetrics().taskRunningCount.incrementAndGet();
        } else {
            LOGGER.warn("task cannot be repeated added taskId {}", (Object)wrapper.getTask().getTaskId());
        }
    }

    private boolean addRetryTask(TaskWrapper wrapper) {
        LOGGER.info("retry submit task {}", (Object)wrapper.getTask().getTaskId());
        try {
            boolean success = this.retryTasks.offer(wrapper, this.taskRetryMaxTime, TimeUnit.SECONDS);
            if (!success) {
                LOGGER.error("cannot submit to retry queue, max {}, current {}", (Object)this.taskMaxCapacity, (Object)this.retryTasks.size());
            } else {
                this.getTaskMetrics().taskRetryingCount.incrementAndGet();
            }
            return success;
        }
        catch (Exception ex) {
            LOGGER.error("error while offer task", (Throwable)ex);
            return false;
        }
    }

    public boolean isTaskFinished(String taskId) {
        TaskWrapper wrapper = this.tasks.get(taskId);
        if (wrapper != null) {
            return wrapper.isFinished();
        }
        return false;
    }

    public boolean isTaskSuccess(String taskId) {
        TaskWrapper wrapper = this.tasks.get(taskId);
        if (wrapper != null) {
            return wrapper.isSuccess();
        }
        return false;
    }

    public void removeTask(String taskId) {
        if (taskId == null) {
            return;
        }
        this.getTaskMetrics().taskRunningCount.decrementAndGet();
        TaskWrapper taskWrapper = this.tasks.remove(taskId);
        if (taskWrapper != null) {
            taskWrapper.destroyTask();
        }
    }

    public boolean killTask(Task task) {
        TaskWrapper taskWrapper = this.tasks.get(task.getTaskId());
        if (taskWrapper != null) {
            taskWrapper.kill();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public int getTaskSize() {
        return this.tasks.size();
    }

    public Runnable createTaskMonitorThread() {
        return () -> {
            while (this.isRunnable()) {
                try {
                    for (String taskId : this.tasks.keySet()) {
                        boolean success;
                        TaskWrapper wrapper = this.tasks.get(taskId);
                        if (wrapper == null || !wrapper.isFailed() || !wrapper.shouldRetry() || !(success = this.addRetryTask(wrapper))) continue;
                        this.removeTask(taskId);
                    }
                    while (!this.retryTasks.isEmpty()) {
                        TaskWrapper taskWrapper = (TaskWrapper)((Object)((Object)this.retryTasks.poll()));
                        if (taskWrapper == null) continue;
                        this.getTaskMetrics().taskRetryingCount.decrementAndGet();
                        this.submitTask(taskWrapper);
                    }
                    TimeUnit.SECONDS.sleep(this.monitorInterval);
                }
                catch (Throwable ex) {
                    LOGGER.error("Exception caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    public void start() {
        this.submitWorker(this.createTaskMonitorThread());
    }

    public void stop() throws Exception {
        this.waitForTerminate();
        this.runningPool.shutdown();
    }
}

