/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.db.JobProfileDb;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionManager.class);
    private static volatile PositionManager positionManager = null;
    private final AgentManager agentManager;
    private final JobProfileDb jobConfDb;
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> jobTaskPositionMap;

    private PositionManager(AgentManager agentManager) {
        this.agentManager = agentManager;
        this.jobConfDb = agentManager.getJobManager().getJobConfDb();
        this.jobTaskPositionMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PositionManager getInstance(AgentManager agentManager) {
        if (positionManager != null) return positionManager;
        Class<PositionManager> clazz = PositionManager.class;
        synchronized (PositionManager.class) {
            if (positionManager != null) return positionManager;
            positionManager = new PositionManager(agentManager);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return positionManager;
        }
    }

    public static PositionManager getInstance() {
        if (positionManager == null) {
            throw new RuntimeException("task position manager has not been initialized by agentManager");
        }
        return positionManager;
    }

    public void start() throws Exception {
        this.submitWorker(this.taskPositionFlushThread());
    }

    private Runnable taskPositionFlushThread() {
        return () -> {
            while (this.isRunnable()) {
                this.doFlush();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush() {
        try {
            for (String jobId : this.jobTaskPositionMap.keySet()) {
                JobProfile jobProfile = this.jobConfDb.getJobById(jobId);
                if (jobProfile == null) {
                    LOGGER.warn("jobProfile {} cannot be found in db, might be deleted by standalone mode, now delete job position in memory", (Object)jobId);
                    this.deleteJobPosition(jobId);
                    continue;
                }
                this.flushJobProfile(jobId, jobProfile);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("error caught", ex);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
        }
        finally {
            int flushTime = this.conf.getInt("agent.heartbeat.interval", 10);
            AgentUtils.silenceSleepInSeconds((long)flushTime);
        }
    }

    private void flushJobProfile(String jobId, JobProfile jobProfile) {
        this.jobTaskPositionMap.get(jobId).forEach((fileName, position) -> jobProfile.setLong(fileName + ".position", position.longValue()));
        if (this.jobConfDb.checkJobfinished(jobProfile)) {
            LOGGER.info("Cannot update job profile {}, delete memory job in jobTaskPosition", (Object)jobId);
            this.deleteJobPosition(jobId);
        } else {
            this.jobConfDb.updateJobProfile(jobProfile);
        }
    }

    private void deleteJobPosition(String jobId) {
        this.jobTaskPositionMap.remove(jobId);
    }

    public void stop() throws Exception {
        this.waitForTerminate();
    }

    public void updateSinkPosition(String jobInstanceId, String sourcePath, long size, boolean reset) {
        ConcurrentHashMap<String, Long> positionTemp = new ConcurrentHashMap<String, Long>();
        ConcurrentHashMap<String, Long> position = this.jobTaskPositionMap.putIfAbsent(jobInstanceId, positionTemp);
        if (position == null) {
            JobProfile jobProfile = this.jobConfDb.getJobById(jobInstanceId);
            positionTemp.put(sourcePath, jobProfile.getLong(sourcePath + ".position", 0L));
            position = positionTemp;
        }
        if (!reset) {
            Long beforePosition = position.getOrDefault(sourcePath, 0L);
            position.put(sourcePath, beforePosition + size);
        } else {
            position.put(sourcePath, size);
        }
    }

    public long getPosition(String sourcePath, String jobInstanceId) {
        JobProfile jobProfile = this.jobConfDb.getJobById(jobInstanceId);
        if (jobProfile == null) {
            LOGGER.error("getPosition but jobProfile not exist! sourcePath {} jobInstanceId {} return position 0", (Object)sourcePath, (Object)jobInstanceId);
            return 0L;
        }
        return jobProfile.getLong(sourcePath + ".position", 0L);
    }
}

