/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryManager.class);
    private static volatile MemoryManager memoryManager = null;
    private final AgentConfiguration conf;
    private ConcurrentHashMap<String, Semaphore> semaphoreMap = new ConcurrentHashMap();

    private MemoryManager() {
        this.conf = AgentConfiguration.getAgentConf();
        Semaphore semaphore = null;
        semaphore = new Semaphore(this.conf.getInt("agent.global.reader.source.permit", 16000000));
        this.semaphoreMap.put("agent.global.reader.source.permit", semaphore);
        semaphore = new Semaphore(this.conf.getInt("agent.global.reader.queue.permit", 16000000));
        this.semaphoreMap.put("agent.global.reader.queue.permit", semaphore);
        semaphore = new Semaphore(this.conf.getInt("agent.global.channel.permit", 16000000));
        this.semaphoreMap.put("agent.global.channel.permit", semaphore);
        semaphore = new Semaphore(this.conf.getInt("agent.global.writer.permit", 96000000));
        this.semaphoreMap.put("agent.global.writer.permit", semaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemoryManager getInstance() {
        if (memoryManager != null) return memoryManager;
        Class<MemoryManager> clazz = MemoryManager.class;
        synchronized (MemoryManager.class) {
            if (memoryManager != null) return memoryManager;
            memoryManager = new MemoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return memoryManager;
        }
    }

    public boolean tryAcquire(String semaphoreName, int permit) {
        Semaphore semaphore = this.semaphoreMap.get(semaphoreName);
        if (semaphore == null) {
            LOGGER.error("tryAcquire {} not exist");
            return false;
        }
        return semaphore.tryAcquire(permit);
    }

    public void release(String semaphoreName, int permit) {
        Semaphore semaphore = this.semaphoreMap.get(semaphoreName);
        if (semaphore == null) {
            LOGGER.error("release {} not exist");
            return;
        }
        semaphore.release(permit);
    }

    public void printDetail(String semaphoreName) {
        Semaphore semaphore = this.semaphoreMap.get(semaphoreName);
        if (semaphore == null) {
            LOGGER.error("printDetail {} not exist");
            return;
        }
        LOGGER.info("permit left {} wait {} {}", new Object[]{semaphore.availablePermits(), semaphore.getQueueLength(), semaphoreName});
    }

    public void printAll() {
        this.printDetail("agent.global.reader.source.permit");
        this.printDetail("agent.global.reader.queue.permit");
        this.printDetail("agent.global.channel.permit");
        this.printDetail("agent.global.writer.permit");
    }
}

