/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.job;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.core.job.Job;
import org.apache.inlong.agent.core.job.JobManager;
import org.apache.inlong.agent.core.task.Task;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.agent.db.CommandDb;
import org.apache.inlong.agent.plugin.Channel;
import org.apache.inlong.agent.plugin.Reader;
import org.apache.inlong.agent.plugin.Sink;
import org.apache.inlong.agent.plugin.Source;
import org.apache.inlong.agent.state.AbstractStateWrapper;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.db.CommandEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWrapper
extends AbstractStateWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWrapper.class);
    private final AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
    private final TaskManager taskManager;
    private final JobManager jobManager;
    private final Job job;
    private final List<Task> allTasks;
    private final Queue<Task> taskQueue;
    private boolean isEnd;
    private final AtomicInteger index;
    private CommandDb db;

    public JobWrapper(AgentManager manager, Job job) {
        this.taskManager = manager.getTaskManager();
        this.jobManager = manager.getJobManager();
        this.job = job;
        this.allTasks = new ArrayList<Task>();
        this.db = manager.getCommandDb();
        this.taskQueue = new LinkedList<Task>();
        this.index = new AtomicInteger(0);
        this.isEnd = false;
        this.doChangeState(State.ACCEPTED);
    }

    private void checkQueuedTasks() {
        while (this.taskQueue.peek() != null && !this.isEnd) {
            Task task = this.taskQueue.poll();
            this.allTasks.add(task);
            this.taskManager.submitTask(task);
        }
    }

    private void checkAllTasksStateAndWait() throws Exception {
        boolean isFinished = false;
        long checkInterval = this.agentConf.getLong("job.finish.checkInterval", 6L);
        do {
            this.checkQueuedTasks();
            isFinished = this.allTasks.stream().allMatch(task -> this.taskManager.isTaskFinished(task.getTaskId()));
            TimeUnit.SECONDS.sleep(checkInterval);
        } while (!isFinished);
        LOGGER.info("all tasks of {} has been checked", (Object)this.job.getJobInstanceId());
        boolean isSuccess = this.allTasks.stream().allMatch(task -> this.taskManager.isTaskSuccess(task.getTaskId()));
        if (isSuccess) {
            this.doChangeState(State.SUCCEEDED);
        } else {
            this.doChangeState(State.FAILED);
            this.saveFailedCommand();
        }
    }

    private void saveFailedCommand() {
        CommandEntity entity = new CommandEntity();
        entity.setId(this.job.getJobInstanceId());
        entity.setAcked(false);
        entity.setTaskId(Integer.valueOf(this.job.getJobInstanceId()));
        entity.setCommandResult(1);
        entity.setVersion(Integer.valueOf(this.job.getJobConf().getInt("job.version", AgentConstants.DEFAULT_JOB_VERSION.intValue())));
        this.db.storeCommand(entity);
    }

    public String getSnapshot() {
        ArrayList<String> snapshotList = new ArrayList<String>();
        for (Task task : this.allTasks) {
            String snapshot = task.getReader().getSnapshot();
            if (snapshot == null) continue;
            snapshotList.add(snapshot);
        }
        return String.join((CharSequence)"_", snapshotList);
    }

    public Job getJob() {
        return this.job;
    }

    public boolean exist(Predicate<Collection<Task>> predicate) {
        HashSet<Task> tasks = new HashSet<Task>();
        tasks.addAll(this.allTasks);
        tasks.addAll(this.taskQueue);
        return predicate.test(tasks);
    }

    public void submit(JobProfile taskProfile) {
        try {
            JobProfile jobProfile = this.job.getJobConf();
            Preconditions.checkArgument((boolean)jobProfile.get("job.source").equals(taskProfile.get("job.source")), (Object)"Subtask source should be same");
            Preconditions.checkArgument((boolean)jobProfile.get("job.channel").equals(taskProfile.get("job.channel")), (Object)"Subtask channel should be same");
            Preconditions.checkArgument((boolean)jobProfile.get("job.sink").equals(taskProfile.get("job.sink", "Subtask sink should be same")));
            LOGGER.info("job id: {} submit new task {}.", (Object)this.job.getJobInstanceId(), (Object)taskProfile.toJsonStr());
            Source source = (Source)Class.forName(jobProfile.get("job.source")).newInstance();
            for (Reader reader : source.split(taskProfile)) {
                Sink writer = (Sink)Class.forName(jobProfile.get("job.sink")).newInstance();
                writer.setSourceName(reader.getReadSource());
                Channel channel = (Channel)Class.forName(jobProfile.get("job.channel")).newInstance();
                String taskId = String.format("%s_%d", this.job.getJobInstanceId(), this.index.incrementAndGet());
                jobProfile.set(reader.getReadSource(), DigestUtils.md5Hex((String)reader.getReadSource()));
                Task task = new Task(taskId, reader, writer, channel, taskProfile);
                this.taskQueue.offer(task);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Create task for profile({}) failed", (Object)taskProfile, (Object)ex);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
        }
        LOGGER.info("Job name is {} and task size {}", (Object)this.job.getName(), (Object)this.allTasks.size());
    }

    public void cleanup() {
        this.isEnd = true;
        this.allTasks.forEach(task -> this.taskManager.removeTask(task.getTaskId()));
    }

    public void run() {
        try {
            AgentThreadFactory.nameThread((String)this.job.getJobInstanceId());
            LOGGER.info("job id: {}, source: {}, channel: {}, sink: {}", new Object[]{this.job.getJobInstanceId(), this.job.getJobConf().get("job.source"), this.job.getJobConf().get("job.channel"), this.job.getJobConf().get("job.sink")});
            this.doChangeState(State.RUNNING);
            this.submit(this.job.getJobConf());
            this.checkQueuedTasks();
            this.checkAllTasksStateAndWait();
            this.cleanup();
            LOGGER.info("job name is {}, state is {}", (Object)this.job.getName(), (Object)this.getCurrentState());
        }
        catch (Exception ex) {
            this.doChangeState(State.FAILED);
            LOGGER.error("error caught: {}, message: {}", (Object)this.job.getJobConf().toJsonStr(), (Object)ex);
        }
    }

    public void addCallbacks() {
        this.addCallback(State.ACCEPTED, State.RUNNING, (before, after) -> {}).addCallback(State.RUNNING, State.FAILED, (before, after) -> this.jobManager.markJobAsFailed(this.job.getJobInstanceId())).addCallback(State.RUNNING, State.SUCCEEDED, (before, after) -> this.jobManager.markJobAsSuccess(this.job.getJobInstanceId()));
    }

    public List<Task> getAllTasks() {
        return this.allTasks;
    }
}

