/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.job;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.core.job.Job;
import org.apache.inlong.agent.core.job.JobWrapper;
import org.apache.inlong.agent.db.JobProfileDb;
import org.apache.inlong.agent.db.StateSearchKey;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.GsonUtil;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobManager.class);
    private final ConcurrentHashMap<String, Job> pendingJobs;
    private final ThreadPoolExecutor runningPool;
    private final AgentManager agentManager;
    private final int monitorInterval;
    private final long jobDbCacheTime;
    private final long jobDbCacheCheckInterval;
    private final JobProfileDb jobProfileDb;
    private final AtomicLong index = new AtomicLong(0L);
    private final long jobMaxSize;
    private final ConcurrentHashMap<String, JobWrapper> jobs;
    private final AgentMetricItemSet jobMetrics;
    private final Map<String, String> dimensions;
    private final AgentConfiguration agentConf;

    public JobManager(AgentManager agentManager, JobProfileDb jobProfileDb) {
        this.jobProfileDb = jobProfileDb;
        this.agentManager = agentManager;
        this.runningPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("job"));
        this.jobs = new ConcurrentHashMap();
        this.agentConf = AgentConfiguration.getAgentConf();
        this.pendingJobs = new ConcurrentHashMap();
        this.monitorInterval = this.agentConf.getInt("job.monitor.interval", 5);
        this.jobDbCacheTime = this.agentConf.getLong("job.db.cache.time", 259200000L);
        this.jobDbCacheCheckInterval = this.agentConf.getLong("job.db.cache.check.interval", 3600L);
        this.jobMaxSize = this.agentConf.getLong("job.number.limit", 15L);
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("componentName", ((Object)((Object)this)).getClass().getSimpleName());
        this.jobMetrics = new AgentMetricItemSet(((Object)((Object)this)).getClass().getSimpleName());
        MetricRegister.unregister((MetricItemSet)this.jobMetrics);
        MetricRegister.register((MetricItemSet)this.jobMetrics);
    }

    private void addJob(Job job) {
        if (this.pendingJobs.containsKey(job.getJobInstanceId())) {
            return;
        }
        try {
            JobWrapper jobWrapper = new JobWrapper(this.agentManager, job);
            JobWrapper jobWrapperRet = this.jobs.putIfAbsent(jobWrapper.getJob().getJobInstanceId(), jobWrapper);
            if (jobWrapperRet != null) {
                LOGGER.warn("{} has been added to running pool, cannot be added repeatedly", (Object)job.getJobInstanceId());
                return;
            }
            this.getJobMetric().jobRunningCount.incrementAndGet();
            this.runningPool.execute((Runnable)((Object)jobWrapper));
        }
        catch (Exception rje) {
            LOGGER.debug("reject job {}", (Object)job.getJobInstanceId(), (Object)rje);
            this.pendingJobs.putIfAbsent(job.getJobInstanceId(), job);
        }
        catch (Throwable t) {
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
        }
    }

    public boolean submitFileJobProfile(JobProfile profile) {
        return this.submitJobProfile(profile, false, true);
    }

    public boolean submitJobProfile(JobProfile profile, boolean singleJob, boolean isNewJob) {
        if (!this.isJobValid(profile)) {
            return false;
        }
        String jobId = profile.get("job.id");
        if (singleJob) {
            profile.set("job.instance.id", AgentUtils.getSingleJobId((String)"job_", (String)jobId));
        } else {
            profile.set("job.instance.id", AgentUtils.getUniqId((String)"job_", (String)jobId, (long)this.index.incrementAndGet()));
        }
        LOGGER.info("submit job profile {} isNewJob {}", (Object)profile.toJsonStr(), (Object)isNewJob);
        if (isNewJob) {
            this.jobProfileDb.storeJobFirstTime(profile);
        } else {
            JobProfile jobFromDb = this.jobProfileDb.getJobById(profile.getInstanceId());
            if (jobFromDb != null) {
                jobFromDb.set("job.version", profile.get("job.version"));
                profile = jobFromDb;
            } else {
                LOGGER.info("submit job final profile null");
            }
        }
        LOGGER.info("submit job final profile {}", (Object)profile.toJsonStr());
        this.addJob(new Job(profile));
        return true;
    }

    private boolean isJobValid(JobProfile profile) {
        if (profile == null || !profile.allRequiredKeyExist()) {
            LOGGER.error("profile is null or not all required key exists {}", (Object)(profile == null ? null : profile.toJsonStr()));
            return false;
        }
        if (this.isJobOverLimit()) {
            LOGGER.error("agent cannot add more job, max job size is {}", (Object)this.jobMaxSize);
            return false;
        }
        return true;
    }

    public boolean isJobOverLimit() {
        return (long)this.jobs.size() >= this.jobMaxSize;
    }

    public boolean deleteJob(String jobInstancId, boolean isFrozen) {
        LOGGER.info("start to delete job, job id set {}", (Object)this.jobs.keySet());
        JobWrapper jobWrapper = this.jobs.remove(jobInstancId);
        if (jobWrapper != null) {
            LOGGER.info("delete job instance with job id {} isFrozen {}", (Object)jobInstancId, (Object)isFrozen);
            jobWrapper.cleanup();
            if (!isFrozen) {
                this.jobProfileDb.deleteJob(jobInstancId);
            }
            return true;
        }
        return true;
    }

    private void startJobs() {
        List profileList = this.jobProfileDb.getRestartJobs();
        for (JobProfile profile : profileList) {
            LOGGER.info("init starting job from db {}", (Object)profile.toJsonStr());
            this.addJob(new Job(profile));
        }
    }

    public Runnable jobStateCheckThread() {
        return () -> {
            while (this.isRunnable()) {
                try {
                    for (String jobId : this.pendingJobs.keySet()) {
                        Job job = this.pendingJobs.remove(jobId);
                        if (job == null) continue;
                        this.addJob(job);
                    }
                    TimeUnit.SECONDS.sleep(this.monitorInterval);
                }
                catch (Throwable ex) {
                    LOGGER.error("error caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    public Runnable dbStorageCheckThread() {
        return () -> {
            while (this.isRunnable()) {
                try {
                    this.jobProfileDb.removeExpireJobs(this.jobDbCacheTime);
                    Map jobStateMap = this.jobProfileDb.getJobsState();
                    LOGGER.info("check local job state: {}", (Object)GsonUtil.toJson((Object)jobStateMap));
                }
                catch (Exception ex) {
                    LOGGER.error("removeExpireJobs error caught", (Throwable)ex);
                }
                try {
                    TimeUnit.SECONDS.sleep(this.jobDbCacheCheckInterval);
                }
                catch (Throwable ex) {
                    LOGGER.error("sleep error caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    public void markJobAsSuccess(String jobId) {
        JobWrapper wrapper = this.jobs.remove(jobId);
        if (wrapper != null) {
            this.getJobMetric().jobRunningCount.decrementAndGet();
            LOGGER.info("job instance {} is success", (Object)jobId);
            this.jobProfileDb.updateJobState(jobId, StateSearchKey.SUCCESS);
        }
    }

    public void markJobAsFailed(String jobId) {
        LOGGER.info("markJobAsFailed {}", (Object)jobId);
        JobWrapper wrapper = this.jobs.remove(jobId);
        if (wrapper != null) {
            LOGGER.info("job instance {} is failed", (Object)jobId);
            this.getJobMetric().jobRunningCount.decrementAndGet();
            this.getJobMetric().jobFatalCount.incrementAndGet();
            this.jobProfileDb.updateJobState(jobId, StateSearchKey.FAILED);
        }
    }

    public JobProfileDb getJobConfDb() {
        return this.jobProfileDb;
    }

    public boolean checkJobExist(String fileName) {
        return this.jobProfileDb.getJobByFileName(fileName) != null;
    }

    public boolean sqlJobExist() {
        return this.jobProfileDb.getJobById("sql_job_id") != null;
    }

    public Map<String, JobWrapper> getJobs() {
        return this.jobs;
    }

    public void start() {
        this.submitWorker(this.jobStateCheckThread());
        this.submitWorker(this.dbStorageCheckThread());
        this.startJobs();
    }

    public void stop() throws Exception {
        this.waitForTerminate();
        this.runningPool.shutdown();
    }

    private AgentMetricItem getJobMetric() {
        return (AgentMetricItem)this.jobMetrics.findMetricItem(this.dimensions);
    }
}

