/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.conf;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.core.conf.ConfigJetty;
import org.apache.inlong.agent.core.conf.ResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServlet.class);
    private static final String CONTENT_TYPE = "application/json";
    private static final String CHARSET_TYPE = "UTF-8";
    private static final String JOB_TYPE = "job";
    private static final String AGENT_TYPE = "agent";
    private static final String TRIGGER_TYPE = "trigger";
    private static final String OP_TYPE = "op";
    private static final String ADD_OP = "add";
    private static final String DELETE_OP = "delete";
    private final Gson gson = new Gson();
    private final ConfigJetty configHandler;

    public ConfigServlet(ConfigJetty configHandler) {
        this.configHandler = configHandler;
    }

    public void responseToJson(HttpServletResponse response, ResponseResult result) throws IOException {
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(CHARSET_TYPE);
        String jsonStr = this.gson.toJson((Object)result);
        PrintWriter out = response.getWriter();
        out.print(jsonStr);
        out.flush();
    }

    private void handleJob(String jobProfileStr) {
        JobProfile jobProfile = JobProfile.parseJsonStr((String)jobProfileStr);
        String op = jobProfile.get(OP_TYPE);
        if (ADD_OP.equals(op)) {
            this.configHandler.storeJobConf(jobProfile);
        } else if (DELETE_OP.equals(op)) {
            this.configHandler.deleteJobConf(jobProfile);
        }
    }

    private void handleAgent(String agentProfileStr) {
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        ResponseResult responseResult = new ResponseResult(0, "");
        try (BufferedReader reader = req.getReader();){
            String configJsonStr = IOUtils.toString((Reader)reader);
            LOGGER.info("Getting request {}", (Object)configJsonStr);
            if (pathInfo.endsWith(JOB_TYPE)) {
                this.handleJob(configJsonStr);
            } else if (pathInfo.endsWith(AGENT_TYPE)) {
                this.handleAgent(configJsonStr);
            } else {
                responseResult.setCode(-1).setMessage("child path is not correct");
            }
        }
        catch (Exception ex) {
            LOGGER.error("error while handle post", (Throwable)ex);
            responseResult.setCode(-1).setMessage(ex.getMessage());
        }
        this.responseToJson(resp, responseResult);
    }
}

