/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.conf;

import java.io.Closeable;
import javax.servlet.Servlet;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.core.conf.ConfigServlet;
import org.apache.inlong.agent.core.job.JobManager;
import org.apache.inlong.agent.core.trigger.TriggerManager;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigJetty
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigJetty.class);
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    private final Server server;
    private final JobManager jobManager;
    private final TriggerManager triggerManager;

    public ConfigJetty(JobManager jobManager, TriggerManager triggerManager) {
        this.jobManager = jobManager;
        this.triggerManager = triggerManager;
        this.server = new Server();
        try {
            this.initJetty();
        }
        catch (Exception ex) {
            LOGGER.error("exception caught", (Throwable)ex);
        }
    }

    private void initJetty() throws Exception {
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.conf.getInt("agent.http.port", 8008));
        this.server.setConnectors(new Connector[]{connector});
        ServletHandler servletHandler = new ServletHandler();
        ServletHolder holder = new ServletHolder((Servlet)new ConfigServlet(this));
        servletHandler.addServletWithMapping(holder, "/config/*");
        this.server.setHandler((Handler)servletHandler);
        this.server.start();
    }

    public void storeJobConf(JobProfile jobProfile) {
        if (jobProfile != null) {
            if (jobProfile.hasKey("job.fileJob.trigger")) {
                this.triggerManager.submitTrigger(TriggerProfile.parseJsonStr((String)jobProfile.toJsonStr()), true);
            } else {
                TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)jobProfile.getInt("job.sourceType"));
                switch (taskType) {
                    case FILE: {
                        this.jobManager.submitFileJobProfile(jobProfile);
                        break;
                    }
                    case KAFKA: 
                    case BINLOG: 
                    case SQL: {
                        this.jobManager.submitJobProfile(jobProfile, true, true);
                        break;
                    }
                    default: {
                        LOGGER.error("source type not supported {}", (Object)taskType);
                    }
                }
            }
        }
    }

    public void storeAgentConf(String confJsonStr) {
        AgentConfiguration conf = AgentConfiguration.getAgentConf();
        conf.loadJsonStrResource(confJsonStr);
        conf.flushToLocalPropertiesFile();
    }

    public void deleteJobConf(JobProfile jobProfile) {
        if (jobProfile != null) {
            if (jobProfile.hasKey("job.fileJob.trigger")) {
                this.triggerManager.deleteTrigger(TriggerProfile.parseJobProfile((JobProfile)jobProfile).getTriggerId(), false);
            } else {
                this.jobManager.deleteJob(jobProfile.getInstanceId(), false);
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception ex) {
            LOGGER.error("exception caught", (Throwable)ex);
        }
    }
}

