/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.core.job.Job;
import org.apache.inlong.agent.core.job.JobManager;
import org.apache.inlong.agent.core.job.JobWrapper;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.HttpManager;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.ComponentTypeEnum;
import org.apache.inlong.common.enums.NodeSrvStatus;
import org.apache.inlong.common.heartbeat.AbstractHeartbeatManager;
import org.apache.inlong.common.heartbeat.GroupHeartbeat;
import org.apache.inlong.common.heartbeat.HeartbeatMsg;
import org.apache.inlong.common.heartbeat.StreamHeartbeat;
import org.apache.inlong.common.pojo.agent.TaskSnapshotMessage;
import org.apache.inlong.common.pojo.agent.TaskSnapshotRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatManager
extends AbstractDaemon
implements AbstractHeartbeatManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatManager.class);
    public static final int PRINT_MEMORY_PERMIT_INTERVAL_SECOND = 60;
    private static HeartbeatManager heartbeatManager = null;
    private final JobManager jobmanager;
    private final AgentConfiguration conf;
    private final HttpManager httpManager;
    private final String baseManagerUrl;
    private final String reportSnapshotUrl;
    private final String reportHeartbeatUrl;
    private final Pattern numberPattern = Pattern.compile("^[-+]?[\\d]*$");

    private HeartbeatManager(AgentManager agentManager) {
        this.conf = AgentConfiguration.getAgentConf();
        this.jobmanager = agentManager.getJobManager();
        this.httpManager = new HttpManager(this.conf);
        this.baseManagerUrl = HttpManager.buildBaseUrl();
        this.reportSnapshotUrl = this.buildReportSnapShotUrl(this.baseManagerUrl);
        this.reportHeartbeatUrl = this.buildReportHeartbeatUrl(this.baseManagerUrl);
    }

    private HeartbeatManager() {
        this.conf = AgentConfiguration.getAgentConf();
        this.httpManager = new HttpManager(this.conf);
        this.baseManagerUrl = HttpManager.buildBaseUrl();
        this.reportSnapshotUrl = this.buildReportSnapShotUrl(this.baseManagerUrl);
        this.reportHeartbeatUrl = this.buildReportHeartbeatUrl(this.baseManagerUrl);
        this.jobmanager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HeartbeatManager getInstance(AgentManager agentManager) {
        if (heartbeatManager != null) return heartbeatManager;
        Class<HeartbeatManager> clazz = HeartbeatManager.class;
        synchronized (HeartbeatManager.class) {
            if (heartbeatManager != null) return heartbeatManager;
            heartbeatManager = new HeartbeatManager(agentManager);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return heartbeatManager;
        }
    }

    public static HeartbeatManager getInstance() {
        if (heartbeatManager == null) {
            throw new RuntimeException("HeartbeatManager has not been initialized by agentManager");
        }
        return heartbeatManager;
    }

    public void start() throws Exception {
        this.submitWorker(this.snapshotReportThread());
        this.submitWorker(this.heartbeatReportThread());
        this.submitWorker(this.printMemoryPermitThread());
    }

    private Runnable printMemoryPermitThread() {
        return () -> {
            while (this.isRunnable()) {
                MemoryManager.getInstance().printAll();
                AgentUtils.silenceSleepInSeconds((long)60L);
            }
        };
    }

    private Runnable snapshotReportThread() {
        return () -> {
            while (this.isRunnable()) {
                try {
                    TaskSnapshotRequest taskSnapshotRequest = this.buildTaskSnapshotRequest();
                    this.httpManager.doSentPost(this.reportSnapshotUrl, (Object)taskSnapshotRequest);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" {} report snapshot to manager", (Object)taskSnapshotRequest);
                    }
                    TimeUnit.SECONDS.sleep(this.conf.getInt("agent.heartbeat.interval", 10));
                }
                catch (Throwable e) {
                    LOGGER.error("interrupted while report snapshot", e);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
                }
            }
        };
    }

    private Runnable heartbeatReportThread() {
        return () -> {
            while (this.isRunnable()) {
                try {
                    HeartbeatMsg heartbeatMsg = this.buildHeartbeatMsg();
                    this.reportHeartbeat(heartbeatMsg);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" {} report heartbeat to manager", (Object)heartbeatMsg);
                    }
                    TimeUnit.SECONDS.sleep(this.heartbeatInterval());
                }
                catch (Throwable e) {
                    LOGGER.error("interrupted while report heartbeat", e);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
                }
            }
        };
    }

    public void stop() throws Exception {
        this.waitForTerminate();
    }

    public void reportHeartbeat(HeartbeatMsg heartbeat) {
        this.httpManager.doSentPost(this.reportHeartbeatUrl, (Object)heartbeat);
    }

    private TaskSnapshotRequest buildTaskSnapshotRequest() {
        Map<String, JobWrapper> jobWrapperMap = this.jobmanager.getJobs();
        ArrayList<TaskSnapshotMessage> taskSnapshotMessageList = new ArrayList<TaskSnapshotMessage>();
        TaskSnapshotRequest taskSnapshotRequest = new TaskSnapshotRequest();
        Date date = new Date(System.currentTimeMillis());
        for (Map.Entry<String, JobWrapper> entry : jobWrapperMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)entry.getKey()) || entry.getValue() == null) {
                LOGGER.info("key: {} or value: {} is null", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            String offset = entry.getValue().getSnapshot();
            String jobId = entry.getKey();
            TaskSnapshotMessage snapshotMessage = new TaskSnapshotMessage();
            snapshotMessage.setSnapshot(offset);
            if (!this.numberPattern.matcher(jobId).matches()) continue;
            snapshotMessage.setJobId(Integer.valueOf(jobId));
            taskSnapshotMessageList.add(snapshotMessage);
        }
        taskSnapshotRequest.setSnapshotList(taskSnapshotMessageList);
        taskSnapshotRequest.setReportTime(date);
        taskSnapshotRequest.setAgentIp(AgentUtils.fetchLocalIp());
        taskSnapshotRequest.setUuid(AgentUtils.fetchLocalUuid());
        return taskSnapshotRequest;
    }

    private HeartbeatMsg buildHeartbeatMsg() {
        String agentIp = AgentUtils.fetchLocalIp();
        int agentPort = this.conf.getInt("agent.http.port", 8008);
        String clusterName = this.conf.get("agent.cluster.name");
        String clusterTag = this.conf.get("agent.cluster.tag");
        String inCharges = this.conf.get("agent.cluster.inCharges");
        String nodeGroup = this.conf.get("agent.node.group");
        HeartbeatMsg heartbeatMsg = new HeartbeatMsg();
        heartbeatMsg.setIp(agentIp);
        heartbeatMsg.setPort(String.valueOf(agentPort));
        heartbeatMsg.setComponentType(ComponentTypeEnum.Agent.getType());
        heartbeatMsg.setReportTime(Long.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotBlank((CharSequence)clusterName)) {
            heartbeatMsg.setClusterName(clusterName);
        }
        if (StringUtils.isNotBlank((CharSequence)clusterTag)) {
            heartbeatMsg.setClusterTag(clusterTag);
        }
        if (StringUtils.isNotBlank((CharSequence)inCharges)) {
            heartbeatMsg.setInCharges(inCharges);
        }
        if (StringUtils.isNotBlank((CharSequence)nodeGroup)) {
            heartbeatMsg.setNodeGroup(nodeGroup);
        }
        Map<String, JobWrapper> jobWrapperMap = this.jobmanager.getJobs();
        ArrayList groupHeartbeats = Lists.newArrayList();
        ArrayList streamHeartbeats = Lists.newArrayList();
        jobWrapperMap.values().forEach(jobWrapper -> {
            Job job = jobWrapper.getJob();
            JobProfile jobProfile = job.getJobConf();
            String groupId = jobProfile.get("job.groupId");
            String streamId = jobProfile.get("job.streamId");
            State currentState = jobWrapper.getCurrentState();
            String status = currentState.name();
            GroupHeartbeat groupHeartbeat = new GroupHeartbeat();
            groupHeartbeat.setInlongGroupId(groupId);
            groupHeartbeat.setStatus(status);
            groupHeartbeats.add(groupHeartbeat);
            StreamHeartbeat streamHeartbeat = new StreamHeartbeat();
            streamHeartbeat.setInlongGroupId(groupId);
            streamHeartbeat.setInlongStreamId(streamId);
            streamHeartbeat.setStatus(status);
            streamHeartbeats.add(streamHeartbeat);
        });
        heartbeatMsg.setGroupHeartbeats((List)groupHeartbeats);
        heartbeatMsg.setStreamHeartbeats((List)streamHeartbeats);
        return heartbeatMsg;
    }

    private HeartbeatMsg buildDeadHeartbeatMsg() {
        HeartbeatMsg heartbeatMsg = new HeartbeatMsg();
        heartbeatMsg.setNodeSrvStatus(NodeSrvStatus.SERVICE_UNINSTALL);
        heartbeatMsg.setInCharges(this.conf.get("agent.cluster.inCharges"));
        heartbeatMsg.setIp(AgentUtils.fetchLocalIp());
        heartbeatMsg.setPort(String.valueOf(this.conf.getInt("agent.http.port", 8008)));
        heartbeatMsg.setComponentType(ComponentTypeEnum.Agent.getType());
        heartbeatMsg.setClusterName(this.conf.get("agent.cluster.name"));
        heartbeatMsg.setClusterTag(this.conf.get("agent.cluster.tag"));
        return heartbeatMsg;
    }

    private String buildReportSnapShotUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.reportsnapshot.http.path", "/agent/reportSnapshot");
    }

    private String buildReportHeartbeatUrl(String baseUrl) {
        return baseUrl + this.conf.get("agent.manager.heartbeat.http.path", "/heartbeat/report");
    }

    public static void main(String[] args) throws Exception {
        HeartbeatManager heartbeatManager = new HeartbeatManager();
        heartbeatManager.reportHeartbeat(heartbeatManager.buildDeadHeartbeatMsg());
        System.out.println("Success send dead heartbeat message to manager.");
    }
}

