/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.conf.ProfileFetcher;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.core.HeartbeatManager;
import org.apache.inlong.agent.core.conf.ConfigJetty;
import org.apache.inlong.agent.core.job.JobManager;
import org.apache.inlong.agent.core.task.PositionManager;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.agent.core.trigger.TriggerManager;
import org.apache.inlong.agent.db.CommandDb;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.db.JobProfileDb;
import org.apache.inlong.agent.db.LocalProfile;
import org.apache.inlong.agent.db.TriggerProfileDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentManager.class);
    private final JobManager jobManager;
    private final TaskManager taskManager;
    private final TriggerManager triggerManager;
    private final PositionManager positionManager;
    private final HeartbeatManager heartbeatManager;
    private final ProfileFetcher fetcher;
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    private final ExecutorService agentConfMonitor = Executors.newSingleThreadExecutor();
    private final Db db = this.initDb();
    private final LocalProfile localProfile;
    private final CommandDb commandDb = new CommandDb(this.db);
    private final JobProfileDb jobProfileDb = new JobProfileDb(this.db);
    private ConfigJetty configJetty;

    public AgentManager() {
        String parentConfPath = this.conf.get("agent.conf.parent", "conf");
        this.localProfile = new LocalProfile(parentConfPath);
        this.triggerManager = new TriggerManager(this, new TriggerProfileDb(this.db));
        this.jobManager = new JobManager(this, this.jobProfileDb);
        this.taskManager = new TaskManager(this);
        this.fetcher = this.initFetcher(this);
        this.heartbeatManager = HeartbeatManager.getInstance(this);
        this.positionManager = PositionManager.getInstance(this);
        if (this.conf.getBoolean("agent.http.enable", false)) {
            this.configJetty = new ConfigJetty(this.jobManager, this.triggerManager);
        }
    }

    private ProfileFetcher initFetcher(AgentManager agentManager) {
        try {
            Constructor<?> constructor = Class.forName(this.conf.get("agent.fetcher.classname")).getDeclaredConstructor(AgentManager.class);
            constructor.setAccessible(true);
            return (ProfileFetcher)constructor.newInstance(new Object[]{agentManager});
        }
        catch (Exception ex) {
            LOGGER.warn("cannot find fetcher: ", (Throwable)ex);
            return null;
        }
    }

    private Db initDb() {
        try {
            return (Db)Class.forName(this.conf.get("agent.db.classname", "org.apache.inlong.agent.db.RocksDbImp")).newInstance();
        }
        catch (Exception ex) {
            throw new UnsupportedClassVersionError(ex.getMessage());
        }
    }

    private Runnable startHotConfReplace() {
        return new Runnable(){
            private long lastModifiedTime = 0L;

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                            File file = new File(AgentManager.this.conf.getConfigLocation("agent.properties").getFile());
                            if (!file.exists() || file.lastModified() <= this.lastModifiedTime) continue;
                            AgentManager.this.conf.reloadFromLocalPropertiesFile();
                            this.lastModifiedTime = file.lastModified();
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Interrupted when flush agent conf.", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public Db getDb() {
        return this.db;
    }

    public JobProfileDb getJobProfileDb() {
        return this.jobProfileDb;
    }

    public ProfileFetcher getFetcher() {
        return this.fetcher;
    }

    public CommandDb getCommandDb() {
        return this.commandDb;
    }

    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    public PositionManager getTaskPositionManager() {
        return this.positionManager;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public HeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public void join() {
        super.join();
        this.jobManager.join();
        this.taskManager.join();
    }

    public void start() throws Exception {
        LOGGER.info("starting agent manager");
        this.agentConfMonitor.submit(this.startHotConfReplace());
        LOGGER.info("starting job manager");
        this.jobManager.start();
        LOGGER.info("starting trigger manager");
        this.triggerManager.start();
        LOGGER.info("starting task manager");
        this.taskManager.start();
        LOGGER.info("starting heartbeat manager");
        this.heartbeatManager.start();
        LOGGER.info("starting task position manager");
        this.positionManager.start();
        LOGGER.info("starting read job from local");
        List profileList = this.localProfile.readFromLocal();
        for (JobProfile profile : profileList) {
            if (profile.hasKey("job.fileJob.trigger")) {
                TriggerProfile triggerProfile = TriggerProfile.parseJobProfile((JobProfile)profile);
                this.triggerManager.restoreTrigger(triggerProfile);
                continue;
            }
            this.jobManager.submitFileJobProfile(profile);
        }
        LOGGER.info("starting fetcher");
        if (this.fetcher != null) {
            this.fetcher.start();
        }
        LOGGER.info("starting agent manager end");
    }

    public void stop() throws Exception {
        if (this.configJetty != null) {
            this.configJetty.close();
        }
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        LOGGER.info("stopping agent manager");
        this.triggerManager.stop();
        this.jobManager.stop();
        this.taskManager.stop();
        this.heartbeatManager.stop();
        this.positionManager.stop();
        this.agentConfMonitor.shutdown();
        this.db.close();
    }
}

