/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.common.metric.MetricObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentMain.class);

    private static void help(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("inlong-agent", opts);
        System.exit(0);
    }

    public static CommandLine initOptions(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("h", "help", false, "show help");
        try {
            return parser.parse(options, args);
        }
        catch (Exception ex) {
            AgentMain.help(options);
            return null;
        }
    }

    public static void initAgentConf(CommandLine cl) {
        AgentConfiguration conf = AgentConfiguration.getAgentConf();
        Iterator iterator = cl.iterator();
        while (iterator != null && iterator.hasNext()) {
            Option opt = (Option)iterator.next();
            if (opt == null || opt.getLongOpt() == null || opt.getValue() == null || !conf.hasKey(opt.getLongOpt())) continue;
            conf.set(opt.getLongOpt(), opt.getValue().trim());
        }
    }

    private static void stopAgentIfKilled(AgentManager agentManager) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                LOGGER.info("stopping agent gracefully");
                agentManager.stop();
                AuditUtils.send();
            }
            catch (Exception ex) {
                LOGGER.error("stop agent manager error: ", (Throwable)ex);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CommandLine cl = AgentMain.initOptions(args);
        assert (cl != null);
        AgentMain.initAgentConf(cl);
        AuditUtils.initAudit();
        AgentManager manager = new AgentManager();
        try {
            manager.start();
            AgentMain.stopAgentIfKilled(manager);
            MetricObserver.init((Map)AgentConfiguration.getAgentConf().getConfigProperties());
            manager.join();
        }
        catch (Exception ex) {
            LOGGER.error("agent running exception: ", (Throwable)ex);
        }
        finally {
            manager.stop();
        }
    }
}

