/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.common;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.RowTypeInfo;
import org.apache.inlong.sort.formats.common.TypeInfo;

public class RowFormatInfo
implements FormatInfo {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FIELD_NAMES = "fieldNames";
    private static final String FIELD_FIELD_FORMATS = "fieldFormats";
    public static final RowFormatInfo EMPTY = new RowFormatInfo(new String[0], new FormatInfo[0]);
    @JsonProperty(value="fieldNames")
    @Nonnull
    private final String[] fieldNames;
    @JsonProperty(value="fieldFormats")
    @Nonnull
    private final FormatInfo[] fieldFormatInfos;

    @JsonCreator
    public RowFormatInfo(@JsonProperty(value="fieldNames") @Nonnull String[] fieldNames, @JsonProperty(value="fieldFormats") @Nonnull FormatInfo[] fieldFormatInfos) {
        RowFormatInfo.checkArity(fieldNames, fieldFormatInfos);
        RowFormatInfo.checkDuplicates(fieldNames);
        this.fieldNames = fieldNames;
        this.fieldFormatInfos = fieldFormatInfos;
    }

    @Nonnull
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Nonnull
    public FormatInfo[] getFieldFormatInfos() {
        return this.fieldFormatInfos;
    }

    @Override
    public RowTypeInfo getTypeInfo() {
        TypeInfo[] fieldTypeInfos = new TypeInfo[this.fieldFormatInfos.length];
        for (int i = 0; i < this.fieldFormatInfos.length; ++i) {
            fieldTypeInfos[i] = this.fieldFormatInfos[i].getTypeInfo();
        }
        return new RowTypeInfo(this.fieldNames, fieldTypeInfos);
    }

    private static void checkArity(String[] fieldNames, FormatInfo[] fieldFormatInfos) {
        if (fieldNames.length != fieldFormatInfos.length) {
            throw new IllegalArgumentException("The number of names and formats is not equal.");
        }
    }

    private static void checkDuplicates(String[] fieldNames) {
        long numFieldNames = fieldNames.length;
        long numDistinctFieldNames = Arrays.stream(fieldNames).collect(Collectors.toSet()).size();
        if (numDistinctFieldNames != numFieldNames) {
            throw new IllegalArgumentException("There exist duplicated field names.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowFormatInfo that = (RowFormatInfo)o;
        return Arrays.equals(this.fieldFormatInfos, that.fieldFormatInfos);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldFormatInfos);
    }

    public String toString() {
        return "RowFormatInfo{fieldFormatInfos=" + Arrays.toString(this.fieldFormatInfos) + '}';
    }
}

