/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodebroker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.utils.SerialIdUtils;

public class BrokerTopicInfoView {
    public AtomicLong topicChangeId = new AtomicLong(0L);
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, TopicInfo>> topicConfInfoMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ConcurrentHashSet<String>> brokerIdIndexMap = new ConcurrentHashMap();

    public void updBrokerTopicConfInfo(int brokerId, Map<String, TopicInfo> topicInfoMap) {
        if (topicInfoMap == null) {
            return;
        }
        this.rmvBrokerTopicInfo(brokerId, topicInfoMap);
        this.repBrokerTopicInfo(brokerId, topicInfoMap);
        SerialIdUtils.updTimeStampSerialIdValue(this.topicChangeId);
    }

    public boolean fastUpdBrokerTopicConfInfo(int brokerId, Map<String, TopicInfo> topicInfoMap) {
        if (topicInfoMap == null) {
            return true;
        }
        this.rmvBrokerTopicInfo(brokerId, topicInfoMap);
        Tuple2<Boolean, Boolean> retTuple = this.updBrokerTopicInfo(brokerId, topicInfoMap);
        SerialIdUtils.updTimeStampSerialIdValue(this.topicChangeId);
        return (Boolean)retTuple.getF1();
    }

    public int getMaxTopicBrokerCnt(Set<String> topicSet, Set<Integer> enableSubBrokerIdSet) {
        int maxCount = -1;
        if (topicSet == null || topicSet.isEmpty()) {
            return maxCount;
        }
        for (String topic : topicSet) {
            ConcurrentHashMap<Integer, TopicInfo> topicInfoView;
            if (topic == null || (topicInfoView = this.topicConfInfoMap.get(topic)) == null || topicInfoView.isEmpty()) continue;
            int tmpSize = 0;
            for (TopicInfo topicInfo : topicInfoView.values()) {
                if (topicInfo == null || !enableSubBrokerIdSet.contains(topicInfo.getBrokerId())) continue;
                ++tmpSize;
            }
            if (maxCount >= tmpSize) continue;
            maxCount = tmpSize;
        }
        return maxCount;
    }

    public Map<String, Partition> getAcceptSubParts(Set<String> topicSet, Set<Integer> enableSubBrokerIdSet) {
        HashMap<String, Partition> partMap = new HashMap<String, Partition>();
        if (topicSet == null || topicSet.isEmpty()) {
            return partMap;
        }
        for (String topic : topicSet) {
            List<Partition> tmpPartList = this.getAcceptSubParts(topic, enableSubBrokerIdSet);
            for (Partition partition : tmpPartList) {
                partMap.put(partition.getPartitionKey(), partition);
            }
        }
        return partMap;
    }

    public List<Partition> getAcceptSubParts(String topic, Set<Integer> enableSubBrokerIdSet) {
        ArrayList<Partition> partList = new ArrayList<Partition>();
        if (topic == null) {
            return partList;
        }
        ConcurrentHashMap<Integer, TopicInfo> topicInfoView = this.topicConfInfoMap.get(topic);
        if (topicInfoView == null || topicInfoView.isEmpty()) {
            return partList;
        }
        for (Map.Entry<Integer, TopicInfo> entry : topicInfoView.entrySet()) {
            TopicInfo topicInfo;
            if (entry.getKey() == null || entry.getValue() == null || !enableSubBrokerIdSet.contains(entry.getKey()) || !(topicInfo = entry.getValue()).isAcceptSubscribe()) continue;
            for (int j = 0; j < topicInfo.getTopicStoreNum(); ++j) {
                int baseValue = j * 10000;
                for (int i = 0; i < topicInfo.getPartitionNum(); ++i) {
                    partList.add(new Partition(topicInfo.getBroker(), topicInfo.getTopic(), baseValue + i));
                }
            }
        }
        return partList;
    }

    public Map<String, String> getAcceptPubPartInfo(Map<String, Integer> topicSizeMap, Set<Integer> enablePubBrokerIdSet) {
        StringBuilder confValue;
        HashMap<String, String> topicPartStrMap = new HashMap<String, String>();
        HashMap<String, StringBuilder> topicPartBufferMap = new HashMap<String, StringBuilder>();
        if (topicSizeMap == null || topicSizeMap.isEmpty()) {
            return topicPartStrMap;
        }
        for (String topic : topicSizeMap.keySet()) {
            ConcurrentHashMap<Integer, TopicInfo> topicInfoView = this.topicConfInfoMap.get(topic);
            if (topicInfoView == null || topicInfoView.isEmpty()) continue;
            for (Map.Entry<Integer, TopicInfo> entry : topicInfoView.entrySet()) {
                TopicInfo topicInfo;
                if (entry.getKey() == null || entry.getValue() == null || !enablePubBrokerIdSet.contains(entry.getKey()) || !(topicInfo = entry.getValue()).isAcceptPublish()) continue;
                confValue = (StringBuilder)topicPartBufferMap.get(topic);
                if (confValue == null) {
                    StringBuilder tmpValue = new StringBuilder(512).append(topic).append("#").append(topicInfo.getSimpleValue());
                    topicPartBufferMap.put(topic, tmpValue);
                    continue;
                }
                confValue.append(",").append(topicInfo.getSimpleValue());
            }
        }
        for (Map.Entry entry : topicPartBufferMap.entrySet()) {
            if (entry.getValue() == null) continue;
            confValue = (StringBuilder)topicPartBufferMap.get(entry.getKey());
            Integer maxMsgSize = topicSizeMap.get(entry.getKey());
            if (maxMsgSize == null) {
                topicPartStrMap.put((String)entry.getKey(), confValue.append("#").toString());
                continue;
            }
            topicPartStrMap.put((String)entry.getKey(), confValue.append("#").append(maxMsgSize).toString());
        }
        topicPartBufferMap.clear();
        return topicPartStrMap;
    }

    public TopicInfo getBrokerPushedTopicInfo(int brokerId, String topic) {
        ConcurrentHashMap<Integer, TopicInfo> topicInfoView = this.topicConfInfoMap.get(topic);
        if (topicInfoView == null) {
            return null;
        }
        return topicInfoView.get(brokerId);
    }

    public List<TopicInfo> getBrokerPushedTopicInfo(int brokerId) {
        ArrayList<TopicInfo> topicInfoList = new ArrayList<TopicInfo>();
        ConcurrentHashSet<String> topicSet = this.brokerIdIndexMap.get(brokerId);
        if (topicSet == null) {
            return topicInfoList;
        }
        for (String topic : topicSet) {
            TopicInfo topicInfo;
            ConcurrentHashMap<Integer, TopicInfo> topicInfoView;
            if (topic == null || (topicInfoView = this.topicConfInfoMap.get(topic)) == null || topicInfoView.isEmpty() || (topicInfo = topicInfoView.get(brokerId)) == null) continue;
            topicInfoList.add(topicInfo);
        }
        return topicInfoList;
    }

    public void rmvBrokerTopicInfo(int brokerId) {
        ConcurrentHashSet<String> topicSet = this.brokerIdIndexMap.remove(brokerId);
        if (topicSet == null || topicSet.isEmpty()) {
            return;
        }
        for (String topic : topicSet) {
            ConcurrentHashMap<Integer, TopicInfo> topicInfoView;
            if (topic == null || (topicInfoView = this.topicConfInfoMap.get(topic)) == null || topicInfoView.isEmpty()) continue;
            topicInfoView.remove(brokerId);
        }
        SerialIdUtils.updTimeStampSerialIdValue(this.topicChangeId);
    }

    private boolean rmvBrokerTopicInfo(int brokerId, Map<String, TopicInfo> topicInfoMap) {
        boolean changed = false;
        HashSet<String> delTopicSet = new HashSet<String>();
        ConcurrentHashSet<String> curTopicSet = this.brokerIdIndexMap.get(brokerId);
        if (curTopicSet != null) {
            for (String topic : curTopicSet) {
                if (topicInfoMap.containsKey(topic)) continue;
                delTopicSet.add(topic);
            }
        }
        if (delTopicSet.isEmpty()) {
            return false;
        }
        ConcurrentHashSet<String> topicSet = this.brokerIdIndexMap.get(brokerId);
        if (topicSet == null || topicSet.isEmpty()) {
            return changed;
        }
        for (String topic : delTopicSet) {
            ConcurrentHashMap<Integer, TopicInfo> topicInfoView;
            if (topicSet.remove((Object)topic)) {
                changed = true;
            }
            if ((topicInfoView = this.topicConfInfoMap.get(topic)) == null || topicInfoView.isEmpty() || topicInfoView.remove(brokerId) == null) continue;
            changed = true;
        }
        return changed;
    }

    private void repBrokerTopicInfo(int brokerId, Map<String, TopicInfo> topicInfoMap) {
        if (topicInfoMap == null || topicInfoMap.isEmpty()) {
            return;
        }
        for (TopicInfo topicInfo : topicInfoMap.values()) {
            if (topicInfo == null) continue;
            ConcurrentHashMap<Integer, Object> curTopicInfoView = this.topicConfInfoMap.get(topicInfo.getTopic());
            if (curTopicInfoView == null) {
                ConcurrentHashMap newTopicInfoView = new ConcurrentHashMap();
                curTopicInfoView = this.topicConfInfoMap.putIfAbsent(topicInfo.getTopic(), newTopicInfoView);
                if (curTopicInfoView == null) {
                    curTopicInfoView = newTopicInfoView;
                }
            }
            curTopicInfoView.put(brokerId, topicInfo.clone());
        }
        ConcurrentHashSet<String> curTopicSet = this.brokerIdIndexMap.get(brokerId);
        if (curTopicSet == null) {
            ConcurrentHashSet<String> newTopicSet = new ConcurrentHashSet();
            curTopicSet = this.brokerIdIndexMap.putIfAbsent(brokerId, newTopicSet);
            if (curTopicSet == null) {
                curTopicSet = newTopicSet;
            }
        }
        curTopicSet.addAll(topicInfoMap.keySet());
    }

    private Tuple2<Boolean, Boolean> updBrokerTopicInfo(int brokerId, Map<String, TopicInfo> topicInfoMap) {
        boolean isChanged = false;
        boolean isFastSync = true;
        Tuple2 retResult = new Tuple2();
        if (topicInfoMap == null || topicInfoMap.isEmpty()) {
            retResult.setF0AndF1((Object)isChanged, (Object)isFastSync);
            return retResult;
        }
        for (TopicInfo newTopicInfo : topicInfoMap.values()) {
            if (newTopicInfo == null) continue;
            ConcurrentHashMap<Integer, TopicInfo> curTopicInfoView = this.topicConfInfoMap.get(newTopicInfo.getTopic());
            if (curTopicInfoView == null) {
                isFastSync = false;
                continue;
            }
            TopicInfo curTopicInfo = curTopicInfoView.get(brokerId);
            if (curTopicInfo == null) {
                isFastSync = false;
                continue;
            }
            curTopicInfo.updAndJudgeTopicInfo(newTopicInfo, retResult);
            if (((Boolean)retResult.getF0()).booleanValue() && !isChanged) {
                isChanged = true;
            }
            if (!((Boolean)retResult.getF1()).booleanValue() || !isFastSync) continue;
            isFastSync = false;
        }
        retResult.setF0AndF1((Object)isChanged, (Object)isFastSync);
        return retResult;
    }
}

