/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.fileconfig;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.inlong.tubemq.corebase.config.TLSConfig;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.exception.StartupException;
import org.apache.inlong.tubemq.server.common.fileconfig.ADConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.PrometheusConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.ZKConfig;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileConfig {
    protected static final String SECT_TOKEN_MASTER = "master";
    protected static final String SECT_TOKEN_BROKER = "broker";
    protected static final String SECT_TOKEN_BDB = "bdbStore";
    protected static final String SECT_TOKEN_TLS = "tlsSetting";
    protected static final String SECT_TOKEN_ZKEEPER = "zookeeper";
    protected static final String SECT_TOKEN_REPLICATION = "replication";
    protected static final String SECT_TOKEN_META_BDB = "meta_bdb";
    protected static final String SECT_TOKEN_META_ZK = "meta_zookeeper";
    protected static final String SECT_TOKEN_META_AUDIT = "audit";
    protected static final String SECT_TOKEN_META_PROMETHEUS = "prometheus";
    private static final Logger logger = LoggerFactory.getLogger(AbstractFileConfig.class);
    private String basePath;
    private String configPath;
    private long loadFileChkSum = -1L;
    private long loadFileModified = -1L;

    public String getBasePath() {
        return this.basePath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public long getLoadFileChkSum() {
        return this.loadFileChkSum;
    }

    public long getLoadFileModified() {
        return this.loadFileModified;
    }

    public void loadFromFile(String path) {
        this.configPath = path;
        this.load();
    }

    public void reload() {
        this.load();
    }

    public int getInt(Profile.Section section, String key, int defaultValue) {
        String value = (String)section.get((Object)key);
        if (TStringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Integer.parseInt(" + value + ") failure for key=" + key);
            return defaultValue;
        }
    }

    public int getInt(Profile.Section section, String key) {
        String value = (String)section.get((Object)key);
        if (TStringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Blank value for ").append(key).toString());
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Translate key(").append(key).append(")'s value ").append(value).append(" to int failure!").toString());
        }
    }

    public boolean getBoolean(Profile.Section section, String key) {
        String value = (String)section.get((Object)key);
        if (TStringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Blank value for ").append(key).toString());
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Translate key(").append(key).append(")'s value ").append(value).append(" to boolean failure!").toString());
        }
    }

    public long getLong(Profile.Section section, String key) {
        String value = (String)section.get((Object)key);
        if (TStringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Blank value for ").append(key).toString());
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Translate key(").append(key).append(")'s value ").append(value).append(" to long failure!").toString());
        }
    }

    public void getSimilarConfigField(String section, Set<String> configFields, String checkItem) {
        if (!configFields.contains(checkItem)) {
            String best = this.findBestMatchField(configFields, checkItem);
            throw new IllegalArgumentException(new StringBuilder(256).append("Config item ").append(checkItem).append(" is Required! in section ").append(section).append("! (a similar item :").append(best).append(" found)").toString());
        }
    }

    protected TLSConfig loadTlsSectConf(Ini iniConf, int defTlsPort) {
        TLSConfig tlsConfig = new TLSConfig();
        tlsConfig.setTlsPort(defTlsPort);
        Profile.Section tlsSect = (Profile.Section)iniConf.get((Object)SECT_TOKEN_TLS);
        if (tlsSect == null) {
            return tlsConfig;
        }
        Set configKeySet = tlsSect.keySet();
        if (configKeySet.isEmpty()) {
            return tlsConfig;
        }
        if (TStringUtils.isNotBlank((String)((String)tlsSect.get((Object)"tlsEnable")))) {
            tlsConfig.setTlsEnable(this.getBoolean(tlsSect, "tlsEnable"));
        }
        if (tlsConfig.isTlsEnable()) {
            tlsConfig.setTlsPort(this.getInt(tlsSect, "tlsPort", defTlsPort));
            if (TStringUtils.isBlank((String)((String)tlsSect.get((Object)"tlsKeyStorePath")))) {
                this.getSimilarConfigField(SECT_TOKEN_TLS, configKeySet, "tlsKeyStorePath");
            } else {
                tlsConfig.setTlsKeyStorePath(((String)tlsSect.get((Object)"tlsKeyStorePath")).trim());
            }
            if (TStringUtils.isBlank((String)((String)tlsSect.get((Object)"tlsKeyStorePassword")))) {
                this.getSimilarConfigField(SECT_TOKEN_TLS, configKeySet, "tlsKeyStorePassword");
            } else {
                tlsConfig.setTlsKeyStorePassword(((String)tlsSect.get((Object)"tlsKeyStorePassword")).trim());
            }
            if (TStringUtils.isNotBlank((String)((String)tlsSect.get((Object)"tlsTwoWayAuthEnable")))) {
                tlsConfig.setTlsTwoWayAuthEnable(this.getBoolean(tlsSect, "tlsTwoWayAuthEnable"));
            }
            if (tlsConfig.isTlsTwoWayAuthEnable()) {
                if (TStringUtils.isBlank((String)((String)tlsSect.get((Object)"tlsTrustStorePath")))) {
                    this.getSimilarConfigField(SECT_TOKEN_TLS, configKeySet, "tlsTrustStorePath");
                } else {
                    tlsConfig.setTlsTrustStorePath(((String)tlsSect.get((Object)"tlsTrustStorePath")).trim());
                }
                if (TStringUtils.isBlank((String)((String)tlsSect.get((Object)"tlsTrustStorePassword")))) {
                    this.getSimilarConfigField(SECT_TOKEN_TLS, configKeySet, "tlsTrustStorePassword");
                } else {
                    tlsConfig.setTlsTrustStorePassword(((String)tlsSect.get((Object)"tlsTrustStorePassword")).trim());
                }
            }
        }
        return tlsConfig;
    }

    protected ZKConfig loadZKeeperSectConf(Ini iniConf) {
        Profile.Section zkeeperSect = (Profile.Section)iniConf.get((Object)SECT_TOKEN_ZKEEPER);
        if (zkeeperSect == null) {
            throw new IllegalArgumentException(new StringBuilder(256).append(SECT_TOKEN_ZKEEPER).append(" configure section is required!").toString());
        }
        Set configKeySet = zkeeperSect.keySet();
        if (configKeySet.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Empty configure item in ").append(SECT_TOKEN_ZKEEPER).append(" section!").toString());
        }
        ZKConfig zkConfig = new ZKConfig();
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkServerAddr")))) {
            zkConfig.setZkServerAddr(((String)zkeeperSect.get((Object)"zkServerAddr")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkNodeRoot")))) {
            zkConfig.setZkNodeRoot(((String)zkeeperSect.get((Object)"zkNodeRoot")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkSessionTimeoutMs")))) {
            zkConfig.setZkSessionTimeoutMs(this.getInt(zkeeperSect, "zkSessionTimeoutMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkConnectionTimeoutMs")))) {
            zkConfig.setZkConnectionTimeoutMs(this.getInt(zkeeperSect, "zkConnectionTimeoutMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkSyncTimeMs")))) {
            zkConfig.setZkSyncTimeMs(this.getInt(zkeeperSect, "zkSyncTimeMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkCommitPeriodMs")))) {
            zkConfig.setZkCommitPeriodMs(this.getLong(zkeeperSect, "zkCommitPeriodMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkCommitFailRetries")))) {
            zkConfig.setZkCommitFailRetries(this.getInt(zkeeperSect, "zkCommitFailRetries"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkRequestTimeoutMs")))) {
            zkConfig.setZkRequestTimeoutMs(this.getInt(zkeeperSect, "zkRequestTimeoutMs"));
        }
        return zkConfig;
    }

    protected ADConfig loadAuditSectConf(Ini iniConf) {
        Profile.Section auditSect = (Profile.Section)iniConf.get((Object)SECT_TOKEN_META_AUDIT);
        ADConfig adConfig = new ADConfig();
        if (auditSect == null) {
            return adConfig;
        }
        Set configKeySet = auditSect.keySet();
        if (configKeySet.isEmpty()) {
            return adConfig;
        }
        if (TStringUtils.isNotBlank((String)((String)auditSect.get((Object)"auditEnable")))) {
            adConfig.setAuditEnable(this.getBoolean(auditSect, "auditEnable"));
        }
        if (TStringUtils.isNotBlank((String)((String)auditSect.get((Object)"auditProxyAddr")))) {
            String[] hostAndPortArray;
            ArrayList<String> auditAddrs = new ArrayList<String>();
            String auditProxyAddrs = ((String)auditSect.get((Object)"auditProxyAddr")).trim();
            if (!auditProxyAddrs.contains(":")) {
                throw new IllegalArgumentException("Illegal parameter: auditProxyAddr's value must like \"ip1:port,ip2:port\"!");
            }
            for (String addr : hostAndPortArray = auditProxyAddrs.split(",")) {
                if (TStringUtils.isBlank((String)addr)) {
                    throw new IllegalArgumentException("Illegal parameter: auditProxyAddr's value must like \"ip1:port,ip2:port\" and ip:port not Blank!");
                }
                String[] hostPortItem = addr.split(":");
                if (hostPortItem.length != 2) {
                    throw new IllegalArgumentException("Illegal parameter: auditProxyAddr's value must like \"ip1:port,ip2:port\"!");
                }
                String hostName = hostPortItem[0].trim();
                if (TStringUtils.isBlank((String)hostName)) {
                    throw new IllegalArgumentException("Illegal parameter: auditProxyAddr's value must like \"ip1:port,ip2:port\" and ip's value not Blank!");
                }
                if (TStringUtils.isBlank((String)hostPortItem[1])) {
                    throw new IllegalArgumentException("Illegal parameter: auditProxyAddr's value must like \"ip1:port,ip2:port\" and port's value not Blank!");
                }
                int port = Integer.parseInt(hostPortItem[1].trim());
                auditAddrs.add(hostName + ":" + String.valueOf(port));
            }
            Collections.sort(auditAddrs);
            adConfig.setAuditProxyAddrSet(auditAddrs);
        }
        if (TStringUtils.isNotBlank((String)((String)auditSect.get((Object)"auditCacheFilePath")))) {
            adConfig.setAuditCacheFilePath(((String)auditSect.get((Object)"auditCacheFilePath")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)auditSect.get((Object)"auditCacheMaxRows")))) {
            adConfig.setAuditCacheMaxRows(this.getInt(auditSect, "auditCacheMaxRows"));
        }
        if (TStringUtils.isNotBlank((String)((String)auditSect.get((Object)"auditIdProduce")))) {
            adConfig.setAuditIdProduce(this.getInt(auditSect, "auditIdProduce"));
        }
        if (TStringUtils.isNotBlank((String)((String)auditSect.get((Object)"auditIdConsume")))) {
            adConfig.setAuditIdConsume(this.getInt(auditSect, "auditIdConsume"));
        }
        return adConfig;
    }

    protected PrometheusConfig loadPrometheusSecConf(Ini iniConf) {
        Profile.Section promSect = (Profile.Section)iniConf.get((Object)SECT_TOKEN_META_PROMETHEUS);
        PrometheusConfig promConfig = new PrometheusConfig();
        if (promSect == null) {
            return promConfig;
        }
        Set configKeySet = promSect.keySet();
        if (configKeySet.isEmpty()) {
            return promConfig;
        }
        if (TStringUtils.isNotBlank((String)((String)promSect.get((Object)"promEnable")))) {
            promConfig.setPromEnable(this.getBoolean(promSect, "promEnable"));
        }
        if (TStringUtils.isNotBlank((String)((String)promSect.get((Object)"promClusterName")))) {
            promConfig.setPromClusterName(((String)promSect.get((Object)"promClusterName")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)promSect.get((Object)"promHttpPort")))) {
            promConfig.setPromHttpPort(this.getInt(promSect, "promHttpPort"));
        }
        return promConfig;
    }

    public String toString() {
        return new StringBuilder(512).append("\"loadFileAttr\":{\"basePath\":\"").append(this.basePath).append("\",\"configPath\":\"").append(this.configPath).append("\",\"loadFileChkSum\":").append(this.loadFileChkSum).append(",\"loadFileModified\":").append(this.loadFileModified).append("}").toString();
    }

    protected abstract void loadFileSectAttributes(Ini var1);

    private String findBestMatchField(Set<String> matchedSet, String checkItem) {
        String matchedField = null;
        int minDistance = Integer.MAX_VALUE;
        for (String matchItem : matchedSet) {
            int dis = TStringUtils.getLevenshteinDistance((String)checkItem, (String)matchItem);
            if (dis >= minDistance) continue;
            matchedField = matchItem;
            minDistance = dis;
        }
        return matchedField;
    }

    private void loadConfigAttributes(Ini iniConf) {
        this.loadFileSectAttributes(iniConf);
    }

    private void load() {
        try {
            File file = new File(this.configPath);
            if (!file.exists()) {
                throw new StartupException(new StringBuilder(256).append("File ").append(this.configPath).append(" is not exists").toString());
            }
            this.basePath = file.getParent() == null ? "" : file.getParent();
            Ini iniConf = this.createIni(file);
            this.loadConfigAttributes(iniConf);
        }
        catch (IOException e) {
            throw new StartupException(new StringBuilder(256).append("Parse configuration failed,path=").append(this.configPath).toString(), e);
        }
    }

    private Ini createIni(File file) throws IOException {
        Ini conf = new Ini(file);
        this.loadFileModified = file.lastModified();
        this.loadFileChkSum = FileUtils.checksumCRC32((File)file);
        return conf;
    }
}

