/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.DataConverterUtil;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStore;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStoreManager;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.GetMessageResult;
import org.apache.inlong.tubemq.server.broker.nodeinfo.ConsumerNodeInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetHistoryInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetService;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.broker.stats.BrokerStatsType;
import org.apache.inlong.tubemq.server.broker.utils.GroupOffsetInfo;
import org.apache.inlong.tubemq.server.broker.utils.TopicPubStoreInfo;
import org.apache.inlong.tubemq.server.broker.web.AbstractWebHandler;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;

public class BrokerAdminServlet
extends AbstractWebHandler {
    public BrokerAdminServlet(TubeBroker broker) {
        super(broker);
        this.registerWebApiMethod();
    }

    @Override
    public void registerWebApiMethod() {
        this.innRegisterWebMethod("admin_query_server_version", "adminQueryBrokerVersion", false);
        this.innRegisterWebMethod("admin_query_group_offset", "adminQueryCurrentGroupOffSet", false);
        this.innRegisterWebMethod("admin_snapshot_message", "adminQuerySnapshotMessageSet", false);
        this.innRegisterWebMethod("admin_get_group_detail_info", "adminQueryBrokerAllConsumerInfo", false);
        this.innRegisterWebMethod("admin_query_broker_all_consumer_info", "adminQueryBrokerAllConsumerInfo", false);
        this.innRegisterWebMethod("admin_query_broker_memstore_info", "adminGetMemStoreStatisInfo", false);
        this.innRegisterWebMethod("admin_query_broker_all_store_info", "adminQueryBrokerAllMessageStoreInfo", false);
        this.innRegisterWebMethod("admin_get_partition_reginfo", "adminQueryConsumerRegisterInfo", false);
        this.innRegisterWebMethod("admin_query_consumer_regmap", "adminQueryConsumerRegisterInfo", false);
        this.innRegisterWebMethod("admin_manual_set_current_offset", "adminManualSetCurrentOffSet", false);
        this.innRegisterWebMethod("admin_get_methods", "adminQueryAllMethods", false);
        this.innRegisterWebMethod("admin_query_pubinfo", "adminQueryPubInfo", false);
        this.innRegisterWebMethod("admin_get_booked_groupname", "adminQueryBookedGroup", false);
        this.innRegisterWebMethod("admin_query_group", "adminQueryBookedGroup", false);
        this.innRegisterWebMethod("admin_query_offset", "adminQueryGroupOffSet", false);
        this.innRegisterWebMethod("admin_clone_offset", "adminCloneGroupOffSet", false);
        this.innRegisterWebMethod("admin_set_offset", "adminSetGroupOffSet", false);
        this.innRegisterWebMethod("admin_set_offset_by_time", "adminSetGroupOffSetByTime", false);
        this.innRegisterWebMethod("admin_rmv_offset", "adminRemoveGroupOffSet", false);
        this.innRegisterWebMethod("admin_get_group_history_offset", "adminQueryGroupHistoryOffSet", false);
        this.innRegisterWebMethod("admin_get_metrics_info", "adminGetMetricsInfo", false);
        this.innRegisterWebMethod("admin_get_msgstore_stats", "adminGetMsgStoreStatsInfo", false);
        this.innRegisterWebMethod("admin_enable_stats", "adminEnableMetricsStats", false);
        this.innRegisterWebMethod("admin_disable_stats", "adminDisableMetricsStats", false);
        this.innRegisterWebMethod("admin_disable_all_stats", "adminDisableAllStats", false);
    }

    public void adminQueryAllMethods(HttpServletRequest req, StringBuilder sBuffer) {
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
        int totalCnt = this.getSupportedMethod(sBuffer);
        sBuffer.append("],\"totalCnt\":").append(totalCnt).append("}");
    }

    public void adminQueryBrokerVersion(HttpServletRequest req, StringBuilder sBuffer) {
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Ok\",\"data\":[").append("{\"version\":\"").append("1.8.0").append("\"}]}");
    }

    public void adminQueryBrokerAllConsumerInfo(HttpServletRequest req, StringBuilder strBuff) {
        int index = 0;
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return;
        }
        Set groupNameSet = (Set)result.getRetData();
        strBuff.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
        Map<String, ConsumerNodeInfo> map = this.broker.getBrokerServiceServer().getConsumerRegisterMap();
        for (Map.Entry<String, ConsumerNodeInfo> entry : map.entrySet()) {
            if (TStringUtils.isBlank((String)entry.getKey()) || entry.getValue() == null) continue;
            String[] partitionIdArr = entry.getKey().split(":");
            String groupName = partitionIdArr[0];
            if (!groupNameSet.isEmpty() && !groupNameSet.contains(groupName)) continue;
            String topicName = partitionIdArr[1];
            int partitionId = Integer.parseInt(partitionIdArr[2]);
            String consumerId = entry.getValue().getConsumerId();
            boolean ifFilterConsume = entry.getValue().isFilterConsume();
            if (index++ > 0) {
                strBuff.append(",");
            }
            strBuff.append("{\"index\":").append(index).append(",\"groupName\":\"").append(groupName).append("\",\"topicName\":\"").append(topicName).append("\",\"partitionId\":").append(partitionId);
            Long regTime = this.broker.getBrokerServiceServer().getConsumerRegisterTime(consumerId, entry.getKey());
            if (regTime == null || regTime <= 0L) {
                strBuff.append(",\"consumerId\":\"").append(consumerId).append("\",\"isRegOk\":false").append(",\"isFilterConsume\":").append(ifFilterConsume);
            } else {
                strBuff.append(",\"consumerId\":\"").append(consumerId).append("\",\"isRegOk\":true,\"lastRegTime\":").append(regTime).append(",\"isFilterConsume\":").append(ifFilterConsume);
            }
            strBuff.append(",\"receivedFrom\":\"").append(entry.getValue().getAddrRcvFrom()).append("\",\"qryPriorityId\":").append(entry.getValue().getQryPriorityId()).append(",\"curDataLimitInM\":").append(entry.getValue().getCurFlowCtrlLimitSize()).append(",\"curFreqLimit\":").append(entry.getValue().getCurFlowCtrlFreqLimit()).append(",\"totalSentSec\":").append(entry.getValue().getSentMsgSize()).append(",\"isSupportLimit\":").append(entry.getValue().isSupportLimit()).append(",\"sentUnitSec\":").append(entry.getValue().getTotalUnitSec()).append(",\"totalSentMin\":").append(entry.getValue().getTotalUnitMin()).append(",\"sentUnit\":").append(entry.getValue().getSentUnit());
            MessageStoreManager storeManager = this.broker.getStoreManager();
            OffsetService offsetService = this.broker.getOffsetManager();
            MessageStore store = null;
            try {
                store = storeManager.getOrCreateMessageStore(topicName, partitionId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (store == null) {
                strBuff.append(",\"isMessageStoreOk\":false}");
                continue;
            }
            long tmpOffset = offsetService.getTmpOffset(groupName, topicName, partitionId);
            long minDataOffset = store.getDataMinOffset();
            long maxDataOffset = store.getDataMaxOffset();
            long minPartOffset = store.getIndexMinOffset();
            long maxPartOffset = store.getIndexMaxOffset();
            long zkOffset = offsetService.getOffset(groupName, topicName, partitionId);
            strBuff.append(",\"isMessageStoreOk\":true,\"tmpOffset\":").append(tmpOffset).append(",\"minOffset\":").append(minPartOffset).append(",\"maxOffset\":").append(maxPartOffset).append(",\"zkOffset\":").append(zkOffset).append(",\"minDataOffset\":").append(minDataOffset).append(",\"maxDataOffset\":").append(maxDataOffset).append("}");
        }
        strBuff.append("],\"totalCnt\":").append(index).append("}");
    }

    public void adminQueryBrokerAllMessageStoreInfo(HttpServletRequest req, StringBuilder sBuilder) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuilder, result)) {
            WebParameterUtils.buildFailResult(sBuilder, result.getErrMsg());
            return;
        }
        Set topicNameSet = (Set)result.getRetData();
        sBuilder.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
        Map<String, ConcurrentHashMap<Integer, MessageStore>> messageTopicStores = this.broker.getStoreManager().getMessageStores();
        int index = 0;
        int recordId = 0;
        for (Map.Entry<String, ConcurrentHashMap<Integer, MessageStore>> entry : messageTopicStores.entrySet()) {
            if (TStringUtils.isBlank((String)entry.getKey()) || !topicNameSet.isEmpty() && !topicNameSet.contains(entry.getKey())) continue;
            if (recordId++ > 0) {
                sBuilder.append(",");
            }
            index = 0;
            sBuilder.append("{\"index\":").append(recordId).append(",\"topicName\":\"").append(entry.getKey()).append("\",\"storeInfo\":[");
            ConcurrentHashMap<Integer, MessageStore> partStoreMap = entry.getValue();
            if (partStoreMap != null) {
                for (Map.Entry<Integer, MessageStore> subEntry : partStoreMap.entrySet()) {
                    MessageStore msgStore = subEntry.getValue();
                    if (msgStore == null) continue;
                    if (index++ > 0) {
                        sBuilder.append(",");
                    }
                    int numPartId = msgStore.getPartitionNum();
                    sBuilder.append("{\"storeId\":").append(subEntry.getKey()).append(",\"numPartition\":").append(numPartId).append(",\"minDataOffset\":").append(msgStore.getDataMinOffset()).append(",\"maxDataOffset\":").append(msgStore.getDataMaxOffset()).append(",\"sizeInBytes\":").append(msgStore.getDataStoreSize()).append(",\"partitionInfo\":[");
                    for (int partitionId = 0; partitionId < numPartId; ++partitionId) {
                        if (partitionId > 0) {
                            sBuilder.append(",");
                        }
                        sBuilder.append("{\"partitionId\":").append(partitionId).append(",\"minOffset\":").append(msgStore.getIndexMinOffset()).append(",\"maxOffset\":").append(msgStore.getIndexMaxOffset()).append(",\"sizeInBytes\":").append(msgStore.getIndexStoreSize()).append("}");
                    }
                    sBuilder.append("]}");
                }
            }
            sBuilder.append("]}");
        }
        sBuilder.append("],\"totalCnt\":").append(recordId).append("}");
    }

    public void adminGetMemStoreStatisInfo(HttpServletRequest req, StringBuilder sBuilder) {
        sBuilder.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("The method is deprecated, please use admin_get_msgstore_stats\"}");
    }

    public void adminManualSetCurrentOffSet(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.TOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String topicName = (String)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.GROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String groupName = (String)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.MODIFYUSER, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String modifyUser = (String)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.PARTITIONID, true, -1, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        int partitionId = (Integer)result.getRetData();
        if (!WebParameterUtils.getLongParamValue(req, WebFieldDef.MANUALOFFSET, true, -1L, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        long manualOffset = (Long)result.getRetData();
        List<String> topicList = this.broker.getMetadataManager().getTopics();
        if (!topicList.contains(topicName)) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: not found the topicName configure!").append("\"}");
            return;
        }
        MessageStoreManager storeManager = this.broker.getStoreManager();
        MessageStore store = null;
        try {
            store = storeManager.getOrCreateMessageStore(topicName, partitionId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (store == null) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: not found the store by topicName!").append("\"}");
            return;
        }
        if (manualOffset < store.getIndexMinOffset()) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: manualOffset lower than Current MinOffset:(").append(manualOffset).append("<").append(store.getIndexMinOffset()).append(")\"}");
            return;
        }
        if (manualOffset > store.getIndexMaxOffset()) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: manualOffset bigger than Current MaxOffset:(").append(manualOffset).append(">").append(store.getIndexMaxOffset()).append(")\"}");
            return;
        }
        OffsetService offsetService = this.broker.getOffsetManager();
        long oldOffset = offsetService.resetOffset(store, groupName, topicName, partitionId, manualOffset, modifyUser);
        if (oldOffset < 0L) {
            sBuffer.append("{\"result\":false,\"errCode\":401,\"errMsg\":\"").append("Manual update current Offset failure!").append("\"}");
        } else {
            sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"").append("Manual update current Offset success!").append("\",\"oldOffset\":").append(oldOffset).append("}");
        }
    }

    public void adminQuerySnapshotMessageSet(HttpServletRequest req, StringBuilder sBuffer) throws Exception {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.TOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String topicName = (String)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.PARTITIONID, false, -1, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        int partitionId = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.MSGCOUNT, false, 3, 3, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        int msgCount = (Integer)result.getRetData();
        if ((msgCount = Math.max(msgCount, 1)) > 50) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Over max allowed msgCount value, allowed count is 50!").append("\"}");
            return;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.FILTERCONDS, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set filterCondStrSet = (Set)result.getRetData();
        this.broker.getBrokerServiceServer().getMessageSnapshot(topicName, partitionId, msgCount, filterCondStrSet, sBuffer);
    }

    public void adminQueryCurrentGroupOffSet(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.TOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String topicName = (String)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.GROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String groupName = (String)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.PARTITIONID, true, -1, 0, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        int partitionId = (Integer)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.REQUIREREALOFFSET, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        boolean requireRealOffset = (Boolean)result.getRetData();
        List<String> topicList = this.broker.getMetadataManager().getTopics();
        if (!topicList.contains(topicName)) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: not found the topicName configure!").append("\"}");
            return;
        }
        MessageStoreManager storeManager = this.broker.getStoreManager();
        OffsetService offsetService = this.broker.getOffsetManager();
        MessageStore store = null;
        try {
            store = storeManager.getOrCreateMessageStore(topicName, partitionId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (store == null) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: not found the store by topicName!").append("\"}");
            return;
        }
        long tmpOffset = offsetService.getTmpOffset(groupName, topicName, partitionId);
        long minDataOffset = store.getDataMinOffset();
        long maxDataOffset = store.getDataMaxOffset();
        long minPartOffset = store.getIndexMinOffset();
        long maxPartOffset = store.getIndexMaxOffset();
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"").append("OK!").append("\",\"tmpOffset\":").append(tmpOffset).append(",\"minOffset\":").append(minPartOffset).append(",\"maxOffset\":").append(maxPartOffset).append(",\"minDataOffset\":").append(minDataOffset).append(",\"maxDataOffset\":").append(maxDataOffset);
        if (requireRealOffset) {
            long curReadDataOffset = -2L;
            long curRdDltDataOffset = -2L;
            long zkOffset = offsetService.getOffset(groupName, topicName, partitionId);
            String queryKey = groupName + ":" + topicName + ":" + partitionId;
            ConsumerNodeInfo consumerNodeInfo = this.broker.getConsumerNodeInfo(queryKey);
            if (consumerNodeInfo != null) {
                curReadDataOffset = consumerNodeInfo.getLastDataRdOffset();
                long l = curRdDltDataOffset = curReadDataOffset < 0L ? -2L : maxDataOffset - curReadDataOffset;
            }
            if (curReadDataOffset < 0L) {
                sBuffer.append(",\"zkOffset\":").append(zkOffset).append(",\"curReadDataOffset\":-1,\"curRdDltDataOffset\":-1");
            } else {
                sBuffer.append(",\"zkOffset\":").append(zkOffset).append(",\"curReadDataOffset\":").append(curReadDataOffset).append(",\"curRdDltDataOffset\":").append(curRdDltDataOffset);
            }
        }
        sBuffer.append("}");
    }

    public void adminQueryConsumerRegisterInfo(HttpServletRequest req, StringBuilder strBuff) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, strBuff, result)) {
            WebParameterUtils.buildFailResult(strBuff, result.getErrMsg());
            return;
        }
        Set groupNameSet = (Set)result.getRetData();
        int totalCnt = 0;
        Map<String, ConsumerNodeInfo> map = this.broker.getBrokerServiceServer().getConsumerRegisterMap();
        strBuff.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
        for (Map.Entry<String, ConsumerNodeInfo> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || !groupNameSet.isEmpty() && !groupNameSet.contains(entry.getValue().getGroupName())) continue;
            if (totalCnt++ > 0) {
                strBuff.append(",");
            }
            strBuff.append("{\"Partition\":\"").append(entry.getKey()).append("\",\"Consumer\":\"").append(entry.getValue().getConsumerId()).append("\",\"index\":").append(totalCnt).append("}");
        }
        strBuff.append("],\"totalCnt\":").append(totalCnt).append("}");
    }

    public void adminQueryPubInfo(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set topicSet = (Set)result.getRetData();
        Map<String, Map<Integer, TopicPubStoreInfo>> topicStorePubInfoMap = this.broker.getStoreManager().getTopicPublishInfos(topicSet);
        int totalCnt = 0;
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
        for (Map.Entry<String, Map<Integer, TopicPubStoreInfo>> entry : topicStorePubInfoMap.entrySet()) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"topicName\":\"").append(entry.getKey()).append("\",\"offsetInfo\":[");
            Map<Integer, TopicPubStoreInfo> storeInfoMap = entry.getValue();
            int itemCnt = 0;
            for (Map.Entry<Integer, TopicPubStoreInfo> entry1 : storeInfoMap.entrySet()) {
                if (itemCnt++ > 0) {
                    sBuffer.append(",");
                }
                TopicPubStoreInfo pubStoreInfo = entry1.getValue();
                pubStoreInfo.buildPubStoreInfo(sBuffer);
            }
            sBuffer.append("],\"itemCount\":").append(itemCnt).append("}");
        }
        sBuffer.append("],\"dataCount\":").append(totalCnt).append("}");
    }

    public void adminQueryBookedGroup(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.WITHDIVIDE, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        boolean withDivide = (Boolean)result.getRetData();
        int itemCnt = 0;
        int totalCnt = 0;
        OffsetService offsetService = this.broker.getOffsetManager();
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
        if (withDivide) {
            Set<String> onlineGroups = offsetService.getInMemoryGroups();
            sBuffer.append("{\"type\":\"in-cache\",\"groupName\":[");
            for (String string : onlineGroups) {
                if (itemCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append(string).append("\"");
            }
            sBuffer.append("],\"groupCount\":").append(itemCnt).append("}");
            ++totalCnt;
            sBuffer.append(",");
            itemCnt = 0;
            Set<String> onZKGroup = offsetService.getUnusedGroupInfo();
            sBuffer.append("{\"type\":\"in-zk\",\"groupName\":[");
            for (String group : onZKGroup) {
                if (itemCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append(group).append("\"");
            }
            sBuffer.append("],\"groupCount\":").append(itemCnt).append("}");
            ++totalCnt;
        } else {
            Set<String> allGroups = offsetService.getBookedGroups();
            sBuffer.append("{\"type\":\"all\",\"groupName\":[");
            for (String string : allGroups) {
                if (itemCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append(string).append("\"");
            }
            sBuffer.append("],\"groupCount\":").append(itemCnt).append("}");
            ++totalCnt;
        }
        sBuffer.append("],\"dataCount\":").append(totalCnt).append("}");
    }

    public void adminQueryGroupOffSet(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set inGroupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set topicSet = (Set)result.getRetData();
        HashSet<String> qryGroupNameSet = new HashSet();
        Set<String> bookedGroupSet = this.broker.getOffsetManager().getBookedGroups();
        if (inGroupNameSet.isEmpty()) {
            qryGroupNameSet = bookedGroupSet;
        } else {
            for (String group : inGroupNameSet) {
                if (!bookedGroupSet.contains(group)) continue;
                qryGroupNameSet.add(group);
            }
        }
        Map<String, Map<String, Map<Integer, GroupOffsetInfo>>> groupOffsetMaps = this.getGroupOffsetInfo(WebFieldDef.COMPSGROUPNAME, qryGroupNameSet, topicSet);
        int totalCnt = 0;
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
        for (Map.Entry<String, Map<String, Map<Integer, GroupOffsetInfo>>> entry : groupOffsetMaps.entrySet()) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            Map<String, Map<Integer, GroupOffsetInfo>> topicPartMap = entry.getValue();
            sBuffer.append("{\"groupName\":\"").append(entry.getKey()).append("\",\"subInfo\":[");
            int topicCnt = 0;
            for (Map.Entry<String, Map<Integer, GroupOffsetInfo>> entry1 : topicPartMap.entrySet()) {
                if (topicCnt++ > 0) {
                    sBuffer.append(",");
                }
                Map<Integer, GroupOffsetInfo> partOffMap = entry1.getValue();
                sBuffer.append("{\"topicName\":\"").append(entry1.getKey()).append("\",\"offsets\":[");
                int partCnt = 0;
                for (Map.Entry<Integer, GroupOffsetInfo> entry2 : partOffMap.entrySet()) {
                    if (partCnt++ > 0) {
                        sBuffer.append(",");
                    }
                    GroupOffsetInfo offsetInfo = entry2.getValue();
                    offsetInfo.buildOffsetInfo(sBuffer);
                }
                sBuffer.append("],\"partCount\":").append(partCnt).append("}");
            }
            sBuffer.append("],\"topicCount\":").append(topicCnt).append("}");
        }
        sBuffer.append("],\"totalCnt\":").append(totalCnt).append("}");
    }

    public void adminQueryGroupHistoryOffSet(HttpServletRequest req, StringBuilder sBuffer) {
        MessageStore msgStore;
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.MSGCOUNT, false, 1, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        int msgCount = (Integer)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.MAXRETRYCOUNT, false, 2, 1, 30, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        int maxRetryCnt = (Integer)result.getRetData();
        if (!WebParameterUtils.getDateParameter(req, WebFieldDef.RECORDTIME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Date recordTime = (Date)result.getRetData();
        long recordStamp = recordTime.getTime();
        if (ServiceStatusHolder.isReadServiceStop()) {
            WebParameterUtils.buildFailResult(sBuffer, "Read StoreService temporary unavailable!");
            return;
        }
        MessageStoreManager storeManager = this.broker.getStoreManager();
        try {
            msgStore = storeManager.getOrCreateMessageStore("__offset_history__", 0);
        }
        catch (Throwable ex) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: not found the store by topicName(").append("__offset_history__").append("), reason is ").append(ex.getMessage()).append("\"}");
            return;
        }
        int totalCnt = 0;
        long requestOffset = msgStore.getStartOffsetByTimeStamp(recordStamp);
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (String groupName : groupNameSet) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            this.queryGroupStoredOffsets(msgStore, groupName, requestOffset, recordStamp, msgCount, maxRetryCnt, sBuffer);
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
    }

    private void queryGroupStoredOffsets(MessageStore msgStore, String groupName, long requestOffset, long recordStamp, int msgCount, int maxRetryCnt, StringBuilder strBuff) {
        Throwable qryThrow;
        int msgAccCnt = 0;
        int msgTypeCode = groupName.hashCode();
        int partitionId = Math.abs(msgTypeCode) % 10;
        HashSet<String> filterCodes = new HashSet<String>();
        filterCodes.add(groupName);
        ConsumerNodeInfo consumerNodeInfo = new ConsumerNodeInfo(this.broker.getStoreManager(), groupName, "offsetConsumer", filterCodes, "", System.currentTimeMillis(), "", "");
        int qryRetryCount = 0;
        long itemInitOffset = requestOffset;
        int maxTransferSize = this.broker.getStoreManager().getMaxMsgTransferSize();
        do {
            GetMessageResult getMessageResult;
            qryThrow = null;
            try {
                getMessageResult = msgStore.getMessages(303, itemInitOffset, partitionId, consumerNodeInfo, "__offset_history__", maxTransferSize, recordStamp);
            }
            catch (Throwable e2) {
                qryThrow = e2;
                continue;
            }
            if (getMessageResult.transferedMessageList == null || getMessageResult.transferedMessageList.isEmpty()) {
                itemInitOffset += (long)getMessageResult.lastReadOffset;
                continue;
            }
            boolean msgMatched = false;
            List messageList = DataConverterUtil.convertMessage((String)"__offset_history__", getMessageResult.transferedMessageList);
            for (Message message : messageList) {
                if (message == null || !groupName.equals(message.getAttrValue("$groupName$"))) continue;
                msgMatched = true;
                if (msgAccCnt++ == 0) {
                    strBuff.append("{\"groupName\":\"").append(groupName).append("\",\"result\":true,\"errMsg\":\"ok\",\"records\":[").append(StringUtils.newStringUtf8((byte[])message.getData()));
                } else {
                    strBuff.append(",").append(StringUtils.newStringUtf8((byte[])message.getData()));
                }
                if (msgAccCnt < msgCount) continue;
                break;
            }
            if (msgMatched) break;
            itemInitOffset += (long)getMessageResult.lastReadOffset;
        } while (++qryRetryCount < maxRetryCnt);
        if (msgAccCnt > 0) {
            strBuff.append("],\"recordCount\":").append(msgAccCnt).append("}");
        } else if (qryThrow == null) {
            strBuff.append("{\"groupName\":\"").append(groupName).append("\",\"result\":false,\"errMsg\":\"Could not find record!\"}");
        } else {
            strBuff.append("{\"groupName\":\"").append(groupName).append("\",\"result\":false,\"errMsg\":\"Get Message failure: ").append(qryThrow.getMessage()).append("\"}");
        }
    }

    public void adminSetGroupOffSet(HttpServletRequest req, StringBuilder sBuffer) {
        List resetOffsets;
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.MANUALSET, true, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        boolean manualSet = (Boolean)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.MODIFYUSER, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String modifier = (String)result.getRetData();
        if (manualSet) {
            if (!WebParameterUtils.getJsonDictParamValue(req, WebFieldDef.OFFSETJSON, true, null, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return;
            }
            Map manOffsets = (Map)result.getRetData();
            if (!this.validManOffsetResetInfo(WebFieldDef.OFFSETJSON, manOffsets, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return;
            }
            resetOffsets = (List)result.getRetData();
        } else {
            if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return;
            }
            Set topicSet = (Set)result.getRetData();
            resetOffsets = this.buildOffsetResetInfo(topicSet);
        }
        this.broker.getOffsetManager().modifyGroupOffset(groupNameSet, resetOffsets, modifier);
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"OK\"}");
    }

    public void adminSetGroupOffSetByTime(HttpServletRequest req, StringBuilder sBuffer) {
        GroupOffsetInfo offsetInfo;
        int partCnt;
        Map<Integer, GroupOffsetInfo> partOffMap;
        MessageStore msgStore;
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.GROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String groupName = (String)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.MODIFYUSER, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String modifyUser = (String)result.getRetData();
        if (!WebParameterUtils.getDateParameter(req, WebFieldDef.RECORDTIME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Date tmpDataTime1 = (Date)result.getRetData();
        long recStartTime = tmpDataTime1.getTime();
        if (!WebParameterUtils.getDateParameter(req, WebFieldDef.ENDTIME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Date tmpDataTime2 = (Date)result.getRetData();
        long recEndTime = recStartTime + 300000L;
        if (tmpDataTime2 != null && (recEndTime = tmpDataTime2.getTime()) < recStartTime) {
            WebParameterUtils.buildFailResult(sBuffer, String.format("Parameter %s value must >= %s", WebFieldDef.ENDTIME.name, WebFieldDef.RECORDTIME.name));
            return;
        }
        if (ServiceStatusHolder.isReadServiceStop()) {
            WebParameterUtils.buildFailResult(sBuffer, "Read StoreService temporary unavailable!");
            return;
        }
        MessageStoreManager storeManager = this.broker.getStoreManager();
        try {
            msgStore = storeManager.getOrCreateMessageStore("__offset_history__", 0);
        }
        catch (Throwable ex) {
            WebParameterUtils.buildFailResult(sBuffer, String.format("Get offset history store fail, reason=%s", ex.getMessage()));
            return;
        }
        int maxRetryCnt = 50;
        long requestOffset = msgStore.getStartOffsetByTimeStamp(recStartTime);
        if (!this.getStoredGroupHisOffsets(groupName, msgStore, requestOffset, maxRetryCnt, recStartTime, recEndTime, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        List resetOffsets = (List)result.getRetData();
        if (resetOffsets.isEmpty()) {
            WebParameterUtils.buildFailResult(sBuffer, "Not found history offset value!");
            return;
        }
        HashSet<String> groupNameSet = new HashSet<String>();
        groupNameSet.add(groupName);
        HashSet<String> topicSet = new HashSet<String>();
        Map<String, Map<String, Map<Integer, GroupOffsetInfo>>> befGroupOffsetMap = this.getGroupOffsetInfo(WebFieldDef.COMPSGROUPNAME, groupNameSet, topicSet);
        Map<String, Map<Integer, GroupOffsetInfo>> befTopicPartMap = befGroupOffsetMap.get(groupName);
        this.broker.getOffsetManager().modifyGroupOffset(groupNameSet, resetOffsets, modifyUser);
        Map<String, Map<String, Map<Integer, GroupOffsetInfo>>> aftGroupOffsetMap = this.getGroupOffsetInfo(WebFieldDef.COMPSGROUPNAME, groupNameSet, topicSet);
        Map<String, Map<Integer, GroupOffsetInfo>> aftTopicPartMap = aftGroupOffsetMap.get(groupName);
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        int topicCnt = 0;
        sBuffer.append("{\"groupName\":\"").append(groupName).append("\",\"before\":[");
        for (Map.Entry<String, Map<Integer, GroupOffsetInfo>> entry1 : befTopicPartMap.entrySet()) {
            if (topicCnt++ > 0) {
                sBuffer.append(",");
            }
            partOffMap = entry1.getValue();
            sBuffer.append("{\"topicName\":\"").append(entry1.getKey()).append("\",\"offsets\":[");
            partCnt = 0;
            for (Map.Entry<Integer, GroupOffsetInfo> entry2 : partOffMap.entrySet()) {
                if (partCnt++ > 0) {
                    sBuffer.append(",");
                }
                offsetInfo = entry2.getValue();
                offsetInfo.buildOffsetInfo(sBuffer);
            }
            sBuffer.append("],\"partCount\":").append(partCnt).append("}");
        }
        sBuffer.append("],\"after\":[");
        topicCnt = 0;
        for (Map.Entry<String, Map<Integer, GroupOffsetInfo>> entry1 : aftTopicPartMap.entrySet()) {
            if (topicCnt++ > 0) {
                sBuffer.append(",");
            }
            partOffMap = entry1.getValue();
            sBuffer.append("{\"topicName\":\"").append(entry1.getKey()).append("\",\"offsets\":[");
            partCnt = 0;
            for (Map.Entry<Integer, GroupOffsetInfo> entry2 : partOffMap.entrySet()) {
                if (partCnt++ > 0) {
                    sBuffer.append(",");
                }
                offsetInfo = entry2.getValue();
                offsetInfo.buildOffsetInfo(sBuffer);
            }
            sBuffer.append("],\"partCount\":").append(partCnt).append("}");
        }
        sBuffer.append("]}");
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, 1);
    }

    private boolean getStoredGroupHisOffsets(String groupName, MessageStore msgStore, long requestOffset, int maxRetryCnt, long recStartTime, long recEndTime, ProcessResult result) {
        Throwable qryThrow;
        int msgTypeCode = groupName.hashCode();
        int partitionId = Math.abs(msgTypeCode) % 10;
        HashSet<String> filterCodes = new HashSet<String>();
        filterCodes.add(groupName);
        ConsumerNodeInfo consumerNodeInfo = new ConsumerNodeInfo(this.broker.getStoreManager(), groupName, "offsetConsumer", filterCodes, "", System.currentTimeMillis(), "", "");
        int qryRetryCount = 0;
        long itemInitOffset = requestOffset;
        int maxTransferSize = this.broker.getStoreManager().getMaxMsgTransferSize();
        do {
            GetMessageResult getMessageResult;
            qryThrow = null;
            try {
                getMessageResult = msgStore.getMessages(303, itemInitOffset, partitionId, consumerNodeInfo, "__offset_history__", maxTransferSize, recStartTime);
            }
            catch (Throwable e2) {
                qryThrow = e2;
                continue;
            }
            if (getMessageResult.transferedMessageList == null || getMessageResult.transferedMessageList.isEmpty()) {
                itemInitOffset += (long)getMessageResult.lastReadOffset;
                continue;
            }
            List messageList = DataConverterUtil.convertMessage((String)"__offset_history__", getMessageResult.transferedMessageList);
            for (Message message : messageList) {
                if (message == null) continue;
                long recAppTime = DateTimeConvertUtils.yyyyMMddHHmm2ms((String)message.getAttrValue("$msgTime$"));
                if (recAppTime > recEndTime) {
                    result.setFailResult(String.format("Over required endTime range, current time is %s", message.getAttrValue("$msgTime$")));
                    return result.isSuccess();
                }
                if (!groupName.equals(message.getAttrValue("$groupName$"))) continue;
                return OffsetHistoryInfo.parseRecordInfo(StringUtils.newStringUtf8((byte[])message.getData()), result);
            }
            itemInitOffset += (long)getMessageResult.lastReadOffset;
        } while (++qryRetryCount < maxRetryCnt);
        if (qryThrow == null) {
            result.setFailResult("Not found record in required search range");
        } else {
            result.setFailResult(String.format("Query record failure, reason is :%s", qryThrow.getMessage()));
        }
        return result.isSuccess();
    }

    public void adminCloneGroupOffSet(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.SRCGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String srcGroupName = (String)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set srcTopicNameSet = (Set)result.getRetData();
        if (!this.validAndGetTopicPartInfo(srcGroupName, WebFieldDef.SRCGROUPNAME, srcTopicNameSet, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Map topicPartMap = (Map)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.TGTCOMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set tgtGroupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.MODIFYUSER, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String modifier = (String)result.getRetData();
        Set<String> bookedGroups = this.broker.getOffsetManager().getBookedGroups();
        if (!bookedGroups.contains(srcGroupName)) {
            WebParameterUtils.buildFailResult(sBuffer, new StringBuilder(512).append("Parameter ").append(WebFieldDef.SRCGROUPNAME.name).append(": ").append(srcGroupName).append(" has not been registered on this Broker!").toString());
            return;
        }
        Map<String, Map<Integer, Tuple2<Long, Long>>> srcGroupOffsets = this.broker.getOffsetManager().queryGroupOffset(srcGroupName, topicPartMap);
        List<Tuple3<String, Integer, Long>> resetOffsets = this.buildOffsetResetInfo(srcGroupOffsets);
        this.broker.getOffsetManager().modifyGroupOffset(tgtGroupNameSet, resetOffsets, modifier);
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"OK\"}");
    }

    public void adminRemoveGroupOffSet(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSGROUPNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set groupNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.MODIFYUSER, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String modifier = (String)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.ONLYMEM, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        boolean onlyMemory = (Boolean)result.getRetData();
        if (!this.validAndGetGroupTopicInfo(groupNameSet, topicNameSet, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Map groupTopicPartMap = (Map)result.getRetData();
        this.broker.getOffsetManager().deleteGroupOffset(onlyMemory, groupTopicPartMap, modifier);
        WebParameterUtils.buildSuccessResult(sBuffer);
    }

    public void adminGetMetricsInfo(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.NEEDREFRESH, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        boolean needRefresh = (Boolean)result.getRetData();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        sBuffer.append("{\"probeTime\":\"").append(DateTimeConvertUtils.ms2yyyyMMddHHmmss((long)System.currentTimeMillis())).append("\",\"nodeName\":\"").append(this.broker.getTubeConfig().getHostName()).append("\",\"nodeRole\":\"Broker\",\"metrics\":{\"serviceStatus\":");
        if (needRefresh) {
            BrokerSrvStatsHolder.snapShort(sBuffer);
            sBuffer.append(",\"webAPI\":");
            WebCallStatsHolder.snapShort(sBuffer);
        } else {
            BrokerSrvStatsHolder.getValue(sBuffer);
            sBuffer.append(",\"webAPI\":");
            WebCallStatsHolder.getValue(sBuffer);
        }
        sBuffer.append("},\"count\":2}");
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, 1);
    }

    public void adminGetMsgStoreStatsInfo(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.NEEDREFRESH, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        boolean needRefresh = (Boolean)result.getRetData();
        int index = 0;
        int recordId = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        Map<String, ConcurrentHashMap<Integer, MessageStore>> messageTopicStores = this.broker.getStoreManager().getMessageStores();
        if (topicNameSet.isEmpty()) {
            for (Map.Entry<String, ConcurrentHashMap<Integer, MessageStore>> entry : messageTopicStores.entrySet()) {
                if (entry == null) continue;
                String topicName = entry.getKey();
                if (recordId++ > 0) {
                    sBuffer.append(",");
                }
                index = 0;
                sBuffer.append("{\"topicName\":\"").append(topicName).append("\",\"details\":[");
                ConcurrentHashMap<Integer, MessageStore> partStoreMap = entry.getValue();
                if (partStoreMap != null) {
                    for (Map.Entry<Integer, MessageStore> subEntry : partStoreMap.entrySet()) {
                        MessageStore msgStore = subEntry.getValue();
                        if (msgStore == null) continue;
                        if (index++ > 0) {
                            sBuffer.append(",");
                        }
                        sBuffer.append("{\"storeId\":").append(subEntry.getKey()).append(",\"msgStore\":");
                        msgStore.getMsgStoreStatsInfo(needRefresh, sBuffer);
                        sBuffer.append("}");
                    }
                }
                sBuffer.append("]}");
            }
        } else {
            for (String topicName : topicNameSet) {
                if (recordId++ > 0) {
                    sBuffer.append(",");
                }
                index = 0;
                ConcurrentHashMap<Integer, MessageStore> msgStoreMap = messageTopicStores.get(topicName);
                sBuffer.append("{\"topicName\":\"").append(topicName).append("\",\"details\":[");
                if (msgStoreMap != null) {
                    for (Map.Entry<Integer, MessageStore> subEntry : msgStoreMap.entrySet()) {
                        MessageStore msgStore = subEntry.getValue();
                        if (msgStore == null) continue;
                        if (index++ > 0) {
                            sBuffer.append(",");
                        }
                        sBuffer.append("{\"storeId\":").append(subEntry.getKey()).append(",\"msgStore\":");
                        msgStore.getMsgStoreStatsInfo(needRefresh, sBuffer);
                        sBuffer.append("}");
                    }
                }
                sBuffer.append("]}");
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, recordId);
    }

    public void adminEnableMetricsStats(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.STATSTYPE, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String statsType = (String)result.getRetData();
        this.innEnableOrDisableMetricsStats(true, statsType, req, sBuffer);
    }

    public void adminDisableMetricsStats(HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.STATSTYPE, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return;
        }
        String statsType = (String)result.getRetData();
        this.innEnableOrDisableMetricsStats(false, statsType, req, sBuffer);
    }

    public void adminDisableAllStats(HttpServletRequest req, StringBuilder sBuffer) {
        this.innEnableOrDisableMetricsStats(false, BrokerStatsType.ALL.getName(), req, sBuffer);
    }

    private void innEnableOrDisableMetricsStats(boolean enable, String statsType, HttpServletRequest req, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        BrokerStatsType inMetricType = null;
        for (BrokerStatsType metricType : BrokerStatsType.values()) {
            if (!metricType.getName().equalsIgnoreCase(statsType)) continue;
            inMetricType = metricType;
            break;
        }
        if (inMetricType == null) {
            sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":").append("\"Unmatched stat type, allowed stat type are : [");
            int count = 0;
            for (BrokerStatsType metricType : BrokerStatsType.values()) {
                if (count++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append(metricType.getName());
            }
            sBuffer.append("]\"}");
            return;
        }
        if (inMetricType == BrokerStatsType.WEBAPI || inMetricType == BrokerStatsType.ALL) {
            WebCallStatsHolder.setStatsStatus(enable);
        }
        if (inMetricType == BrokerStatsType.SERVICESTATUS || inMetricType == BrokerStatsType.ALL) {
            BrokerSrvStatsHolder.setDetailStatsStatus(enable);
        }
        if (inMetricType == BrokerStatsType.MSGSTORE || inMetricType == BrokerStatsType.ALL) {
            if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
                WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
                return;
            }
            Set topicNameSet = (Set)result.getRetData();
            Map<String, ConcurrentHashMap<Integer, MessageStore>> msgTopicStores = this.broker.getStoreManager().getMessageStores();
            if (topicNameSet.isEmpty()) {
                for (ConcurrentHashMap<Integer, MessageStore> storeMap : msgTopicStores.values()) {
                    if (storeMap == null) continue;
                    for (MessageStore msgStore : storeMap.values()) {
                        if (msgStore == null) continue;
                        msgStore.getMsgStoreStatsHolder().setStatsStatus(enable);
                    }
                }
            } else {
                for (String topicName : topicNameSet) {
                    ConcurrentHashMap<Integer, MessageStore> storeMap = msgTopicStores.get(topicName);
                    if (storeMap == null) continue;
                    for (MessageStore msgStore : storeMap.values()) {
                        if (msgStore == null) continue;
                        msgStore.getMsgStoreStatsHolder().setStatsStatus(true);
                    }
                }
            }
        }
        WebParameterUtils.buildSuccessResult(sBuffer);
    }

    private List<Tuple3<String, Integer, Long>> buildOffsetResetInfo(Map<String, Map<Integer, Tuple2<Long, Long>>> topicPartOffsetMap) {
        long adjOffset = -1L;
        MessageStore store = null;
        ArrayList<Tuple3<String, Integer, Long>> result = new ArrayList<Tuple3<String, Integer, Long>>();
        MessageStoreManager storeManager = this.broker.getStoreManager();
        for (Map.Entry<String, Map<Integer, Tuple2<Long, Long>>> entry : topicPartOffsetMap.entrySet()) {
            Map<Integer, Tuple2<Long, Long>> partOffsetMap = entry.getValue();
            if (partOffsetMap == null) continue;
            for (Map.Entry<Integer, Tuple2<Long, Long>> entry1 : partOffsetMap.entrySet()) {
                if (entry1.getValue() == null) continue;
                Tuple2<Long, Long> offsetTuple = entry1.getValue();
                try {
                    store = storeManager.getOrCreateMessageStore(entry.getKey(), entry1.getKey());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (store == null) continue;
                adjOffset = MixedUtils.mid((long)((Long)offsetTuple.getF0()), (long)store.getIndexMinOffset(), (long)store.getIndexMaxOffset());
                result.add((Tuple3<String, Integer, Long>)new Tuple3((Object)entry.getKey(), (Object)entry1.getKey(), (Object)adjOffset));
            }
        }
        return result;
    }

    private List<Tuple3<String, Integer, Long>> buildOffsetResetInfo(Set<String> topicSet) {
        MessageStore store = null;
        ArrayList<Tuple3<String, Integer, Long>> result = new ArrayList<Tuple3<String, Integer, Long>>();
        MessageStoreManager storeManager = this.broker.getStoreManager();
        Map<String, Set<Integer>> topicPartMap = this.getTopicPartitions(topicSet);
        for (Map.Entry<String, Set<Integer>> entry : topicPartMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            Set<Integer> partitionSet = entry.getValue();
            for (Integer partId : partitionSet) {
                try {
                    store = storeManager.getOrCreateMessageStore(entry.getKey(), partId);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (store == null) continue;
                result.add((Tuple3<String, Integer, Long>)new Tuple3((Object)entry.getKey(), (Object)partId, (Object)store.getIndexMaxOffset()));
            }
        }
        return result;
    }

    private boolean validManOffsetResetInfo(WebFieldDef fieldDef, Map<String, Long> manOffsetInfoMap, ProcessResult result) {
        MessageStore store = null;
        MessageStoreManager storeManager = this.broker.getStoreManager();
        ArrayList<Tuple3> offsetVals = new ArrayList<Tuple3>();
        String localBrokerId = String.valueOf(this.broker.getTubeConfig().getBrokerId());
        Map<String, TopicMetadata> topicConfigMap = this.broker.getMetadataManager().getTopicConfigMap();
        for (Map.Entry<String, Long> entry : manOffsetInfoMap.entrySet()) {
            int partitionId;
            if (entry.getKey() == null || entry.getValue() == null) continue;
            String[] keyItems = entry.getKey().split(":");
            if (keyItems.length != 3) {
                result.setFailResult(fieldDef.id, new StringBuilder(512).append("Parameter ").append(fieldDef.name).append("'s key invalid:").append(entry.getKey()).append(" must be brokerId:topicName:partitionId !").toString());
                return result.isSuccess();
            }
            String brokerId = keyItems[0].trim();
            String topicName = keyItems[1].trim();
            String strPartId = keyItems[2].trim();
            if (!localBrokerId.equals(brokerId) || !topicConfigMap.containsKey(topicName)) continue;
            try {
                partitionId = Integer.parseInt(strPartId);
            }
            catch (NumberFormatException e) {
                result.setFailResult(fieldDef.id, new StringBuilder(512).append("Parameter ").append(fieldDef.name).append("'s key invalid:").append(entry.getKey()).append("'s partitionId value not number!").toString());
                return result.isSuccess();
            }
            try {
                store = storeManager.getOrCreateMessageStore(topicName, partitionId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (store == null) continue;
            long adjOffset = MixedUtils.mid((long)entry.getValue(), (long)store.getIndexMinOffset(), (long)store.getIndexMaxOffset());
            offsetVals.add(new Tuple3((Object)topicName, (Object)partitionId, (Object)adjOffset));
        }
        if (offsetVals.isEmpty()) {
            result.setFailResult(fieldDef.id, new StringBuilder(512).append("Parameter ").append(fieldDef.name).append("'s value is invalid!").toString());
        } else {
            result.setSuccResult(offsetVals);
        }
        return result.isSuccess();
    }

    private Map<String, Map<String, Map<Integer, GroupOffsetInfo>>> getGroupOffsetInfo(WebFieldDef groupFldDef, Set<String> groupSet, Set<String> topicSet) {
        ProcessResult result = new ProcessResult();
        HashMap<String, Map<String, Map<Integer, GroupOffsetInfo>>> groupOffsetMaps = new HashMap<String, Map<String, Map<Integer, GroupOffsetInfo>>>();
        for (String group : groupSet) {
            HashMap topicOffsetRet = new HashMap();
            if (this.validAndGetTopicPartInfo(group, groupFldDef, topicSet, result)) {
                Map topicPartMap = (Map)result.getRetData();
                Map<String, Map<Integer, TopicPubStoreInfo>> topicStorePubInfoMap = this.broker.getStoreManager().getTopicPublishInfos(topicPartMap.keySet());
                Map<String, Map<Integer, Tuple2<Long, Long>>> groupOffsetMap = this.broker.getOffsetManager().queryGroupOffset(group, topicPartMap);
                for (Map.Entry entry : topicPartMap.entrySet()) {
                    String topic = (String)entry.getKey();
                    HashMap<Integer, GroupOffsetInfo> partOffsetRet = new HashMap<Integer, GroupOffsetInfo>();
                    Map<Integer, TopicPubStoreInfo> storeInfoMap = topicStorePubInfoMap.get(topic);
                    Map<Integer, Tuple2<Long, Long>> partBookedMap = groupOffsetMap.get(topic);
                    for (Integer partitionId : (Set)entry.getValue()) {
                        GroupOffsetInfo offsetInfo = new GroupOffsetInfo(partitionId);
                        offsetInfo.setPartPubStoreInfo(storeInfoMap == null ? null : storeInfoMap.get(partitionId));
                        offsetInfo.setConsumeOffsetInfo(partBookedMap == null ? null : partBookedMap.get(partitionId));
                        String queryKey = this.buildQueryID(group, topic, partitionId);
                        ConsumerNodeInfo nodeInfo = this.broker.getConsumerNodeInfo(queryKey);
                        if (nodeInfo != null) {
                            offsetInfo.setConsumeDataOffsetInfo(nodeInfo.getLastDataRdOffset());
                        }
                        offsetInfo.calculateLag();
                        partOffsetRet.put(partitionId, offsetInfo);
                    }
                    topicOffsetRet.put(topic, partOffsetRet);
                }
            }
            groupOffsetMaps.put(group, topicOffsetRet);
        }
        return groupOffsetMaps;
    }

    private boolean validAndGetGroupTopicInfo(Set<String> groupSet, Set<String> topicSet, ProcessResult result) {
        HashMap<String, Map> groupTopicPartMap = new HashMap<String, Map>();
        HashSet<String> targetGroupSet = new HashSet<String>();
        Set<String> bookedGroups = this.broker.getOffsetManager().getBookedGroups();
        for (String orgGroup : groupSet) {
            if (!bookedGroups.contains(orgGroup)) continue;
            targetGroupSet.add(orgGroup);
        }
        for (String group : targetGroupSet) {
            if (!this.validAndGetTopicPartInfo(group, WebFieldDef.GROUPNAME, topicSet, result)) continue;
            Map topicPartMap = (Map)result.getRetData();
            groupTopicPartMap.put(group, topicPartMap);
        }
        result.setSuccResult(groupTopicPartMap);
        return true;
    }

    private boolean validAndGetTopicPartInfo(String groupName, WebFieldDef groupFldDef, Set<String> topicSet, ProcessResult result) {
        Set<String> subTopicSet = this.broker.getOffsetManager().getGroupSubInfo(groupName);
        if (subTopicSet == null || subTopicSet.isEmpty()) {
            result.setFailResult(400, new StringBuilder(512).append("Parameter ").append(groupFldDef.name).append(": subscribed topic set of ").append(groupName).append(" query result is null!").toString());
            return result.isSuccess();
        }
        HashSet<String> tgtTopicSet = new HashSet();
        if (topicSet.isEmpty()) {
            tgtTopicSet = subTopicSet;
        } else {
            for (String topic : topicSet) {
                if (!subTopicSet.contains(topic)) continue;
                tgtTopicSet.add(topic);
            }
            if (tgtTopicSet.isEmpty()) {
                result.setFailResult(400, new StringBuilder(512).append("Parameter ").append(groupFldDef.name).append(": ").append(groupName).append(" unsubscribed to the specified topic set!").toString());
                return result.isSuccess();
            }
        }
        Map<String, Set<Integer>> topicPartMap = this.getTopicPartitions(tgtTopicSet);
        if (topicPartMap.isEmpty()) {
            result.setFailResult(400, new StringBuilder(512).append("Parameter ").append(groupFldDef.name).append(": all topics subscribed by the group have been deleted!").toString());
            return result.isSuccess();
        }
        result.setSuccResult(topicPartMap);
        return result.isSuccess();
    }

    private Map<String, Set<Integer>> getTopicPartitions(Set<String> topicSet) {
        Map<String, TopicMetadata> topicConfigMap;
        HashMap<String, Set<Integer>> topicPartMap = new HashMap<String, Set<Integer>>();
        if (topicSet != null && (topicConfigMap = this.broker.getMetadataManager().getTopicConfigMap()) != null) {
            for (String topic : topicSet) {
                TopicMetadata topicMetadata = topicConfigMap.get(topic);
                if (topicMetadata == null) continue;
                topicPartMap.put(topic, topicMetadata.getAllPartitionIds());
            }
        }
        return topicPartMap;
    }

    private String buildQueryID(String group, String topic, int partitionId) {
        return new StringBuilder(512).append(group).append(":").append(topic).append(":").append(partitionId).toString();
    }
}

