/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.stats.audit;

import java.util.Map;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.stats.TrafficInfo;
import org.apache.inlong.tubemq.server.common.fileconfig.ADConfig;

public class AuditUtils {
    private static ADConfig auditConfig = new ADConfig();

    public static void initAudit(ADConfig adConfig) {
        if (adConfig == null || !adConfig.isAuditEnable()) {
            return;
        }
        auditConfig = adConfig;
        AuditOperator.getInstance().setAuditProxy(adConfig.getAuditProxyAddrSet());
        AuditConfig auditConfig = new AuditConfig(adConfig.getAuditCacheFilePath(), adConfig.getAuditCacheMaxRows());
        AuditOperator.getInstance().setAuditConfig(auditConfig);
    }

    public static void addProduceRecord(String groupId, String streamId, String logTime, long count, long size) {
        if (!auditConfig.isAuditEnable()) {
            return;
        }
        AuditOperator.getInstance().add(auditConfig.getAuditIdProduce(), groupId, streamId, Long.valueOf(DateTimeConvertUtils.yyyyMMddHHmm2ms((String)logTime)), count, size);
    }

    public static void addConsumeRecord(Map<String, TrafficInfo> trafficInfos) {
        if (!auditConfig.isAuditEnable() || trafficInfos == null || trafficInfos.isEmpty()) {
            return;
        }
        for (Map.Entry<String, TrafficInfo> entry : trafficInfos.entrySet()) {
            String statKey;
            String[] statKeyItems;
            if (entry == null || entry.getKey() == null || entry.getValue() == null || (statKeyItems = (statKey = entry.getKey()).split("#", -1)).length < 8 || TStringUtils.isEmpty((String)statKeyItems[0])) continue;
            AuditOperator.getInstance().add(auditConfig.getAuditIdConsume(), statKeyItems[0], statKeyItems[5], Long.valueOf(DateTimeConvertUtils.yyyyMMddHHmm2ms((String)statKeyItems[7])), entry.getValue().getMsgCount(), entry.getValue().getMsgSize());
        }
    }

    public static void closeAudit() {
        if (!auditConfig.isAuditEnable()) {
            return;
        }
        AuditOperator.getInstance().send();
    }
}

