/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.stats;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.metric.impl.ESTHistogram;
import org.apache.inlong.tubemq.corebase.metric.impl.LongOnlineCounter;
import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;
import org.apache.inlong.tubemq.corebase.metric.impl.SinceTime;

public class BrokerSrvStatsHolder {
    private static final LongOnlineCounter csmOnlineCnt = new LongOnlineCounter("consume_online_cnt", null);
    private static final ServiceStatsSet[] switchableSets = new ServiceStatsSet[2];
    private static final AtomicInteger writableIndex = new AtomicInteger(0);
    private static final AtomicLong lstSnapshotTime = new AtomicLong(0L);
    private static volatile boolean detailStatsClosed = false;

    public static void getValue(Map<String, Long> statsMap) {
        BrokerSrvStatsHolder.getStatsValue(switchableSets[BrokerSrvStatsHolder.getIndex()], false, statsMap);
    }

    public static void getValue(StringBuilder strBuff) {
        BrokerSrvStatsHolder.getStatsValue(switchableSets[BrokerSrvStatsHolder.getIndex()], false, strBuff);
    }

    public static void snapShort(Map<String, Long> statsMap) {
        if (BrokerSrvStatsHolder.switchWritingStatsUnit()) {
            BrokerSrvStatsHolder.getStatsValue(switchableSets[BrokerSrvStatsHolder.getIndex(writableIndex.get() - 1)], true, statsMap);
        } else {
            BrokerSrvStatsHolder.getStatsValue(switchableSets[BrokerSrvStatsHolder.getIndex()], false, statsMap);
        }
    }

    public static void snapShort(StringBuilder strBuff) {
        if (BrokerSrvStatsHolder.switchWritingStatsUnit()) {
            BrokerSrvStatsHolder.getStatsValue(switchableSets[BrokerSrvStatsHolder.getIndex(writableIndex.get() - 1)], true, strBuff);
        } else {
            BrokerSrvStatsHolder.getStatsValue(switchableSets[BrokerSrvStatsHolder.getIndex()], false, strBuff);
        }
    }

    public static synchronized void setDetailStatsStatus(boolean enableStats) {
        detailStatsClosed = !enableStats;
    }

    public static boolean isDetailStatsClosed() {
        return detailStatsClosed;
    }

    public static void incConsumeOnlineCnt() {
        csmOnlineCnt.incValue();
    }

    public static void decConsumeOnlineCnt(boolean isTimeout) {
        csmOnlineCnt.decValue();
        if (isTimeout) {
            BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].csmTimeoutStats.incValue();
        }
    }

    public static void incBrokerTimeoutCnt() {
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].brokerTimeoutStats.incValue();
    }

    public static void incBrokerHBExcCnt() {
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].brokerHBExcStats.incValue();
    }

    public static void incDiskIOExcCnt() {
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].fileIOExcStats.incValue();
    }

    public static void incZKExcCnt() {
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].zkExcStats.incValue();
    }

    public static void updDiskSyncDataDlt(long dltTime) {
        if (detailStatsClosed) {
            return;
        }
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].fileSyncDltStats.update(dltTime);
    }

    public static void updZKSyncDataDlt(long dltTime) {
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].zkSyncDltStats.update(dltTime);
    }

    public static void updSendMsgLatency(long dltTime) {
        if (detailStatsClosed) {
            return;
        }
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].msgPubLatencyStats.update(dltTime);
    }

    public static void incSendMsgOverFlowCnt() {
        if (detailStatsClosed) {
            return;
        }
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].errPubOverFlowStats.incValue();
    }

    public static void updGetMsgLatency(long dltTime) {
        if (detailStatsClosed) {
            return;
        }
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].msgSubLatencyStats.update(dltTime);
    }

    public static void updConfirmLatency(long dltTime) {
        if (detailStatsClosed) {
            return;
        }
        BrokerSrvStatsHolder.switchableSets[BrokerSrvStatsHolder.getIndex()].msgConfirmLatencyStats.update(dltTime);
    }

    private static boolean switchWritingStatsUnit() {
        long curSnapshotTime = lstSnapshotTime.get();
        if (System.currentTimeMillis() - curSnapshotTime >= 2000L && lstSnapshotTime.compareAndSet(curSnapshotTime, System.currentTimeMillis())) {
            switchableSets[BrokerSrvStatsHolder.getIndex(writableIndex.incrementAndGet())].resetSinceTime();
            return true;
        }
        return false;
    }

    private static void getStatsValue(ServiceStatsSet statsSet, boolean resetValue, Map<String, Long> statsMap) {
        statsMap.put(statsSet.lstResetTime.getFullName(), statsSet.lstResetTime.getSinceTime());
        statsMap.put("detailStatsClosed", detailStatsClosed ? 1L : 0L);
        if (resetValue) {
            statsMap.put(statsSet.fileIOExcStats.getFullName(), statsSet.fileIOExcStats.getAndResetValue());
            statsMap.put(statsSet.zkExcStats.getFullName(), statsSet.zkExcStats.getAndResetValue());
            statsMap.put(statsSet.brokerTimeoutStats.getFullName(), statsSet.brokerTimeoutStats.getAndResetValue());
            statsMap.put(statsSet.brokerHBExcStats.getFullName(), statsSet.brokerHBExcStats.getAndResetValue());
            statsMap.put(csmOnlineCnt.getFullName(), csmOnlineCnt.getAndResetValue());
            statsMap.put(statsSet.csmTimeoutStats.getFullName(), statsSet.csmTimeoutStats.getAndResetValue());
            statsMap.put(statsSet.errPubOverFlowStats.getFullName(), statsSet.errPubOverFlowStats.getAndResetValue());
            statsSet.fileSyncDltStats.snapShort(statsMap, false);
            statsSet.zkSyncDltStats.snapShort(statsMap, false);
            statsSet.msgPubLatencyStats.snapShort(statsMap, false);
            statsSet.msgSubLatencyStats.snapShort(statsMap, false);
            statsSet.msgConfirmLatencyStats.snapShort(statsMap, false);
        } else {
            statsMap.put(statsSet.fileIOExcStats.getFullName(), statsSet.fileIOExcStats.getValue());
            statsMap.put(statsSet.zkExcStats.getFullName(), statsSet.zkExcStats.getValue());
            statsMap.put(statsSet.brokerTimeoutStats.getFullName(), statsSet.brokerTimeoutStats.getValue());
            statsMap.put(statsSet.brokerHBExcStats.getFullName(), statsSet.brokerHBExcStats.getValue());
            statsMap.put(csmOnlineCnt.getFullName(), csmOnlineCnt.getValue());
            statsMap.put(statsSet.csmTimeoutStats.getFullName(), statsSet.csmTimeoutStats.getValue());
            statsMap.put(statsSet.errPubOverFlowStats.getFullName(), statsSet.errPubOverFlowStats.getValue());
            statsSet.fileSyncDltStats.getValue(statsMap, false);
            statsSet.zkSyncDltStats.getValue(statsMap, false);
            statsSet.msgPubLatencyStats.getValue(statsMap, false);
            statsSet.msgSubLatencyStats.getValue(statsMap, false);
            statsSet.msgConfirmLatencyStats.getValue(statsMap, false);
        }
    }

    private static void getStatsValue(ServiceStatsSet statsSet, boolean resetValue, StringBuilder strBuff) {
        strBuff.append("{\"").append(statsSet.lstResetTime.getFullName()).append("\":\"").append(statsSet.lstResetTime.getStrSinceTime()).append("\",\"detailStatsClosed\":").append(detailStatsClosed);
        if (resetValue) {
            strBuff.append(",\"").append(statsSet.fileIOExcStats.getFullName()).append("\":").append(statsSet.fileIOExcStats.getAndResetValue()).append(",\"").append(statsSet.zkExcStats.getFullName()).append("\":").append(statsSet.zkExcStats.getAndResetValue()).append(",\"").append(statsSet.brokerTimeoutStats.getFullName()).append("\":").append(statsSet.brokerTimeoutStats.getAndResetValue()).append(",\"").append(statsSet.brokerHBExcStats.getFullName()).append("\":").append(statsSet.brokerHBExcStats.getAndResetValue()).append(",\"").append(csmOnlineCnt.getFullName()).append("\":").append(csmOnlineCnt.getAndResetValue()).append(",\"").append(statsSet.csmTimeoutStats.getFullName()).append("\":").append(statsSet.csmTimeoutStats.getAndResetValue()).append(",\"").append(statsSet.errPubOverFlowStats.getFullName()).append("\":").append(statsSet.errPubOverFlowStats.getAndResetValue()).append(",");
            statsSet.fileSyncDltStats.snapShort(strBuff, false);
            strBuff.append(",");
            statsSet.zkSyncDltStats.snapShort(strBuff, false);
            strBuff.append(",");
            statsSet.msgPubLatencyStats.snapShort(strBuff, false);
            strBuff.append(",");
            statsSet.msgSubLatencyStats.snapShort(strBuff, false);
            strBuff.append(",");
            statsSet.msgConfirmLatencyStats.snapShort(strBuff, false);
            strBuff.append("}");
        } else {
            strBuff.append(",\"").append(statsSet.fileIOExcStats.getFullName()).append("\":").append(statsSet.fileIOExcStats.getValue()).append(",\"").append(statsSet.zkExcStats.getFullName()).append("\":").append(statsSet.zkExcStats.getValue()).append(",\"").append(statsSet.brokerTimeoutStats.getFullName()).append("\":").append(statsSet.brokerTimeoutStats.getValue()).append(",\"").append(statsSet.brokerHBExcStats.getFullName()).append("\":").append(statsSet.brokerHBExcStats.getValue()).append(",\"").append(csmOnlineCnt.getFullName()).append("\":").append(csmOnlineCnt.getValue()).append(",\"").append(statsSet.csmTimeoutStats.getFullName()).append("\":").append(statsSet.csmTimeoutStats.getValue()).append(",\"").append(statsSet.errPubOverFlowStats.getFullName()).append("\":").append(statsSet.errPubOverFlowStats.getValue()).append(",");
            statsSet.fileSyncDltStats.getValue(strBuff, false);
            strBuff.append(",");
            statsSet.zkSyncDltStats.getValue(strBuff, false);
            strBuff.append(",");
            statsSet.msgPubLatencyStats.getValue(strBuff, false);
            strBuff.append(",");
            statsSet.msgSubLatencyStats.getValue(strBuff, false);
            strBuff.append(",");
            statsSet.msgConfirmLatencyStats.getValue(strBuff, false);
            strBuff.append("}");
        }
    }

    private static int getIndex() {
        return BrokerSrvStatsHolder.getIndex(writableIndex.get());
    }

    private static int getIndex(int origIndex) {
        return Math.abs(origIndex % 2);
    }

    static {
        BrokerSrvStatsHolder.switchableSets[0] = new ServiceStatsSet();
        BrokerSrvStatsHolder.switchableSets[1] = new ServiceStatsSet();
    }

    private static class ServiceStatsSet {
        protected final SinceTime lstResetTime = new SinceTime("reset_time", null);
        protected final ESTHistogram fileSyncDltStats = new ESTHistogram("file_sync_dlt", null);
        protected final LongStatsCounter fileIOExcStats = new LongStatsCounter("file_exc_cnt", null);
        protected final ESTHistogram zkSyncDltStats = new ESTHistogram("zk_sync_dlt", null);
        protected final LongStatsCounter zkExcStats = new LongStatsCounter("zk_exc_cnt", null);
        protected final LongStatsCounter brokerTimeoutStats = new LongStatsCounter("broker_timeout_cnt", null);
        protected final LongStatsCounter brokerHBExcStats = new LongStatsCounter("broker_hb_exc_cnt", null);
        protected final LongStatsCounter csmTimeoutStats = new LongStatsCounter("consume_timeout_cnt", null);
        protected final ESTHistogram msgPubLatencyStats = new ESTHistogram("msg_put_dlt", null);
        protected final LongStatsCounter errPubOverFlowStats = new LongStatsCounter("msg_put_overflow", null);
        protected final ESTHistogram msgSubLatencyStats = new ESTHistogram("msg_get_dlt", null);
        protected final ESTHistogram msgConfirmLatencyStats = new ESTHistogram("msg_confirm_dlt", null);

        public ServiceStatsSet() {
            this.resetSinceTime();
        }

        public void resetSinceTime() {
            this.lstResetTime.reset();
        }
    }
}

