/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset.offsetstorage;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class OffsetStorageInfo
implements Serializable {
    private static final long serialVersionUID = -4232003748320500757L;
    private final String topic;
    private final int brokerId;
    private final int partitionId;
    private final AtomicLong offset = new AtomicLong(0L);
    private long messageId;
    private boolean firstCreate = false;
    private boolean modified = false;

    public OffsetStorageInfo(String topic, int brokerId, int partitionId, long offset, long messageId) {
        this(topic, brokerId, partitionId, offset, messageId, true);
    }

    public OffsetStorageInfo(String topic, int brokerId, int partitionId, long offset, long messageId, boolean firstCreate) {
        this.topic = topic;
        this.brokerId = brokerId;
        this.partitionId = partitionId;
        this.offset.set(offset - offset % 28L);
        this.messageId = messageId;
        this.firstCreate = firstCreate;
        if (firstCreate) {
            this.modified = true;
        }
    }

    public boolean isFirstCreate() {
        return this.firstCreate;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getOffset() {
        return this.offset.get();
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public long addAndGetOffset(long tmpOffset) {
        this.firstCreate = false;
        this.modified = true;
        return this.offset.addAndGet(tmpOffset - tmpOffset % 28L);
    }

    public long getAndSetOffset(long absOffset) {
        this.firstCreate = false;
        this.modified = true;
        return this.offset.getAndSet(absOffset - absOffset % 28L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffsetStorageInfo)) {
            return false;
        }
        OffsetStorageInfo that = (OffsetStorageInfo)o;
        if (this.brokerId != that.brokerId) {
            return false;
        }
        if (this.partitionId != that.partitionId) {
            return false;
        }
        if (this.messageId != that.messageId) {
            return false;
        }
        if (this.firstCreate != that.firstCreate) {
            return false;
        }
        if (this.modified != that.modified) {
            return false;
        }
        if (!this.topic.equals(that.topic)) {
            return false;
        }
        return this.offset.get() == that.offset.get();
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.brokerId;
        result = 31 * result + this.partitionId;
        result = 31 * result + this.offset.hashCode();
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        result = 31 * result + (this.firstCreate ? 1 : 0);
        result = 31 * result + (this.modified ? 1 : 0);
        return result;
    }

    public String toString() {
        return new StringBuilder(512).append("OffsetStorageInfo [OffsetStoreKey=").append(this.topic).append("-").append(this.brokerId).append("-").append(this.partitionId).append(", offset=").append(this.offset.get()).append(", messageId=").append(this.messageId).append(", modified=").append(this.modified).append(", firstCreate=").append(this.firstCreate).append("]").toString();
    }
}

