/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.broker.offset.OffsetCsmItem;
import org.apache.inlong.tubemq.server.broker.offset.OffsetCsmRecord;

public class OffsetHistoryInfo {
    private final int brokerId;
    private final String groupName;
    private final Map<String, Map<Integer, OffsetCsmRecord>> histOffsetMap = new HashMap<String, Map<Integer, OffsetCsmRecord>>();

    public OffsetHistoryInfo(int brokerId, String groupName) {
        this.brokerId = brokerId;
        this.groupName = groupName;
    }

    public void addCfmOffsetInfo(String topicName, int partitionId, long cfmOffset) {
        OffsetCsmRecord offsetCsmRecord;
        HashMap<Integer, OffsetCsmRecord> tmpMap;
        int storeId = partitionId < 10000 ? 0 : partitionId / 10000;
        HashMap<Integer, OffsetCsmRecord> storeOffsetMap = this.histOffsetMap.get(topicName);
        if (storeOffsetMap == null && (storeOffsetMap = (HashMap<Integer, OffsetCsmRecord>)this.histOffsetMap.putIfAbsent(topicName, tmpMap = new HashMap<Integer, OffsetCsmRecord>())) == null) {
            storeOffsetMap = tmpMap;
        }
        if ((offsetCsmRecord = storeOffsetMap.get(storeId)) == null) {
            OffsetCsmRecord tmpRecord = new OffsetCsmRecord(storeId);
            offsetCsmRecord = storeOffsetMap.putIfAbsent(storeId, tmpRecord);
            if (offsetCsmRecord == null) {
                offsetCsmRecord = tmpRecord;
            }
        }
        offsetCsmRecord.addOffsetCfmInfo(partitionId, cfmOffset);
    }

    public void addInflightOffsetInfo(String topicName, int partitionId, long tmpOffset) {
        OffsetCsmRecord offsetCsmRecord;
        HashMap<Integer, OffsetCsmRecord> tmpMap;
        int storeId = partitionId < 10000 ? 0 : partitionId / 10000;
        HashMap<Integer, OffsetCsmRecord> storeOffsetMap = this.histOffsetMap.get(topicName);
        if (storeOffsetMap == null && (storeOffsetMap = (HashMap<Integer, OffsetCsmRecord>)this.histOffsetMap.putIfAbsent(topicName, tmpMap = new HashMap<Integer, OffsetCsmRecord>())) == null) {
            storeOffsetMap = tmpMap;
        }
        if ((offsetCsmRecord = storeOffsetMap.get(storeId)) == null) {
            OffsetCsmRecord tmpRecord = new OffsetCsmRecord(storeId);
            offsetCsmRecord = storeOffsetMap.putIfAbsent(storeId, tmpRecord);
            if (offsetCsmRecord == null) {
                offsetCsmRecord = tmpRecord;
            }
        }
        offsetCsmRecord.addOffsetFetchInfo(partitionId, tmpOffset);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Map<String, Map<Integer, OffsetCsmRecord>> getOffsetMap() {
        return this.histOffsetMap;
    }

    public void buildRecordInfo(StringBuilder strBuff, long dataTime) {
        int topicCnt = 0;
        strBuff.append("{\"dt\":\"").append(DateTimeConvertUtils.ms2yyyyMMddHHmmss((long)dataTime)).append("\",\"bId\":").append(this.brokerId).append(",\"ver\":").append(2).append(",\"records\":[");
        for (Map.Entry<String, Map<Integer, OffsetCsmRecord>> entry : this.histOffsetMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            if (topicCnt++ > 0) {
                strBuff.append(",");
            }
            int recordCnt = 0;
            strBuff.append("{\"topic\":\"").append(entry.getKey()).append("\",\"offsets\":[");
            Map<Integer, OffsetCsmRecord> csmOffsetRecordMap = entry.getValue();
            for (OffsetCsmRecord offsetRecord : csmOffsetRecordMap.values()) {
                if (offsetRecord == null) continue;
                if (recordCnt++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("{\"storeId\":").append(offsetRecord.storeId).append(",\"iMin\":").append(offsetRecord.offsetMin).append(",\"iMax\":").append(offsetRecord.offsetMax).append(",\"dMin\":").append(offsetRecord.dataMin).append(",\"dMax\":").append(offsetRecord.dataMax).append(",\"parts\":[");
                int partCnt = 0;
                for (OffsetCsmItem csmOffsetItem : offsetRecord.partitionCsmMap.values()) {
                    if (csmOffsetItem == null) continue;
                    if (partCnt++ > 0) {
                        strBuff.append(",");
                    }
                    strBuff.append("{\"partId\":").append(csmOffsetItem.partitionId).append(",\"iCfm\":").append(csmOffsetItem.offsetCfm).append("}");
                }
                strBuff.append("]}");
            }
            strBuff.append("]}");
        }
        strBuff.append("]}");
    }

    public static boolean parseRecordInfo(String jsonData, ProcessResult result) {
        JsonObject jsonObject = null;
        try {
            jsonObject = JsonParser.parseString((String)jsonData).getAsJsonObject();
        }
        catch (Throwable e1) {
            result.setFailResult(String.format("Parse history offset value failure, reason is %s", e1.getMessage()));
            return result.isSuccess();
        }
        if (jsonObject == null) {
            result.setFailResult("Parse error, history offset value must be valid json format!");
            return result.isSuccess();
        }
        if (!jsonObject.has("ver")) {
            result.setFailResult("FIELD ver is required in history offset value!");
            return result.isSuccess();
        }
        int verValue = jsonObject.get("ver").getAsInt();
        if (verValue < 2) {
            result.setFailResult("Only support v2 or next version in history offset value!");
            return result.isSuccess();
        }
        if (!jsonObject.has("records")) {
            result.setFailResult("FIELD records is required in history offset value!");
            return result.isSuccess();
        }
        ArrayList<Tuple3> resetOffsets = new ArrayList<Tuple3>();
        JsonArray records = jsonObject.get("records").getAsJsonArray();
        for (int i = 0; i < records.size(); ++i) {
            JsonObject itemInfo = records.get(i).getAsJsonObject();
            if (itemInfo == null) continue;
            String topicName = itemInfo.get("topic").getAsString();
            JsonArray offsets = itemInfo.get("offsets").getAsJsonArray();
            for (int j = 0; j < offsets.size(); ++j) {
                JsonObject storeInfo = offsets.get(j).getAsJsonObject();
                if (storeInfo == null) continue;
                JsonArray partInfos = storeInfo.get("parts").getAsJsonArray();
                for (int k = 0; k < partInfos.size(); ++k) {
                    JsonObject partItem = partInfos.get(k).getAsJsonObject();
                    int partId = partItem.get("partId").getAsInt();
                    long offsetVal = partItem.get("iCfm").getAsLong();
                    resetOffsets.add(new Tuple3((Object)topicName, (Object)partId, (Object)offsetVal));
                }
            }
        }
        result.setSuccResult(resetOffsets);
        return true;
    }
}

