/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.daemon.AbstractDaemonService;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.broker.BrokerConfig;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStore;
import org.apache.inlong.tubemq.server.broker.offset.OffsetHistoryInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetService;
import org.apache.inlong.tubemq.server.broker.offset.offsetstorage.OffsetStorage;
import org.apache.inlong.tubemq.server.broker.offset.offsetstorage.OffsetStorageInfo;
import org.apache.inlong.tubemq.server.broker.offset.offsetstorage.ZkOffsetStorage;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOffsetManager
extends AbstractDaemonService
implements OffsetService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOffsetManager.class);
    private final BrokerConfig brokerConfig;
    private final OffsetStorage zkOffsetStorage;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, OffsetStorageInfo>> cfmOffsetMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> tmpOffsetMap = new ConcurrentHashMap();

    public DefaultOffsetManager(BrokerConfig brokerConfig) {
        super("[Offset Manager]", brokerConfig.getZkConfig().getZkCommitPeriodMs());
        this.brokerConfig = brokerConfig;
        this.zkOffsetStorage = new ZkOffsetStorage(brokerConfig.getZkConfig(), true, brokerConfig.getBrokerId());
        super.start();
    }

    protected void loopProcess(StringBuilder strBuff) {
        try {
            this.commitCfmOffsets(false);
        }
        catch (Throwable t) {
            logger.error("[Offset Manager] Daemon commit thread throw error ", t);
        }
    }

    @Override
    public void close(long waitTimeMs) {
        if (super.stop()) {
            return;
        }
        logger.info("[Offset Manager] begin reserve temporary Offset.....");
        this.commitTmpOffsets();
        logger.info("[Offset Manager] begin reserve final Offset.....");
        this.commitCfmOffsets(true);
        this.zkOffsetStorage.close();
        logger.info("[Offset Manager] Offset Manager service stopped!");
    }

    @Override
    public OffsetStorageInfo loadOffset(MessageStore msgStore, String group, String topic, int partitionId, int readStatus, long reqOffset, StringBuilder sBuilder) {
        long indexMaxOffset = msgStore.getIndexMaxOffset();
        long indexMinOffset = msgStore.getIndexMinOffset();
        long defOffset = readStatus == 0 ? indexMinOffset : indexMaxOffset;
        String offsetCacheKey = this.getOffsetCacheKey(topic, partitionId);
        OffsetStorageInfo regInfo = this.loadOrCreateOffset(group, topic, partitionId, offsetCacheKey, defOffset);
        this.getAndResetTmpOffset(group, offsetCacheKey);
        long curOffset = regInfo.getOffset();
        boolean isFirstCreate = regInfo.isFirstCreate();
        if (reqOffset >= 0L || readStatus == 2) {
            long adjOffset = indexMaxOffset;
            if (readStatus != 2) {
                adjOffset = MixedUtils.mid((long)reqOffset, (long)indexMinOffset, (long)indexMaxOffset);
            }
            regInfo.getAndSetOffset(adjOffset);
        }
        sBuilder.append("[Offset Manager]");
        switch (readStatus) {
            case 2: {
                sBuilder.append(" Consume From Max Offset Always");
                break;
            }
            case 1: {
                sBuilder.append(" Consume From Max Offset");
                break;
            }
            default: {
                sBuilder.append(" Normal Offset");
            }
        }
        if (!isFirstCreate) {
            sBuilder.append(",Continue");
        }
        long currentOffset = regInfo.getOffset();
        long offsetDelta = indexMaxOffset - currentOffset;
        logger.info(sBuilder.append(",requestOffset=").append(reqOffset).append(",loadedOffset=").append(curOffset).append(",currentOffset=").append(currentOffset).append(",maxOffset=").append(indexMaxOffset).append(",offsetDelta=").append(offsetDelta).append(",lagLevel=").append(this.getLagLevel(offsetDelta)).append(",group=").append(group).append(",topic-part=").append(offsetCacheKey).toString());
        sBuilder.delete(0, sBuilder.length());
        return regInfo;
    }

    @Override
    public long getOffset(MessageStore msgStore, String group, String topic, int partitionId, boolean isManCommit, boolean lastConsumed, StringBuilder sb) {
        String offsetCacheKey = this.getOffsetCacheKey(topic, partitionId);
        OffsetStorageInfo regInfo = this.loadOrCreateOffset(group, topic, partitionId, offsetCacheKey, 0L);
        long requestOffset = regInfo.getOffset();
        if (isManCommit) {
            requestOffset += this.getTmpOffset(group, topic, partitionId);
        } else if (lastConsumed) {
            requestOffset = this.commitOffset(group, topic, partitionId, true);
        }
        long maxOffset = msgStore.getIndexMaxOffset();
        long minOffset = msgStore.getIndexMinOffset();
        if (requestOffset >= maxOffset) {
            if (requestOffset > maxOffset && this.brokerConfig.isUpdateConsumerOffsets()) {
                logger.warn(sb.append("[Offset Manager] requestOffset is bigger than maxOffset, reset! requestOffset=").append(requestOffset).append(",maxOffset=").append(maxOffset).append(",group=").append(group).append(",topic-part=").append(offsetCacheKey).toString());
                sb.delete(0, sb.length());
                this.setTmpOffset(group, offsetCacheKey, maxOffset - requestOffset);
                if (!isManCommit) {
                    requestOffset = this.commitOffset(group, topic, partitionId, true);
                }
            }
            return -requestOffset;
        }
        if (requestOffset < minOffset) {
            logger.warn(sb.append("[Offset Manager] requestOffset is lower than minOffset, reset! requestOffset=").append(requestOffset).append(",minOffset=").append(minOffset).append(",group=").append(group).append(",topic-part=").append(offsetCacheKey).toString());
            sb.delete(0, sb.length());
            this.setTmpOffset(group, offsetCacheKey, minOffset - requestOffset);
            requestOffset = this.commitOffset(group, topic, partitionId, true);
        }
        return requestOffset;
    }

    @Override
    public long getOffset(String group, String topic, int partitionId) {
        OffsetStorageInfo regInfo = this.loadOrCreateOffset(group, topic, partitionId, this.getOffsetCacheKey(topic, partitionId), 0L);
        return regInfo.getOffset();
    }

    @Override
    public void bookOffset(String group, String topic, int partitionId, int readDalt, boolean isManCommit, boolean isMsgEmpty, StringBuilder sb) {
        if (readDalt == 0) {
            return;
        }
        String offsetCacheKey = this.getOffsetCacheKey(topic, partitionId);
        if (isManCommit) {
            long tmpOffset = this.getTmpOffset(group, topic, partitionId);
            this.setTmpOffset(group, offsetCacheKey, (long)readDalt + tmpOffset);
        } else {
            this.setTmpOffset(group, offsetCacheKey, readDalt);
            if (isMsgEmpty) {
                this.commitOffset(group, topic, partitionId, true);
            }
        }
    }

    @Override
    public long commitOffset(String group, String topic, int partitionId, boolean isConsumed) {
        String offsetCacheKey = this.getOffsetCacheKey(topic, partitionId);
        long tmpOffset = this.getAndResetTmpOffset(group, offsetCacheKey);
        if (!isConsumed) {
            tmpOffset = 0L;
        }
        OffsetStorageInfo regInfo = this.loadOrCreateOffset(group, topic, partitionId, offsetCacheKey, 0L);
        if (tmpOffset == 0L && !regInfo.isFirstCreate()) {
            return regInfo.getOffset();
        }
        long updatedOffset = regInfo.addAndGetOffset(tmpOffset);
        if (logger.isDebugEnabled()) {
            logger.debug(new StringBuilder(512).append("[Offset Manager] Update offset finished, offset=").append(updatedOffset).append(",group=").append(group).append(",topic-part=").append(offsetCacheKey).toString());
        }
        return updatedOffset;
    }

    @Override
    public long resetOffset(MessageStore store, String group, String topic, int partitionId, long reSetOffset, String modifier) {
        long oldOffset = -1L;
        if (store != null) {
            long indexMaxOffset = store.getIndexMaxOffset();
            reSetOffset = MixedUtils.mid((long)reSetOffset, (long)store.getIndexMinOffset(), (long)indexMaxOffset);
            String offsetCacheKey = this.getOffsetCacheKey(topic, partitionId);
            this.getAndResetTmpOffset(group, offsetCacheKey);
            OffsetStorageInfo regInfo = this.loadOrCreateOffset(group, topic, partitionId, offsetCacheKey, 0L);
            oldOffset = regInfo.getAndSetOffset(reSetOffset);
            long currentOffset = regInfo.getOffset();
            long offsetDelta = indexMaxOffset - currentOffset;
            logger.info(new StringBuilder(512).append("[Offset Manager] Manual update offset by modifier=").append(modifier).append(",resetOffset=").append(reSetOffset).append(",loadedOffset=").append(oldOffset).append(",currentOffset=").append(currentOffset).append(",maxOffset=").append(indexMaxOffset).append(",offsetDelta=").append(offsetDelta).append(",lagLevel=").append(this.getLagLevel(offsetDelta)).append(",group=").append(group).append(",topic-part=").append(offsetCacheKey).toString());
        }
        return oldOffset;
    }

    @Override
    public long getTmpOffset(String group, String topic, int partitionId) {
        String offsetCacheKey = this.getOffsetCacheKey(topic, partitionId);
        ConcurrentHashMap<String, Long> partTmpOffsetMap = this.tmpOffsetMap.get(group);
        if (partTmpOffsetMap != null) {
            Long tmpOffset = partTmpOffsetMap.get(offsetCacheKey);
            if (tmpOffset == null) {
                return 0L;
            }
            return tmpOffset - tmpOffset % 28L;
        }
        return 0L;
    }

    @Override
    public Set<String> getBookedGroups() {
        HashSet<String> groupSet = new HashSet<String>(this.cfmOffsetMap.keySet());
        Map<String, Set<String>> localGroups = this.zkOffsetStorage.queryZkAllGroupTopicInfos();
        groupSet.addAll(localGroups.keySet());
        return groupSet;
    }

    @Override
    public Set<String> getInMemoryGroups() {
        return new HashSet<String>(this.cfmOffsetMap.keySet());
    }

    @Override
    public Set<String> getUnusedGroupInfo() {
        HashSet<String> unUsedGroups = new HashSet<String>();
        Map<String, Set<String>> localGroups = this.zkOffsetStorage.queryZkAllGroupTopicInfos();
        for (String groupName : localGroups.keySet()) {
            if (this.cfmOffsetMap.containsKey(groupName)) continue;
            unUsedGroups.add(groupName);
        }
        return unUsedGroups;
    }

    @Override
    public Set<String> getGroupSubInfo(String group) {
        Set<String> result = new HashSet<String>();
        Map topicPartOffsetMap = this.cfmOffsetMap.get(group);
        if (topicPartOffsetMap == null) {
            ArrayList<String> groupLst = new ArrayList<String>(1);
            groupLst.add(group);
            Map<String, Set<String>> groupTopicInfo = this.zkOffsetStorage.queryZKGroupTopicInfo(groupLst);
            result = groupTopicInfo.get(group);
        } else {
            for (OffsetStorageInfo storageInfo : topicPartOffsetMap.values()) {
                result.add(storageInfo.getTopic());
            }
        }
        return result;
    }

    @Override
    public Map<String, Map<Integer, Tuple2<Long, Long>>> queryGroupOffset(String group, Map<String, Set<Integer>> topicPartMap) {
        HashMap<String, Map<Integer, Tuple2<Long, Long>>> result = new HashMap<String, Map<Integer, Tuple2<Long, Long>>>();
        Map topicPartOffsetMap = this.cfmOffsetMap.get(group);
        if (topicPartOffsetMap == null) {
            for (Map.Entry<String, Set<Integer>> entry : topicPartMap.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                Map<Integer, Long> qryResult = this.zkOffsetStorage.queryGroupOffsetInfo(group, entry.getKey(), entry.getValue());
                HashMap<Integer, Tuple2> offsetMap = new HashMap<Integer, Tuple2>();
                for (Map.Entry<Integer, Long> item : qryResult.entrySet()) {
                    if (item == null || item.getKey() == null || item.getValue() == null) continue;
                    offsetMap.put(item.getKey(), new Tuple2((Object)item.getValue(), (Object)0L));
                }
                if (offsetMap.isEmpty()) continue;
                result.put(entry.getKey(), offsetMap);
            }
        } else {
            Map tmpPartOffsetMap = this.tmpOffsetMap.get(group);
            for (Map.Entry<String, Set<Integer>> entry : topicPartMap.entrySet()) {
                HashMap<Integer, Tuple2> offsetMap = new HashMap<Integer, Tuple2>();
                for (Integer partitionId : entry.getValue()) {
                    String offsetCacheKey = this.getOffsetCacheKey(entry.getKey(), partitionId);
                    OffsetStorageInfo offsetInfo = (OffsetStorageInfo)topicPartOffsetMap.get(offsetCacheKey);
                    Long tmpOffset = (Long)tmpPartOffsetMap.get(offsetCacheKey);
                    if (tmpOffset == null) {
                        tmpOffset = 0L;
                    }
                    if (offsetInfo == null) continue;
                    offsetMap.put(partitionId, new Tuple2((Object)offsetInfo.getOffset(), (Object)tmpOffset));
                }
                if (offsetMap.isEmpty()) continue;
                result.put(entry.getKey(), offsetMap);
            }
        }
        return result;
    }

    @Override
    public Map<String, OffsetHistoryInfo> getOnlineGroupOffsetInfo() {
        HashMap<String, OffsetHistoryInfo> result = new HashMap<String, OffsetHistoryInfo>();
        for (Map.Entry<String, ConcurrentHashMap<String, OffsetStorageInfo>> entry : this.cfmOffsetMap.entrySet()) {
            Map storeMap;
            if (entry == null || entry.getKey() == null || entry.getValue() == null || (storeMap = (Map)entry.getValue()).isEmpty()) continue;
            for (OffsetStorageInfo storageInfo : storeMap.values()) {
                if (storageInfo == null) continue;
                OffsetHistoryInfo recordInfo = (OffsetHistoryInfo)result.get(entry.getKey());
                if (recordInfo == null) {
                    recordInfo = new OffsetHistoryInfo(this.brokerConfig.getBrokerId(), entry.getKey());
                    result.put(entry.getKey(), recordInfo);
                }
                recordInfo.addCfmOffsetInfo(storageInfo.getTopic(), storageInfo.getPartitionId(), storageInfo.getOffset());
            }
        }
        return result;
    }

    @Override
    public boolean modifyGroupOffset(Set<String> groups, List<Tuple3<String, Integer, Long>> topicPartOffsets, String modifier) {
        boolean changed = false;
        StringBuilder strBuff = new StringBuilder(512);
        for (String group : groups) {
            for (Tuple3<String, Integer, Long> tuple3 : topicPartOffsets) {
                if (tuple3 == null || tuple3.getF0() == null || tuple3.getF1() == null || tuple3.getF2() == null) continue;
                String offsetCacheKey = this.getOffsetCacheKey((String)tuple3.getF0(), (Integer)tuple3.getF1());
                this.getAndResetTmpOffset(group, offsetCacheKey);
                OffsetStorageInfo regInfo = this.loadOrCreateOffset(group, (String)tuple3.getF0(), (Integer)tuple3.getF1(), offsetCacheKey, 0L);
                long oldOffset = regInfo.getAndSetOffset((Long)tuple3.getF2());
                changed = true;
                logger.info(strBuff.append("[Offset Manager] Update offset by modifier=").append(modifier).append(",resetOffset=").append(tuple3.getF2()).append(",loadedOffset=").append(oldOffset).append(",currentOffset=").append(regInfo.getOffset()).append(",group=").append(group).append(",topic-part=").append(offsetCacheKey).toString());
                strBuff.delete(0, strBuff.length());
            }
        }
        return changed;
    }

    @Override
    public void deleteGroupOffset(boolean onlyMemory, Map<String, Map<String, Set<Integer>>> groupTopicPartMap, String modifier) {
        String printBase;
        StringBuilder strBuff = new StringBuilder(512);
        for (Map.Entry<String, Map<String, Set<Integer>>> entry : groupTopicPartMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            this.rmvOffset(entry.getKey(), entry.getValue());
        }
        if (onlyMemory) {
            printBase = strBuff.append("[Offset Manager] delete offset from memory by modifier=").append(modifier).toString();
        } else {
            this.zkOffsetStorage.deleteGroupOffsetInfo(groupTopicPartMap);
            printBase = strBuff.append("[Offset Manager] delete offset from memory and zk by modifier=").append(modifier).toString();
        }
        strBuff.delete(0, strBuff.length());
        for (Map.Entry<String, Map<String, Set<Integer>>> entry : groupTopicPartMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            logger.info(strBuff.append(printBase).append(",group=").append(entry.getKey()).append(",topic-partId-map=").append(entry.getValue()).toString());
            strBuff.delete(0, strBuff.length());
        }
    }

    private long setTmpOffset(String group, String offsetCacheKey, long origOffset) {
        Long befOffset;
        ConcurrentHashMap tmpMap;
        long tmpOffset = origOffset - origOffset % 28L;
        ConcurrentHashMap<String, Long> partTmpOffsetMap = this.tmpOffsetMap.get(group);
        if (partTmpOffsetMap == null && (partTmpOffsetMap = this.tmpOffsetMap.putIfAbsent(group, tmpMap = new ConcurrentHashMap())) == null) {
            partTmpOffsetMap = tmpMap;
        }
        if ((befOffset = partTmpOffsetMap.put(offsetCacheKey, tmpOffset)) == null) {
            return 0L;
        }
        return befOffset - befOffset % 28L;
    }

    private long getAndResetTmpOffset(String group, String offsetCacheKey) {
        return this.setTmpOffset(group, offsetCacheKey, 0L);
    }

    private void commitTmpOffsets() {
        for (Map.Entry<String, ConcurrentHashMap<String, Long>> entry : this.tmpOffsetMap.entrySet()) {
            if (TStringUtils.isBlank((String)entry.getKey()) || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            for (Map.Entry<String, Long> topicEntry : entry.getValue().entrySet()) {
                if (TStringUtils.isBlank((String)topicEntry.getKey())) continue;
                String[] topicPartStrs = topicEntry.getKey().split("-");
                String topic = topicPartStrs[0];
                int partitionId = Integer.parseInt(topicPartStrs[1]);
                try {
                    this.commitOffset(entry.getKey(), topic, partitionId, true);
                }
                catch (Exception e) {
                    logger.warn("[Offset Manager] Commit tmp offset error!", (Throwable)e);
                }
            }
        }
    }

    private void commitCfmOffsets(boolean retryable) {
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, ConcurrentHashMap<String, OffsetStorageInfo>> entry : this.cfmOffsetMap.entrySet()) {
            if (TStringUtils.isBlank((String)entry.getKey()) || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            this.zkOffsetStorage.commitOffset(entry.getKey(), entry.getValue().values(), retryable);
        }
        BrokerSrvStatsHolder.updZKSyncDataDlt(System.currentTimeMillis() - startTime);
    }

    private OffsetStorageInfo loadOrCreateOffset(String group, String topic, int partitionId, String offsetCacheKey, long defOffset) {
        OffsetStorageInfo regInfo;
        ConcurrentHashMap tmpRegInfoMap;
        ConcurrentHashMap<String, OffsetStorageInfo> regInfoMap = this.cfmOffsetMap.get(group);
        if (regInfoMap == null && (regInfoMap = this.cfmOffsetMap.putIfAbsent(group, tmpRegInfoMap = new ConcurrentHashMap())) == null) {
            regInfoMap = tmpRegInfoMap;
        }
        if ((regInfo = regInfoMap.get(offsetCacheKey)) == null) {
            OffsetStorageInfo tmpRegInfo = this.zkOffsetStorage.loadOffset(group, topic, partitionId);
            if (tmpRegInfo == null) {
                tmpRegInfo = new OffsetStorageInfo(topic, this.brokerConfig.getBrokerId(), partitionId, defOffset, 0L);
            }
            if ((regInfo = regInfoMap.putIfAbsent(offsetCacheKey, tmpRegInfo)) == null) {
                regInfo = tmpRegInfo;
            }
        }
        return regInfo;
    }

    private void rmvOffset(String group, Map<String, Set<Integer>> topicPartMap) {
        ConcurrentHashMap<String, Long> tmpRegInfoMap;
        if (group == null || topicPartMap == null || topicPartMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap<String, OffsetStorageInfo> regInfoMap = this.cfmOffsetMap.get(group);
        if (regInfoMap != null) {
            for (Map.Entry<String, Set<Integer>> entry : topicPartMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                for (Integer partitionId : entry.getValue()) {
                    String offsetCacheKey = this.getOffsetCacheKey(entry.getKey(), partitionId);
                    regInfoMap.remove(offsetCacheKey);
                }
            }
            if (regInfoMap.isEmpty()) {
                this.cfmOffsetMap.remove(group);
            }
        }
        if ((tmpRegInfoMap = this.tmpOffsetMap.get(group)) != null) {
            for (Map.Entry<String, Set<Integer>> entry : topicPartMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                for (Integer partitionId : entry.getValue()) {
                    String offsetCacheKey = this.getOffsetCacheKey(entry.getKey(), partitionId);
                    tmpRegInfoMap.remove(offsetCacheKey);
                }
            }
            if (tmpRegInfoMap.isEmpty()) {
                this.tmpOffsetMap.remove(group);
            }
        }
    }

    private String getOffsetCacheKey(String topic, int partitionId) {
        return new StringBuilder(256).append(topic).append("-").append(partitionId).toString();
    }

    private int getLagLevel(long lagValue) {
        return lagValue > 28000000L ? 2 : (lagValue > 2800000L ? 1 : 0);
    }
}

