/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker;

import java.security.Security;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.aaaclient.ClientAuthenticateHandler;
import org.apache.inlong.tubemq.corebase.aaaclient.SimpleClientAuthenticateHandler;
import org.apache.inlong.tubemq.corebase.cluster.MasterInfo;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlRuleHandler;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcServiceFactory;
import org.apache.inlong.tubemq.corerpc.client.ClientFactory;
import org.apache.inlong.tubemq.corerpc.netty.NettyClientFactory;
import org.apache.inlong.tubemq.corerpc.service.MasterService;
import org.apache.inlong.tubemq.server.Stoppable;
import org.apache.inlong.tubemq.server.broker.BrokerConfig;
import org.apache.inlong.tubemq.server.broker.BrokerServiceServer;
import org.apache.inlong.tubemq.server.broker.exception.StartupException;
import org.apache.inlong.tubemq.server.broker.metadata.BrokerMetadataManager;
import org.apache.inlong.tubemq.server.broker.metadata.ClusterConfigHolder;
import org.apache.inlong.tubemq.server.broker.metadata.MetadataManager;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStoreManager;
import org.apache.inlong.tubemq.server.broker.nodeinfo.ConsumerNodeInfo;
import org.apache.inlong.tubemq.server.broker.offset.DefaultOffsetManager;
import org.apache.inlong.tubemq.server.broker.offset.OffsetRecordService;
import org.apache.inlong.tubemq.server.broker.offset.OffsetService;
import org.apache.inlong.tubemq.server.broker.stats.BrokerJMXHolder;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.broker.stats.prometheus.BrokerPromMetricService;
import org.apache.inlong.tubemq.server.broker.utils.BrokerSamplePrint;
import org.apache.inlong.tubemq.server.broker.web.WebServer;
import org.apache.inlong.tubemq.server.common.aaaserver.SimpleCertificateBrokerHandler;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeBroker
implements Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(TubeBroker.class);
    private final BrokerConfig tubeConfig;
    private final String brokerId;
    private final NettyClientFactory clientFactory = new NettyClientFactory();
    private final RpcServiceFactory rpcServiceFactory;
    private final WebServer webServer;
    private final MetadataManager metadataManager;
    private final MessageStoreManager storeManager;
    private final OffsetService offsetManager;
    private final OffsetRecordService offsetRecordService;
    private final BrokerServiceServer brokerServiceServer;
    private final BrokerSamplePrint samplePrintCtrl = new BrokerSamplePrint(logger);
    private final ScheduledExecutorService scheduledExecutorService;
    private final ShutdownHook shutdownHook = new ShutdownHook();
    private final SimpleCertificateBrokerHandler serverAuthHandler;
    private final ClientAuthenticateHandler clientAuthHandler = new SimpleClientAuthenticateHandler();
    private MasterService masterService;
    private BrokerPromMetricService promMetricService;
    private boolean requireReportConf = false;
    private boolean isOnline = false;
    private final AtomicBoolean shutdown = new AtomicBoolean(true);
    private final AtomicBoolean isKeepAlive = new AtomicBoolean(false);
    private final AtomicLong lastRegTime = new AtomicLong(0L);
    private final AtomicBoolean shutdownHooked = new AtomicBoolean(false);
    private final AtomicLong heartbeatErrors = new AtomicLong(0L);
    private int maxReleaseTryCnt = 10;

    public TubeBroker(BrokerConfig tubeConfig) throws Exception {
        Security.setProperty("networkaddress.cache.ttl", "3");
        Security.setProperty("networkaddress.cache.negative.ttl", "1");
        if (tubeConfig.getZkConfig() != null && tubeConfig.getZkConfig().getZkRequestTimeoutMs() > 0) {
            System.setProperty("zookeeper.request.timeout", Integer.toString(tubeConfig.getZkConfig().getZkRequestTimeoutMs()));
        }
        this.tubeConfig = tubeConfig;
        this.brokerId = this.generateBrokerClientId();
        BrokerJMXHolder.registerMXBean();
        this.metadataManager = new BrokerMetadataManager();
        this.offsetManager = new DefaultOffsetManager(tubeConfig);
        this.storeManager = new MessageStoreManager(this, tubeConfig);
        this.serverAuthHandler = new SimpleCertificateBrokerHandler(this);
        this.offsetRecordService = new OffsetRecordService(this, tubeConfig.getGroupOffsetScanDurMs());
        RpcConfig rpcConfig = new RpcConfig();
        rpcConfig.put("rpc.connect.timeout", (Object)3000);
        rpcConfig.put("rpc.request.timeout", (Object)this.tubeConfig.getRpcReadTimeoutMs());
        this.clientFactory.configure(rpcConfig);
        this.rpcServiceFactory = new RpcServiceFactory((ClientFactory)this.clientFactory);
        this.brokerServiceServer = new BrokerServiceServer(this, tubeConfig);
        this.webServer = new WebServer(tubeConfig.getHostName(), tubeConfig.getWebPort(), this);
        this.webServer.start();
        this.promMetricService = new BrokerPromMetricService(this, tubeConfig.getPrometheusConfig());
        this.promMetricService.start();
        this.masterService = (MasterService)this.rpcServiceFactory.getFailoverService(MasterService.class, new MasterInfo(tubeConfig.getMasterAddressList()), rpcConfig);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Broker Heartbeat Thread");
                t.setPriority(10);
                return t;
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public ConsumerNodeInfo getConsumerNodeInfo(String storeKey) {
        return this.brokerServiceServer.getConsumerNodeInfo(storeKey);
    }

    public OffsetService getOffsetManager() {
        return this.offsetManager;
    }

    public BrokerConfig getTubeConfig() {
        return this.tubeConfig;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive.get();
    }

    public long getLastRegTime() {
        return this.lastRegTime.get();
    }

    public RpcServiceFactory getRpcServiceFactory() {
        return this.rpcServiceFactory;
    }

    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public SimpleCertificateBrokerHandler getServerAuthHandler() {
        return this.serverAuthHandler;
    }

    @Override
    public boolean isStopped() {
        return this.shutdown.get();
    }

    public MessageStoreManager getStoreManager() {
        return this.storeManager;
    }

    public BrokerServiceServer getBrokerServiceServer() {
        return this.brokerServiceServer;
    }

    public void start() throws Exception {
        logger.info("Starting tube server...");
        if (!this.shutdown.get()) {
            return;
        }
        this.shutdown.set(false);
        this.register2Master();
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!TubeBroker.this.shutdown.get()) {
                    long currErrCnt = TubeBroker.this.heartbeatErrors.get();
                    if (currErrCnt > (long)TubeBroker.this.maxReleaseTryCnt && currErrCnt % 2L == 0L) {
                        TubeBroker.this.heartbeatErrors.incrementAndGet();
                        return;
                    }
                    try {
                        ClientMaster.HeartResponseM2B response = TubeBroker.this.masterService.brokerHeartbeatB2M(TubeBroker.this.createBrokerHeartBeatRequest(), TubeBroker.this.tubeConfig.getHostName(), false);
                        if (!response.getSuccess()) {
                            TubeBroker.this.isKeepAlive.set(false);
                            if (response.getErrCode() == 411) {
                                BrokerSrvStatsHolder.incBrokerTimeoutCnt();
                                TubeBroker.this.register2Master();
                                TubeBroker.this.heartbeatErrors.set(0L);
                                logger.info("Re-register to master successfully!");
                            }
                            return;
                        }
                        TubeBroker.this.isKeepAlive.set(true);
                        TubeBroker.this.heartbeatErrors.set(0L);
                        StringBuilder sBuilder = new StringBuilder(512);
                        TubeBroker.this.procConfigFromHeartBeat(sBuilder, response);
                    }
                    catch (Throwable t) {
                        TubeBroker.this.isKeepAlive.set(false);
                        TubeBroker.this.heartbeatErrors.incrementAndGet();
                        BrokerSrvStatsHolder.incBrokerHBExcCnt();
                        TubeBroker.this.samplePrintCtrl.printExceptionCaught(t);
                    }
                }
            }
        }, this.tubeConfig.getHeartbeatPeriodMs(), this.tubeConfig.getHeartbeatPeriodMs(), TimeUnit.MILLISECONDS);
        this.storeManager.start();
        this.brokerServiceServer.start();
        this.isOnline = true;
        logger.info(new StringBuilder(512).append("Start tube server successfully, broker version=").append("1.8.0").toString());
    }

    public synchronized void reloadConfig() {
        this.tubeConfig.reload();
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public void stop(String why) {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        logger.info(why + ".Stopping Tube server...");
        try {
            this.webServer.stop();
            logger.info("Tube WebService stopped.......");
            this.masterService.brokerCloseClientB2M(this.createMasterCloseRequest(), this.tubeConfig.getHostName(), false);
            logger.info("Tube Closing to Master.....");
        }
        catch (Throwable e) {
            logger.warn("CloseBroker throw exception : ", e);
        }
        ThreadUtils.sleep((long)2000L);
        logger.info("Tube Client StoreService stopping.....");
        this.brokerServiceServer.stop();
        logger.info("Tube Client StoreService stopped.....");
        this.offsetRecordService.close();
        logger.info("Tube offset record service stopped.....");
        this.storeManager.close();
        logger.info("Tube message store stopped.....");
        this.offsetManager.close(-1L);
        logger.info("Tube offset store stopped.....");
        this.scheduledExecutorService.shutdownNow();
        if (!this.shutdownHooked.get()) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        try {
            this.rpcServiceFactory.destroy();
            this.clientFactory.shutdown();
        }
        catch (Throwable e2) {
            logger.error("Stop rpcService failure", e2);
        }
        logger.info("Stop tube server successfully.");
        LogManager.shutdown();
        ThreadUtils.sleep((long)2000L);
    }

    private String generateBrokerClientId() {
        return new StringBuilder(512).append(this.tubeConfig.getBrokerId()).append(":").append(this.tubeConfig.getHostName()).append(":").append(this.tubeConfig.getPort()).append(":").append("1.8.0").toString();
    }

    private void procConfigFromHeartBeat(StringBuilder strBuff, ClientMaster.HeartResponseM2B response) {
        boolean needProcess;
        long configId;
        ServiceStatusHolder.setReadWriteServiceStatus((boolean)response.getStopRead(), (boolean)response.getStopWrite(), (String)"Master");
        FlowCtrlRuleHandler defFlowCtrlHandler = this.metadataManager.getFlowCtrlRuleHandler();
        if (response.hasFlowCheckId() && response.getFlowCheckId() >= 0L && response.getFlowCheckId() != defFlowCtrlHandler.getFlowCtrlId()) {
            try {
                defFlowCtrlHandler.updateFlowCtrlInfo(response.getQryPriorityId(), response.getFlowCheckId(), response.getFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[HeartBeat response] found update flowCtrl rules failure", (Throwable)e1);
            }
        }
        this.requireReportConf = response.getNeedReportData();
        if (response.hasClsConfig() && (configId = response.getClsConfig().getConfigId()) != ClusterConfigHolder.getConfigId()) {
            ClusterConfigHolder.updClusterSetting(response.getClsConfig());
            logger.info(strBuff.append("[HeartBeat response] received cluster configure changed").append(",hasClsConfig=").append(response.hasClsConfig()).append(",curClusterConfigId=").append(ClusterConfigHolder.getConfigId()).append(",curMaxMsgSize=").append(ClusterConfigHolder.getMaxMsgSize()).append(",minMemCacheSize=").append(ClusterConfigHolder.getMinMemCacheSize()).toString());
            strBuff.delete(0, strBuff.length());
        }
        if (response.getTakeConfInfo()) {
            logger.info(strBuff.append("[HeartBeat response] received broker metadata info: brokerConfId=").append(response.getCurBrokerConfId()).append(",stopWrite=").append(response.getStopWrite()).append(",stopRead=").append(response.getStopRead()).append(",configCheckSumId=").append(response.getConfCheckSumId()).append(",hasFlowCtrl=").append(response.hasFlowCheckId()).append(",curFlowCtrlId=").append(defFlowCtrlHandler.getFlowCtrlId()).append(",curQryPriorityId=").append(defFlowCtrlHandler.getQryPriorityId()).append(",curMaxMsgSize=").append(ClusterConfigHolder.getMaxMsgSize()).append(",brokerDefaultConfInfo=").append(response.getBrokerDefaultConfInfo()).append(",brokerTopicSetConfList=").append(response.getBrokerTopicSetConfInfoList()).toString());
            strBuff.delete(0, strBuff.length());
            this.metadataManager.updateBrokerTopicConfigMap(response.getCurBrokerConfId(), response.getConfCheckSumId(), response.getBrokerDefaultConfInfo(), (List<String>)response.getBrokerTopicSetConfInfoList(), false, strBuff);
        }
        if (response.hasBrokerAuthorizedInfo()) {
            this.serverAuthHandler.appendVisitToken(response.getBrokerAuthorizedInfo());
        }
        if (needProcess = this.metadataManager.updateBrokerRemoveTopicMap(response.getTakeRemoveTopicInfo(), (List<String>)response.getRemoveTopicConfInfoList(), strBuff)) {
            new Thread(){

                @Override
                public void run() {
                    TubeBroker.this.storeManager.removeTopicStore();
                }
            }.start();
        }
    }

    private void register2Master() throws StartupException {
        int remainingRetry = 5;
        StringBuilder sBuilder = new StringBuilder(512);
        while (true) {
            try {
                ClientMaster.RegisterResponseM2B response = this.masterService.brokerRegisterB2M(this.createMasterRegisterRequest(), this.tubeConfig.getHostName(), false);
                if (!response.getSuccess()) {
                    logger.warn("Register to master failure, errInfo is " + response.getErrMsg());
                    throw new StartupException(sBuilder.append("Register to master failed! The error message is ").append(response.getErrMsg()).toString());
                }
                this.procConfigFromRegister(sBuilder, response);
                this.isKeepAlive.set(true);
                this.lastRegTime.set(System.currentTimeMillis());
            }
            catch (Throwable e) {
                sBuilder.delete(0, sBuilder.length());
                if (--remainingRetry == 0) {
                    throw new StartupException("Register to master failed!", e);
                }
                ThreadUtils.sleep((long)200L);
                continue;
            }
            break;
        }
    }

    private void procConfigFromRegister(StringBuilder strBuff, ClientMaster.RegisterResponseM2B response) {
        long configId;
        ServiceStatusHolder.setReadWriteServiceStatus((boolean)response.getStopRead(), (boolean)response.getStopWrite(), (String)"Master");
        FlowCtrlRuleHandler defFlowCtrlHandler = this.metadataManager.getFlowCtrlRuleHandler();
        if (response.hasFlowCheckId() && response.getFlowCheckId() >= 0L && response.getFlowCheckId() != defFlowCtrlHandler.getFlowCtrlId()) {
            try {
                defFlowCtrlHandler.updateFlowCtrlInfo(response.getQryPriorityId(), response.getFlowCheckId(), response.getFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[Register response] update default flowCtrl rules failure", (Throwable)e1);
            }
        }
        this.serverAuthHandler.configure(response.getEnableBrokerInfo());
        if (response.hasBrokerAuthorizedInfo()) {
            this.serverAuthHandler.appendVisitToken(response.getBrokerAuthorizedInfo());
        }
        if (response.hasClsConfig() && (configId = response.getClsConfig().getConfigId()) != ClusterConfigHolder.getConfigId()) {
            ClusterConfigHolder.updClusterSetting(response.getClsConfig());
        }
        strBuff.append("[Register response] received broker metadata info: brokerConfId=").append(response.getCurBrokerConfId()).append(",stopWrite=").append(response.getStopWrite()).append(",stopRead=").append(response.getStopRead()).append(",configCheckSumId=").append(response.getConfCheckSumId()).append(",hasFlowCtrl=").append(response.hasFlowCheckId()).append(",curFlowCtrlId=").append(defFlowCtrlHandler.getFlowCtrlId()).append(",curQryPriorityId=").append(defFlowCtrlHandler.getQryPriorityId()).append(",hasClsConfig=").append(response.hasClsConfig()).append(",curClusterConfigId=").append(ClusterConfigHolder.getConfigId()).append(",curMaxMsgSize=").append(ClusterConfigHolder.getMaxMsgSize()).append(",minMemCacheSize=").append(ClusterConfigHolder.getMinMemCacheSize()).append(",enableVisitTokenCheck=").append(this.serverAuthHandler.isEnableVisitTokenCheck()).append(",enableProduceAuthenticate=").append(this.serverAuthHandler.isEnableProduceAuthenticate()).append(",enableProduceAuthorize=").append(this.serverAuthHandler.isEnableProduceAuthorize()).append(",enableConsumeAuthenticate=").append(this.serverAuthHandler.isEnableConsumeAuthenticate()).append(",enableConsumeAuthorize=").append(this.serverAuthHandler.isEnableConsumeAuthorize()).append(",brokerDefaultConfInfo=").append(response.getBrokerDefaultConfInfo()).append(",brokerTopicSetConfList=").append(response.getBrokerTopicSetConfInfoList().toString()).toString();
        strBuff.delete(0, strBuff.length());
        this.metadataManager.updateBrokerTopicConfigMap(response.getCurBrokerConfId(), response.getConfCheckSumId(), response.getBrokerDefaultConfInfo(), (List<String>)response.getBrokerTopicSetConfInfoList(), true, strBuff);
    }

    private ClientMaster.ClusterConfig.Builder buildClusterConfig() {
        ClientMaster.ClusterConfig.Builder defSetting = ClientMaster.ClusterConfig.newBuilder();
        defSetting.setConfigId(ClusterConfigHolder.getConfigId());
        return defSetting;
    }

    private ClientMaster.RegisterRequestB2M createMasterRegisterRequest() throws Exception {
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder;
        List<String> topicConfInfoList;
        ClientMaster.RegisterRequestB2M.Builder builder = ClientMaster.RegisterRequestB2M.newBuilder();
        builder.setClientId(this.brokerId);
        builder.setBrokerOnline(this.isOnline);
        builder.setEnableTls(this.tubeConfig.isTlsEnable());
        builder.setTlsPort(this.tubeConfig.getTlsPort());
        builder.setReadStatusRpt(ServiceStatusHolder.getReadServiceReportStatus());
        builder.setWriteStatusRpt(ServiceStatusHolder.getWriteServiceReportStatus());
        builder.setCurBrokerConfId(this.metadataManager.getBrokerMetadataConfId());
        builder.setConfCheckSumId(this.metadataManager.getBrokerConfCheckSumId());
        FlowCtrlRuleHandler flowCtrlRuleHandler = this.metadataManager.getFlowCtrlRuleHandler();
        builder.setFlowCheckId(flowCtrlRuleHandler.getFlowCtrlId());
        builder.setQryPriorityId(flowCtrlRuleHandler.getQryPriorityId());
        String brokerDefaultConfInfo = this.metadataManager.getBrokerDefMetaConfInfo();
        if (brokerDefaultConfInfo != null) {
            builder.setBrokerDefaultConfInfo(brokerDefaultConfInfo);
        }
        if ((topicConfInfoList = this.metadataManager.getTopicMetaConfInfoLst()) != null) {
            builder.addAllBrokerTopicSetConfInfo(topicConfInfoList);
        }
        if ((authInfoBuilder = this.genMasterCertificateInfo()) != null) {
            builder.setAuthInfo(authInfoBuilder.build());
        }
        builder.setClsConfig(this.buildClusterConfig());
        logger.info(new StringBuilder(512).append("[Register request] current broker report info: brokerConfId=").append(this.metadataManager.getBrokerMetadataConfId()).append(",readStatusRpt=").append(builder.getReadStatusRpt()).append(",writeStatusRpt=").append(builder.getWriteStatusRpt()).append(",isTlsEnable=").append(this.tubeConfig.isTlsEnable()).append(",TlsPort=").append(this.tubeConfig.getTlsPort()).append(",flowCtrlId=").append(flowCtrlRuleHandler.getFlowCtrlId()).append(",QryPriorityId=").append(flowCtrlRuleHandler.getQryPriorityId()).append(",configCheckSumId=").append(this.metadataManager.getBrokerConfCheckSumId()).append(",brokerDefaultConfInfo=").append(brokerDefaultConfInfo).append(",brokerTopicSetConfList=").append(topicConfInfoList).toString());
        return builder.build();
    }

    private ClientMaster.HeartRequestB2M createBrokerHeartBeatRequest() {
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder;
        ClientMaster.HeartRequestB2M.Builder builder = ClientMaster.HeartRequestB2M.newBuilder();
        builder.setBrokerId(String.valueOf(this.tubeConfig.getBrokerId()));
        builder.setBrokerOnline(this.isOnline);
        builder.setReadStatusRpt(ServiceStatusHolder.getReadServiceReportStatus());
        builder.setWriteStatusRpt(ServiceStatusHolder.getWriteServiceReportStatus());
        builder.setCurBrokerConfId(this.metadataManager.getBrokerMetadataConfId());
        builder.setConfCheckSumId(this.metadataManager.getBrokerConfCheckSumId());
        FlowCtrlRuleHandler flowCtrlRuleHandler = this.metadataManager.getFlowCtrlRuleHandler();
        builder.setFlowCheckId(flowCtrlRuleHandler.getFlowCtrlId());
        builder.setQryPriorityId(flowCtrlRuleHandler.getQryPriorityId());
        builder.setTakeConfInfo(false);
        builder.setTakeRemovedTopicInfo(false);
        List<String> removedTopics = this.metadataManager.getHardRemovedTopics();
        if (!removedTopics.isEmpty()) {
            builder.setTakeRemovedTopicInfo(true);
            builder.addAllRemovedTopicsInfo(removedTopics);
        }
        if ((authInfoBuilder = this.genMasterCertificateInfo()) != null) {
            builder.setAuthInfo(authInfoBuilder.build());
        }
        builder.setClsConfig(this.buildClusterConfig());
        if (this.metadataManager.isBrokerMetadataChanged() || this.requireReportConf) {
            builder.setTakeConfInfo(true);
            builder.setBrokerDefaultConfInfo(this.metadataManager.getBrokerDefMetaConfInfo());
            builder.addAllBrokerTopicSetConfInfo(this.metadataManager.getTopicMetaConfInfoLst());
            logger.info(new StringBuilder(512).append("[HeartBeat request] current broker report info: brokerConfId=").append(this.metadataManager.getBrokerMetadataConfId()).append(",readStatusRpt=").append(builder.getReadStatusRpt()).append(",writeStatusRpt=").append(builder.getWriteStatusRpt()).append(",flowCtrlId=").append(flowCtrlRuleHandler.getFlowCtrlId()).append(",QryPriorityId=").append(flowCtrlRuleHandler.getQryPriorityId()).append(",ReadStatusRpt=").append(builder.getReadStatusRpt()).append(",WriteStatusRpt=").append(builder.getWriteStatusRpt()).append(",lastReportedConfigId=").append(this.metadataManager.getLastRptBrokerMetaConfId()).append(",configCheckSumId=").append(this.metadataManager.getBrokerConfCheckSumId()).append(",brokerDefaultConfInfo=").append(this.metadataManager.getBrokerDefMetaConfInfo()).append(",brokerTopicSetConfList=").append(this.metadataManager.getTopicMetaConfInfoLst()).toString());
            this.metadataManager.setLastRptBrokerMetaConfId(this.metadataManager.getBrokerMetadataConfId());
            this.requireReportConf = false;
        }
        return builder.build();
    }

    private ClientMaster.CloseRequestB2M createMasterCloseRequest() {
        ClientMaster.CloseRequestB2M.Builder builder = ClientMaster.CloseRequestB2M.newBuilder();
        builder.setBrokerId(String.valueOf(this.tubeConfig.getBrokerId()));
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = this.genMasterCertificateInfo();
        if (authInfoBuilder != null) {
            builder.setAuthInfo(authInfoBuilder.build());
        }
        return builder.build();
    }

    private ClientMaster.MasterCertificateInfo.Builder genMasterCertificateInfo() {
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = null;
        if (this.tubeConfig.isVisitMasterAuth()) {
            authInfoBuilder = ClientMaster.MasterCertificateInfo.newBuilder();
            authInfoBuilder.setAuthInfo(this.clientAuthHandler.genMasterAuthenticateToken(this.tubeConfig.getVisitName(), this.tubeConfig.getVisitPassword()));
        }
        return authInfoBuilder;
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            if (TubeBroker.this.shutdownHooked.compareAndSet(false, true)) {
                TubeBroker.this.stop("Shutdown by Hook");
            }
        }
    }
}

