/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.producer;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.producer.PartitionRouter;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.cluster.Partition;

public class RoundRobinPartitionRouter
implements PartitionRouter {
    private final AtomicInteger steppedCounter = new AtomicInteger(0);
    private final ConcurrentHashMap<String, AtomicInteger> partitionRouterMap = new ConcurrentHashMap();

    @Override
    public Partition getPartition(Message message, List<Partition> partitions) throws TubeClientException {
        if (partitions == null || partitions.isEmpty()) {
            throw new TubeClientException(new StringBuilder(512).append("No available partition for topic: ").append(message.getTopic()).toString());
        }
        AtomicInteger currRouterCount = this.partitionRouterMap.get(message.getTopic());
        if (null == currRouterCount) {
            AtomicInteger newCounter = new AtomicInteger(ThreadLocalRandom.current().nextInt());
            currRouterCount = this.partitionRouterMap.putIfAbsent(message.getTopic(), newCounter);
            if (null == currRouterCount) {
                currRouterCount = newCounter;
            }
        }
        Partition roundPartition = null;
        int partSize = partitions.size();
        for (int i = 0; i < partSize; ++i) {
            roundPartition = partitions.get((currRouterCount.incrementAndGet() & Integer.MAX_VALUE) % partSize);
            if (roundPartition == null || roundPartition.getDelayTimeStamp() >= System.currentTimeMillis()) continue;
            return roundPartition;
        }
        return partitions.get((this.steppedCounter.incrementAndGet() & Integer.MAX_VALUE) % partSize);
    }
}

