/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.util;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.orc.util.Murmur3;

public class BloomFilter {
    public static final double DEFAULT_FPP = 0.05;
    private final BitSet bitSet;
    private final int numBits;
    private final int numHashFunctions;

    static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public BloomFilter(long expectedEntries) {
        this(expectedEntries, 0.05);
    }

    public BloomFilter(long expectedEntries, double fpp) {
        BloomFilter.checkArgument(expectedEntries > 0L, "expectedEntries should be > 0");
        BloomFilter.checkArgument(fpp > 0.0 && fpp < 1.0, "False positive probability should be > 0.0 & < 1.0");
        int nb = BloomFilter.optimalNumOfBits(expectedEntries, fpp);
        this.numBits = nb + (64 - nb % 64);
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedEntries, this.numBits);
        this.bitSet = new BitSet(this.numBits);
    }

    public BloomFilter(long[] bits, int numFuncs) {
        this.bitSet = new BitSet(bits);
        this.numBits = (int)this.bitSet.bitSize();
        this.numHashFunctions = numFuncs;
    }

    static int optimalNumOfHashFunctions(long n, long m3) {
        return Math.max(1, (int)Math.round((double)m3 / (double)n * Math.log(2.0)));
    }

    static int optimalNumOfBits(long n, double p) {
        return (int)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && this.numBits == ((BloomFilter)other).numBits && this.numHashFunctions == ((BloomFilter)other).numHashFunctions && this.bitSet.equals(((BloomFilter)other).bitSet);
    }

    public int hashCode() {
        return this.bitSet.hashCode() + this.numHashFunctions * 5;
    }

    public void add(byte[] val2) {
        this.addBytes(val2, 0, val2 == null ? 0 : val2.length);
    }

    public void addBytes(byte[] val2, int offset, int length) {
        long hash64 = val2 == null ? 2862933555777941757L : Murmur3.hash64(val2, offset, length);
        this.addHash(hash64);
    }

    private void addHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.numBits;
            this.bitSet.set(pos);
        }
    }

    public void addString(String val2) {
        if (val2 == null) {
            this.add(null);
        } else {
            this.add(val2.getBytes(Charset.defaultCharset()));
        }
    }

    public void addLong(long val2) {
        this.addHash(this.getLongHash(val2));
    }

    public void addDouble(double val2) {
        this.addLong(Double.doubleToLongBits(val2));
    }

    public boolean test(byte[] val2) {
        return this.testBytes(val2, 0, val2 == null ? 0 : val2.length);
    }

    public boolean testBytes(byte[] val2, int offset, int length) {
        long hash64 = val2 == null ? 2862933555777941757L : Murmur3.hash64(val2, offset, length);
        return this.testHash(hash64);
    }

    private boolean testHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.numBits)) continue;
            return false;
        }
        return true;
    }

    public boolean testString(String val2) {
        if (val2 == null) {
            return this.test(null);
        }
        return this.test(val2.getBytes(Charset.defaultCharset()));
    }

    public boolean testLong(long val2) {
        return this.testHash(this.getLongHash(val2));
    }

    private long getLongHash(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >> 24;
        key = key + (key << 3) + (key << 8);
        key ^= key >> 14;
        key = key + (key << 2) + (key << 4);
        key ^= key >> 28;
        key += key << 31;
        return key;
    }

    public boolean testDouble(double val2) {
        return this.testLong(Double.doubleToLongBits(val2));
    }

    public long sizeInBytes() {
        return this.getBitSize() / 8;
    }

    public int getBitSize() {
        return this.bitSet.getData().length * 64;
    }

    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    public long[] getBitSet() {
        return this.bitSet.getData();
    }

    public String toString() {
        return "m: " + this.numBits + " k: " + this.numHashFunctions;
    }

    public void merge(BloomFilter that) {
        if (this == that || this.numBits != that.numBits || this.numHashFunctions != that.numHashFunctions) {
            throw new IllegalArgumentException("BloomFilters are not compatible for merging. this - " + this.toString() + " that - " + that.toString());
        }
        this.bitSet.putAll(that.bitSet);
    }

    public void reset() {
        this.bitSet.clear();
    }

    public static class BitSet {
        private final long[] data;

        public BitSet(long bits) {
            this(new long[(int)Math.ceil((double)bits / 64.0)]);
        }

        public BitSet(long[] data) {
            assert (data.length > 0) : "data length is zero!";
            this.data = data;
        }

        public void set(int index) {
            int n = index >>> 6;
            this.data[n] = this.data[n] | 1L << index;
        }

        public boolean get(int index) {
            return (this.data[index >>> 6] & 1L << index) != 0L;
        }

        public long bitSize() {
            return (long)this.data.length * 64L;
        }

        public long[] getData() {
            return this.data;
        }

        public void putAll(BitSet array) {
            assert (this.data.length == array.data.length) : "BitArrays must be of equal length (" + this.data.length + "!= " + array.data.length + ")";
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | array.data[i];
            }
        }

        public void clear() {
            Arrays.fill(this.data, 0L);
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && Arrays.equals(this.data, ((BitSet)other).data);
        }

        public int hashCode() {
            int result = 0;
            for (long l : this.data) {
                result = (int)((long)(result * 13) + l);
            }
            return result;
        }
    }
}

