/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.inlong.sort.protocol.ddl.expressions.AlterColumn;
import org.apache.inlong.sort.protocol.ddl.expressions.Column;
import org.apache.inlong.sort.protocol.ddl.operations.AlterOperation;
import org.apache.inlong.sort.protocol.ddl.operations.Operation;
import org.apache.inlong.sort.protocol.enums.SchemaChangePolicy;
import org.apache.inlong.sort.protocol.enums.SchemaChangeType;
import org.apache.inlong.sort.schema.ColumnSchema;
import org.apache.inlong.sort.schema.TableChange;

public class SchemaChangeUtils {
    private static final String DELIMITER = "&";
    private static final String KEY_VALUE_DELIMITER = "=";

    public static Map<SchemaChangeType, SchemaChangePolicy> deserialize(String policies) {
        Preconditions.checkNotNull(policies, "policies is null");
        HashMap<SchemaChangeType, SchemaChangePolicy> policyMap = new HashMap<SchemaChangeType, SchemaChangePolicy>();
        for (String kv : policies.split(DELIMITER)) {
            SchemaChangePolicy policy;
            SchemaChangeType type;
            int index = kv.indexOf(KEY_VALUE_DELIMITER);
            if (index < 1 || index == kv.length() - 1) {
                throw new IllegalArgumentException("The format of policies must be like 'key1=value1&key2=value2...'");
            }
            String typeCode = kv.substring(0, index);
            String policyCode = kv.substring(index + 1);
            try {
                type = SchemaChangeType.getInstance(Integer.parseInt(typeCode));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Unsupported type of schema-change: %s for InLong", typeCode));
            }
            try {
                policy = SchemaChangePolicy.getInstance(Integer.parseInt(policyCode));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Unsupported policy of schema-change: %s for InLong", policyCode));
            }
            policyMap.put(type, policy);
        }
        return policyMap;
    }

    public static String serialize(Map<SchemaChangeType, SchemaChangePolicy> policyMap) {
        Preconditions.checkNotNull(policyMap, "policyMap is null");
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Map.Entry<SchemaChangeType, SchemaChangePolicy> kv : policyMap.entrySet()) {
            joiner.add(kv.getKey().getCode() + KEY_VALUE_DELIMITER + kv.getValue().getCode());
        }
        return joiner.toString();
    }

    public static Set<SchemaChangeType> extractSchemaChangeTypes(Operation operation) {
        HashSet<SchemaChangeType> types = new HashSet<SchemaChangeType>();
        switch (operation.getOperationType()) {
            case ALTER: {
                AlterOperation alterOperation = (AlterOperation)operation;
                Preconditions.checkState(alterOperation.getAlterColumns() != null && !alterOperation.getAlterColumns().isEmpty(), "alter columns is empty");
                for (AlterColumn alterColumn : alterOperation.getAlterColumns()) {
                    SchemaChangeUtils.extractSchemaChangeType(alterColumn, types);
                }
                break;
            }
            case CREATE: {
                types.add(SchemaChangeType.CREATE_TABLE);
                break;
            }
            case TRUNCATE: {
                types.add(SchemaChangeType.TRUNCATE_TABLE);
                break;
            }
            case RENAME: {
                types.add(SchemaChangeType.RENAME_TABLE);
                break;
            }
            case DROP: {
                types.add(SchemaChangeType.DROP_TABLE);
            }
        }
        return types;
    }

    public static SchemaChangeType extractSchemaChangeType(Operation operation) {
        SchemaChangeType type = null;
        switch (operation.getOperationType()) {
            case ALTER: {
                return SchemaChangeType.ALTER;
            }
            case CREATE: {
                type = SchemaChangeType.CREATE_TABLE;
                break;
            }
            case TRUNCATE: {
                type = SchemaChangeType.TRUNCATE_TABLE;
                break;
            }
            case RENAME: {
                type = SchemaChangeType.RENAME_TABLE;
                break;
            }
            case DROP: {
                type = SchemaChangeType.DROP_TABLE;
            }
        }
        return type;
    }

    public static Set<SchemaChangeType> extractSchemaChangeType(AlterColumn alterColumn) {
        return SchemaChangeUtils.extractSchemaChangeType(alterColumn, new HashSet<SchemaChangeType>());
    }

    public static Set<SchemaChangeType> extractSchemaChangeType(AlterColumn alterColumn, Set<SchemaChangeType> types) {
        if (types == null) {
            types = new HashSet<SchemaChangeType>();
        }
        switch (alterColumn.getAlterType()) {
            case ADD_COLUMN: {
                types.add(SchemaChangeType.ADD_COLUMN);
                break;
            }
            case DROP_COLUMN: {
                types.add(SchemaChangeType.DROP_COLUMN);
                break;
            }
            case RENAME_COLUMN: {
                types.add(SchemaChangeType.RENAME_COLUMN);
                break;
            }
            case CHANGE_COLUMN: {
                SchemaChangeUtils.parseTypeOfChangeColumn(alterColumn, types);
                break;
            }
        }
        return types;
    }

    private static void parseTypeOfChangeColumn(AlterColumn alterColumn, Set<SchemaChangeType> types) {
        Preconditions.checkNotNull(alterColumn.getNewColumn(), "The new column is null");
        Column newColumn = alterColumn.getNewColumn();
        Column oldColumn = alterColumn.getOldColumn();
        Preconditions.checkState(SchemaChangeUtils.isNotEmpty(newColumn), "The new column name is blank");
        if (SchemaChangeUtils.isNotEmpty(oldColumn) && !oldColumn.getName().equals(newColumn.getName())) {
            types.add(SchemaChangeType.RENAME_COLUMN);
        } else {
            types.add(SchemaChangeType.CHANGE_COLUMN_TYPE);
        }
    }

    public static boolean isNotEmpty(Column column) {
        if (column == null || column.getName() == null) {
            return false;
        }
        return !column.getName().trim().isEmpty();
    }

    public static List<TableChange> diffSchema(Map<String, ColumnSchema> oldColumnSchemas, Map<String, ColumnSchema> newColumnSchemas) {
        List oldFields = oldColumnSchemas.values().stream().map(ColumnSchema::getName).collect(Collectors.toList());
        List newFields = newColumnSchemas.values().stream().map(ColumnSchema::getName).collect(Collectors.toList());
        HashSet oldFieldSet = new HashSet(oldFields);
        HashSet newFieldSet = new HashSet(newFields);
        Sets.SetView<String> intersectColSet = Sets.intersection(oldFieldSet, newFieldSet);
        Sets.SetView colsToDelete = Sets.difference(oldFieldSet, newFieldSet);
        Sets.SetView colsToAdd = Sets.difference(newFieldSet, oldFieldSet);
        ArrayList<TableChange> tableChanges = new ArrayList<TableChange>();
        if (!colsToDelete.isEmpty() && !colsToAdd.isEmpty()) {
            tableChanges.add(new TableChange.UnknownColumnChange(String.format(" Old ColumnSchema: [%s] and new ColumnSchema: [%s], it is unknown column change", oldColumnSchemas, newColumnSchemas)));
            return tableChanges;
        }
        if (colsToDelete.isEmpty() && colsToAdd.isEmpty() && oldFieldSet.equals(newFieldSet) && !oldFields.equals(newFields)) {
            tableChanges.add(new TableChange.UnknownColumnChange(String.format(" Old ColumnSchema: [%s] and new ColumnSchema: [%s],  they are same but some filed positions are not same. This situation only is regarded as unknown column change at present", oldColumnSchemas, newColumnSchemas)));
            return tableChanges;
        }
        for (String colName : intersectColSet) {
            ColumnSchema oldCol = oldColumnSchemas.get(colName);
            ColumnSchema newCol = newColumnSchemas.get(colName);
            if (oldCol.getType().equals((Object)newCol.getType()) && oldCol.getComment().equals(newCol.getComment())) continue;
            tableChanges.add(new TableChange.UpdateColumn(new String[]{newCol.getName()}, newCol.getType(), newCol.isNullable(), newCol.getComment()));
        }
        for (String colName : oldFields) {
            if (!colsToDelete.contains(colName)) continue;
            tableChanges.add(new TableChange.DeleteColumn(new String[]{colName}));
        }
        if (!colsToAdd.isEmpty()) {
            for (int i = 0; i < newFields.size(); ++i) {
                String colName;
                colName = (String)newFields.get(i);
                if (!colsToAdd.contains(colName)) continue;
                ColumnSchema addCol = newColumnSchemas.get(colName);
                tableChanges.add(new TableChange.AddColumn(new String[]{addCol.getName()}, addCol.getType(), addCol.isNullable(), addCol.getComment(), addCol.getPosition()));
            }
        }
        return tableChanges;
    }
}

