/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.constant.IcebergConstant;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="icebergLoad")
public class IcebergLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -1L;
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="dbName")
    @Nonnull
    private String dbName;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="catalogType")
    private IcebergConstant.CatalogType catalogType;
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="warehouse")
    private String warehouse;

    @JsonCreator
    public IcebergLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="dbName") String dbName, @Nonnull @JsonProperty(value="tableName") String tableName, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="catalogType") IcebergConstant.CatalogType catalogType, @JsonProperty(value="uri") String uri, @JsonProperty(value="warehouse") String warehouse) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.tableName = Preconditions.checkNotNull(tableName, "table name is null");
        this.dbName = Preconditions.checkNotNull(dbName, "db name is null");
        this.primaryKey = primaryKey;
        this.catalogType = catalogType == null ? IcebergConstant.CatalogType.HIVE : catalogType;
        this.uri = uri;
        this.warehouse = warehouse;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "iceberg-inlong");
        options.put("catalog-database", this.dbName);
        options.put("catalog-table", this.tableName);
        options.put("default-database", this.dbName);
        options.put("catalog-type", this.catalogType.name());
        options.put("catalog-name", this.catalogType.name());
        if (null != this.uri) {
            options.put("uri", this.uri);
        }
        if (null != this.warehouse) {
            options.put("warehouse", this.warehouse);
        }
        return options;
    }

    @Override
    public String genTableName() {
        return this.tableName;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getDbName() {
        return this.dbName;
    }

    public IcebergConstant.CatalogType getCatalogType() {
        return this.catalogType;
    }

    public String getUri() {
        return this.uri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setDbName(@Nonnull String dbName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.dbName = dbName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setCatalogType(IcebergConstant.CatalogType catalogType) {
        this.catalogType = catalogType;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    @Override
    public String toString() {
        return "IcebergLoadNode(tableName=" + this.getTableName() + ", dbName=" + this.getDbName() + ", primaryKey=" + this.getPrimaryKey() + ", catalogType=" + (Object)((Object)this.getCatalogType()) + ", uri=" + this.getUri() + ", warehouse=" + this.getWarehouse() + ")";
    }

    public IcebergLoadNode() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergLoadNode)) {
            return false;
        }
        IcebergLoadNode other = (IcebergLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        IcebergConstant.CatalogType this$catalogType = this.getCatalogType();
        IcebergConstant.CatalogType other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !((Object)((Object)this$catalogType)).equals((Object)other$catalogType)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        return !(this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IcebergLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        IcebergConstant.CatalogType $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : ((Object)((Object)$catalogType)).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        return result;
    }
}

