/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.constant.HudiConstant;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="hudiLoad")
public class HudiLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -1L;
    public static final String ENABLE_CODE = "true";
    private static final String HUDI_OPTION_HIVE_SYNC_ENABLED = "hive_sync.enabled";
    private static final String HUDI_OPTION_HIVE_SYNC_DB = "hive_sync.db";
    private static final String HUDI_OPTION_HIVE_SYNC_TABLE = "hive_sync.table";
    private static final String HUDI_OPTION_HIVE_SYNC_FILE_FORMAT = "hive_sync.file_format";
    private static final String HUDI_OPTION_HIVE_SYNC_MODE = "hive_sync.mode";
    private static final String HUDI_OPTION_HIVE_SYNC_MODE_HMS_VALUE = "hms";
    private static final String HUDI_OPTION_HIVE_SYNC_METASTORE_URIS = "hive_sync.metastore.uris";
    private static final String HUDI_OPTION_DEFAULT_PATH = "path";
    private static final String HUDI_OPTION_DATABASE_NAME = "hoodie.database.name";
    private static final String HUDI_OPTION_TABLE_NAME = "hoodie.table.name";
    private static final String HUDI_OPTION_RECORD_KEY_FIELD_NAME = "hoodie.datasource.write.recordkey.field";
    private static final String HUDI_OPTION_PARTITION_PATH_FIELD_NAME = "hoodie.datasource.write.partitionpath.field";
    private static final String DDL_ATTR_PREFIX = "ddl.";
    private static final String EXTEND_ATTR_KEY_NAME = "keyName";
    private static final String EXTEND_ATTR_VALUE_NAME = "keyValue";
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="dbName")
    @Nonnull
    private String dbName;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="catalogType")
    private HudiConstant.CatalogType catalogType;
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="warehouse")
    private String warehouse;
    @JsonProperty(value="extList")
    private List<HashMap<String, String>> extList;
    @JsonProperty(value="partitionKey")
    private String partitionKey;

    @JsonCreator
    public HudiLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="dbName") String dbName, @Nonnull @JsonProperty(value="tableName") String tableName, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="catalogType") HudiConstant.CatalogType catalogType, @JsonProperty(value="uri") String uri, @JsonProperty(value="warehouse") String warehouse, @JsonProperty(value="extList") List<HashMap<String, String>> extList, @JsonProperty(value="partitionKey") String partitionKey) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.tableName = Preconditions.checkNotNull(tableName, "table name is null");
        this.dbName = Preconditions.checkNotNull(dbName, "db name is null");
        this.primaryKey = primaryKey;
        this.catalogType = catalogType == null ? HudiConstant.CatalogType.HIVE : catalogType;
        this.uri = uri;
        this.warehouse = warehouse;
        this.extList = extList;
        this.partitionKey = partitionKey;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put(HUDI_OPTION_HIVE_SYNC_ENABLED, ENABLE_CODE);
        options.put(HUDI_OPTION_HIVE_SYNC_MODE, HUDI_OPTION_HIVE_SYNC_MODE_HMS_VALUE);
        options.put(HUDI_OPTION_HIVE_SYNC_DB, this.dbName);
        options.put(HUDI_OPTION_HIVE_SYNC_TABLE, this.tableName);
        options.put(HUDI_OPTION_HIVE_SYNC_METASTORE_URIS, this.uri);
        if (StringUtils.isNoneBlank(this.partitionKey)) {
            options.put(HUDI_OPTION_PARTITION_PATH_FIELD_NAME, this.partitionKey);
        }
        this.extList.forEach(ext -> {
            String keyName = (String)ext.get(EXTEND_ATTR_KEY_NAME);
            if (StringUtils.isNoneBlank(keyName) && keyName.startsWith(DDL_ATTR_PREFIX)) {
                String ddlKeyName = keyName.substring(DDL_ATTR_PREFIX.length());
                String ddlValue = (String)ext.get(EXTEND_ATTR_VALUE_NAME);
                options.put(ddlKeyName, ddlValue);
            }
        });
        String path = String.format("%s/%s.db/%s", this.warehouse, this.dbName, this.tableName);
        options.put(HUDI_OPTION_DEFAULT_PATH, path);
        options.put(HUDI_OPTION_DATABASE_NAME, this.dbName);
        options.put(HUDI_OPTION_TABLE_NAME, this.tableName);
        options.put(HUDI_OPTION_RECORD_KEY_FIELD_NAME, this.primaryKey);
        options.put("connector", "hudi-inlong");
        return options;
    }

    @Override
    public String genTableName() {
        return this.tableName;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getDbName() {
        return this.dbName;
    }

    public HudiConstant.CatalogType getCatalogType() {
        return this.catalogType;
    }

    public String getUri() {
        return this.uri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public List<HashMap<String, String>> getExtList() {
        return this.extList;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setDbName(@Nonnull String dbName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.dbName = dbName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setCatalogType(HudiConstant.CatalogType catalogType) {
        this.catalogType = catalogType;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setExtList(List<HashMap<String, String>> extList) {
        this.extList = extList;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    @Override
    public String toString() {
        return "HudiLoadNode(tableName=" + this.getTableName() + ", dbName=" + this.getDbName() + ", primaryKey=" + this.getPrimaryKey() + ", catalogType=" + (Object)((Object)this.getCatalogType()) + ", uri=" + this.getUri() + ", warehouse=" + this.getWarehouse() + ", extList=" + this.getExtList() + ", partitionKey=" + this.getPartitionKey() + ")";
    }

    public HudiLoadNode() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiLoadNode)) {
            return false;
        }
        HudiLoadNode other = (HudiLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        HudiConstant.CatalogType this$catalogType = this.getCatalogType();
        HudiConstant.CatalogType other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !((Object)((Object)this$catalogType)).equals((Object)other$catalogType)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        List<HashMap<String, String>> this$extList = this.getExtList();
        List<HashMap<String, String>> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        String this$partitionKey = this.getPartitionKey();
        String other$partitionKey = other.getPartitionKey();
        return !(this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HudiLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        HudiConstant.CatalogType $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : ((Object)((Object)$catalogType)).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        List<HashMap<String, String>> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        String $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        return result;
    }
}

