/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="tubeMQExtract")
public class TubeMQExtractNode
extends ExtractNode
implements Serializable {
    private static final long serialVersionUID = -2544747886429528474L;
    @Nonnull
    @JsonProperty(value="masterRpc")
    private String masterRpc;
    @Nonnull
    @JsonProperty(value="topic")
    private String topic;
    @Nonnull
    @JsonProperty(value="format")
    private String format;
    @Nonnull
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="sessionKey")
    private String sessionKey;
    @JsonProperty(value="tid")
    private TreeSet<String> tid;

    @JsonCreator
    public TubeMQExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField waterMarkField, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="masterRpc") String masterRpc, @Nonnull @JsonProperty(value="topic") String topic, @Nonnull @JsonProperty(value="format") String format, @Nonnull @JsonProperty(value="groupId") String groupId, @JsonProperty(value="sessionKey") String sessionKey, @JsonProperty(value="tid") TreeSet<String> tid) {
        super(id, name, fields, waterMarkField, properties);
        this.masterRpc = Preconditions.checkNotNull(masterRpc, "TubeMQ masterRpc is null");
        this.topic = Preconditions.checkNotNull(topic, "TubeMQ topic is null");
        this.format = Preconditions.checkNotNull(format, "Format is null");
        this.groupId = Preconditions.checkNotNull(groupId, "Group id is null");
        this.sessionKey = sessionKey;
        this.tid = tid;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> map = super.tableOptions();
        map.put("connector", "tubemq");
        map.put("topic", this.topic);
        map.put("master.rpc", this.masterRpc);
        map.put("group.id", this.groupId);
        map.put("format", this.format);
        map.put("session.key", this.sessionKey);
        if (null != this.tid && !this.tid.isEmpty()) {
            map.put("tid", this.tid.toString());
        }
        return map;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeMQExtractNode)) {
            return false;
        }
        TubeMQExtractNode other = (TubeMQExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$masterRpc = this.getMasterRpc();
        String other$masterRpc = other.getMasterRpc();
        if (this$masterRpc == null ? other$masterRpc != null : !this$masterRpc.equals(other$masterRpc)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        TreeSet<String> this$tid = this.getTid();
        TreeSet<String> other$tid = other.getTid();
        return !(this$tid == null ? other$tid != null : !((Object)this$tid).equals(other$tid));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TubeMQExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $masterRpc = this.getMasterRpc();
        result = result * 59 + ($masterRpc == null ? 43 : $masterRpc.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        TreeSet<String> $tid = this.getTid();
        result = result * 59 + ($tid == null ? 43 : ((Object)$tid).hashCode());
        return result;
    }

    @Nonnull
    public String getMasterRpc() {
        return this.masterRpc;
    }

    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Nonnull
    public String getGroupId() {
        return this.groupId;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public TreeSet<String> getTid() {
        return this.tid;
    }

    public void setMasterRpc(@Nonnull String masterRpc) {
        if (masterRpc == null) {
            throw new NullPointerException("masterRpc is marked non-null but is null");
        }
        this.masterRpc = masterRpc;
    }

    public void setTopic(@Nonnull String topic) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        this.topic = topic;
    }

    public void setFormat(@Nonnull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setGroupId(@Nonnull String groupId) {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        this.groupId = groupId;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setTid(TreeSet<String> tid) {
        this.tid = tid;
    }

    @Override
    public String toString() {
        return "TubeMQExtractNode(masterRpc=" + this.getMasterRpc() + ", topic=" + this.getTopic() + ", format=" + this.getFormat() + ", groupId=" + this.getGroupId() + ", sessionKey=" + this.getSessionKey() + ", tid=" + this.getTid() + ")";
    }
}

