/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="pulsarExtract")
public class PulsarExtractNode
extends ExtractNode
implements InlongMetric {
    private static final long serialVersionUID = 1L;
    @Nonnull
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="adminUrl")
    private String adminUrl;
    @Nonnull
    @JsonProperty(value="serviceUrl")
    private String serviceUrl;
    @Nonnull
    @JsonProperty(value="format")
    private Format format;
    @JsonProperty(value="scanStartupMode")
    private String scanStartupMode;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="scanStartupSubName")
    private String scanStartupSubName;
    @JsonProperty(value="scanStartupSubStartOffset")
    private String scanStartupSubStartOffset;

    @JsonCreator
    public PulsarExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="topic") String topic, @JsonProperty(value="adminUrl") String adminUrl, @Nonnull @JsonProperty(value="serviceUrl") String serviceUrl, @Nonnull @JsonProperty(value="format") Format format, @Nonnull @JsonProperty(value="scanStartupMode") String scanStartupMode, @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="scanStartupSubName") String scanStartupSubName, @JsonProperty(value="scanStartupSubStartOffset") String scanStartupSubStartOffset) {
        super(id, name, fields, watermarkField, properties);
        this.topic = Preconditions.checkNotNull(topic, "pulsar topic is null.");
        this.serviceUrl = Preconditions.checkNotNull(serviceUrl, "pulsar serviceUrl is null.");
        this.format = Preconditions.checkNotNull(format, "pulsar format is null.");
        this.scanStartupMode = Preconditions.checkNotNull(scanStartupMode, "pulsar scanStartupMode is null.");
        this.adminUrl = adminUrl;
        this.primaryKey = primaryKey;
        this.scanStartupSubName = scanStartupSubName;
        this.scanStartupSubStartOffset = scanStartupSubStartOffset;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        if (StringUtils.isEmpty(this.primaryKey)) {
            options.put("connector", "pulsar-inlong");
            options.putAll(this.format.generateOptions(false));
        } else {
            options.put("connector", "upsert-pulsar-inlong");
            options.putAll(this.format.generateOptions(true));
        }
        if (this.adminUrl != null) {
            options.put("admin-url", this.adminUrl);
        }
        options.put("generic", "true");
        options.put("service-url", this.serviceUrl);
        options.put("topic", this.topic);
        options.put("scan.startup.mode", this.scanStartupMode);
        if (this.scanStartupSubName != null) {
            options.put("scan.startup.sub-name", this.scanStartupSubName);
            options.put("scan.startup.sub-start-offset", this.scanStartupSubStartOffset);
        }
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarExtractNode)) {
            return false;
        }
        PulsarExtractNode other = (PulsarExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        if (this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$scanStartupSubName = this.getScanStartupSubName();
        String other$scanStartupSubName = other.getScanStartupSubName();
        if (this$scanStartupSubName == null ? other$scanStartupSubName != null : !this$scanStartupSubName.equals(other$scanStartupSubName)) {
            return false;
        }
        String this$scanStartupSubStartOffset = this.getScanStartupSubStartOffset();
        String other$scanStartupSubStartOffset = other.getScanStartupSubStartOffset();
        return !(this$scanStartupSubStartOffset == null ? other$scanStartupSubStartOffset != null : !this$scanStartupSubStartOffset.equals(other$scanStartupSubStartOffset));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $scanStartupSubName = this.getScanStartupSubName();
        result = result * 59 + ($scanStartupSubName == null ? 43 : $scanStartupSubName.hashCode());
        String $scanStartupSubStartOffset = this.getScanStartupSubStartOffset();
        result = result * 59 + ($scanStartupSubStartOffset == null ? 43 : $scanStartupSubStartOffset.hashCode());
        return result;
    }

    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    @Nonnull
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public String getScanStartupSubName() {
        return this.scanStartupSubName;
    }

    public String getScanStartupSubStartOffset() {
        return this.scanStartupSubStartOffset;
    }

    public void setTopic(@Nonnull String topic) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        this.topic = topic;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(@Nonnull String serviceUrl) {
        if (serviceUrl == null) {
            throw new NullPointerException("serviceUrl is marked non-null but is null");
        }
        this.serviceUrl = serviceUrl;
    }

    public void setFormat(@Nonnull Format format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setScanStartupSubName(String scanStartupSubName) {
        this.scanStartupSubName = scanStartupSubName;
    }

    public void setScanStartupSubStartOffset(String scanStartupSubStartOffset) {
        this.scanStartupSubStartOffset = scanStartupSubStartOffset;
    }

    @Override
    public String toString() {
        return "PulsarExtractNode(topic=" + this.getTopic() + ", adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", format=" + this.getFormat() + ", scanStartupMode=" + this.getScanStartupMode() + ", primaryKey=" + this.getPrimaryKey() + ", scanStartupSubName=" + this.getScanStartupSubName() + ", scanStartupSubStartOffset=" + this.getScanStartupSubStartOffset() + ")";
    }
}

