/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.parser.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.inlong.sort.function.EncryptFunction;
import org.apache.inlong.sort.function.JsonGetterFunction;
import org.apache.inlong.sort.function.RegexpReplaceFirstFunction;
import org.apache.inlong.sort.function.RegexpReplaceFunction;
import org.apache.inlong.sort.parser.Parser;
import org.apache.inlong.sort.parser.impl.FlinkSqlParser;
import org.apache.inlong.sort.parser.result.FlinkSqlParseResult;
import org.apache.inlong.sort.parser.result.ParseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFlinkSqlParser
implements Parser {
    private static final Logger log = LoggerFactory.getLogger(FlinkSqlParser.class);
    private final TableEnvironment tableEnv;
    private final String statements;

    public NativeFlinkSqlParser(TableEnvironment tableEnv, String statements) {
        this.tableEnv = tableEnv;
        this.statements = statements;
        this.registerUDF();
    }

    public static NativeFlinkSqlParser getInstance(TableEnvironment tableEnv, String statements) {
        return new NativeFlinkSqlParser(tableEnv, statements);
    }

    private void registerUDF() {
        this.tableEnv.createTemporarySystemFunction("REGEXP_REPLACE_FIRST", RegexpReplaceFirstFunction.class);
        this.tableEnv.createTemporarySystemFunction("REGEXP_REPLACE", RegexpReplaceFunction.class);
        this.tableEnv.createTemporarySystemFunction("ENCRYPT", EncryptFunction.class);
        this.tableEnv.createTemporarySystemFunction("JSON_GETTER", JsonGetterFunction.class);
    }

    @Override
    public ParseResult parse() {
        String[] statementSet;
        Preconditions.checkNotNull(this.statements, "sql statement set is null");
        Preconditions.checkNotNull(this.tableEnv, "tableEnv is null");
        ArrayList<String> createTableSqls = new ArrayList<String>();
        ArrayList<String> insertSqls = new ArrayList<String>();
        for (String statement : statementSet = this.statements.split(";(\\r?\\n|\\r)")) {
            if ((statement = statement.trim()).toUpperCase(Locale.ROOT).startsWith("CREATE TABLE") || statement.toUpperCase(Locale.ROOT).startsWith("CREATE VIEW")) {
                createTableSqls.add(statement);
                continue;
            }
            if (statement.toUpperCase(Locale.ROOT).startsWith("INSERT INTO")) {
                insertSqls.add(statement);
                continue;
            }
            if (statement.isEmpty()) continue;
            log.warn("Not support sql statement: " + statement);
        }
        return new FlinkSqlParseResult(this.tableEnv, createTableSqls, insertSqls);
    }
}

