/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.parser.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.inlong.common.util.MaskDataUtils;
import org.apache.inlong.sort.configuration.Constants;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.common.ArrayFormatInfo;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.MapFormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.function.EncryptFunction;
import org.apache.inlong.sort.function.JsonGetterFunction;
import org.apache.inlong.sort.function.RegexpReplaceFirstFunction;
import org.apache.inlong.sort.function.RegexpReplaceFunction;
import org.apache.inlong.sort.parser.Parser;
import org.apache.inlong.sort.parser.result.FlinkSqlParseResult;
import org.apache.inlong.sort.parser.result.ParseResult;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.GroupInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.MetaFieldInfo;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.StreamInfo;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.Node;
import org.apache.inlong.sort.protocol.node.extract.MongoExtractNode;
import org.apache.inlong.sort.protocol.node.load.HbaseLoadNode;
import org.apache.inlong.sort.protocol.node.transform.DistinctNode;
import org.apache.inlong.sort.protocol.node.transform.TransformNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.protocol.transformation.Function;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.relation.IntervalJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.JoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.NodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.TemporalJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.UnionNodeRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkSqlParser
implements Parser {
    private static final Logger log = LoggerFactory.getLogger(FlinkSqlParser.class);
    public static final String SOURCE_MULTIPLE_ENABLE_KEY = "source.multiple.enable";
    private final TableEnvironment tableEnv;
    private final GroupInfo groupInfo;
    private final Set<String> hasParsedSet = new HashSet<String>();
    private final List<String> extractTableSqls = new ArrayList<String>();
    private final List<String> transformTableSqls = new ArrayList<String>();
    private final List<String> loadTableSqls = new ArrayList<String>();
    private final List<String> insertSqls = new ArrayList<String>();

    public FlinkSqlParser(TableEnvironment tableEnv, GroupInfo groupInfo) {
        this.tableEnv = tableEnv;
        this.groupInfo = groupInfo;
        this.registerUDF();
    }

    public static FlinkSqlParser getInstance(TableEnvironment tableEnv, GroupInfo groupInfo) {
        return new FlinkSqlParser(tableEnv, groupInfo);
    }

    private void registerUDF() {
        this.tableEnv.createTemporarySystemFunction("REGEXP_REPLACE_FIRST", RegexpReplaceFirstFunction.class);
        this.tableEnv.createTemporarySystemFunction("REGEXP_REPLACE", RegexpReplaceFunction.class);
        this.tableEnv.createTemporarySystemFunction("ENCRYPT", EncryptFunction.class);
        this.tableEnv.createTemporarySystemFunction("JSON_GETTER", JsonGetterFunction.class);
    }

    @Override
    public ParseResult parse() {
        Preconditions.checkNotNull(this.groupInfo, "group info is null");
        Preconditions.checkNotNull(this.groupInfo.getStreams(), "streams is null");
        Preconditions.checkState(!this.groupInfo.getStreams().isEmpty(), "streams is empty");
        Preconditions.checkNotNull(this.tableEnv, "tableEnv is null");
        log.info("start parse group, groupId:{}", (Object)this.groupInfo.getGroupId());
        for (StreamInfo streamInfo : this.groupInfo.getStreams()) {
            this.parseStream(streamInfo);
        }
        log.info("parse group success, groupId:{}", (Object)this.groupInfo.getGroupId());
        ArrayList<String> createTableSqls = new ArrayList<String>(this.extractTableSqls);
        createTableSqls.addAll(this.transformTableSqls);
        createTableSqls.addAll(this.loadTableSqls);
        return new FlinkSqlParseResult(this.tableEnv, createTableSqls, this.insertSqls);
    }

    private void parseStream(StreamInfo streamInfo) {
        Preconditions.checkNotNull(streamInfo, "stream is null");
        Preconditions.checkNotNull(streamInfo.getStreamId(), "streamId is null");
        Preconditions.checkNotNull(streamInfo.getNodes(), "nodes is null");
        Preconditions.checkState(!streamInfo.getNodes().isEmpty(), "nodes is empty");
        Preconditions.checkNotNull(streamInfo.getRelations(), "relations is null");
        Preconditions.checkState(!streamInfo.getRelations().isEmpty(), "relations is empty");
        log.info("start parse stream, streamId:{}", (Object)streamInfo.getStreamId());
        this.injectInlongMetric(streamInfo);
        HashMap nodeMap = new HashMap(streamInfo.getNodes().size());
        streamInfo.getNodes().forEach(s2 -> {
            Preconditions.checkNotNull(s2.getId(), "node id is null");
            nodeMap.put(s2.getId(), s2);
        });
        HashMap relationMap = new HashMap();
        streamInfo.getRelations().forEach(r -> {
            for (String output : r.getOutputs()) {
                relationMap.put(output, r);
            }
        });
        streamInfo.getRelations().forEach(r -> this.parseNodeRelation((NodeRelation)r, nodeMap, relationMap));
        log.info("parse stream success, streamId:{}", (Object)streamInfo.getStreamId());
    }

    private void injectInlongMetric(StreamInfo streamInfo) {
        streamInfo.getNodes().stream().filter(node -> node instanceof InlongMetric).forEach(node -> {
            Map<String, String> properties = node.getProperties();
            if (properties == null) {
                properties = new LinkedHashMap<String, String>();
                if (node instanceof LoadNode) {
                    ((LoadNode)node).setProperties(properties);
                } else if (node instanceof ExtractNode) {
                    ((ExtractNode)node).setProperties(properties);
                } else {
                    throw new UnsupportedOperationException(String.format("Unsupported inlong group stream node for: %s", node.getClass().getSimpleName()));
                }
            }
            properties.put(Constants.METRICS_LABELS.key(), Stream.of("groupId=" + this.groupInfo.getGroupId(), "streamId=" + streamInfo.getStreamId(), "nodeId=" + node.getId()).collect(Collectors.joining("&")));
            if (StringUtils.isNotEmpty(this.groupInfo.getProperties().get(Constants.METRICS_AUDIT_PROXY_HOSTS.key()))) {
                properties.put(Constants.METRICS_AUDIT_PROXY_HOSTS.key(), this.groupInfo.getProperties().get(Constants.METRICS_AUDIT_PROXY_HOSTS.key()));
            }
        });
    }

    private void parseNodeRelation(NodeRelation relation, Map<String, Node> nodeMap, Map<String, NodeRelation> relationMap) {
        log.info("start parse node relation, relation:{}", (Object)relation);
        Preconditions.checkNotNull(relation, "relation is null");
        Preconditions.checkState(relation.getInputs().size() > 0, "relation must have at least one input node");
        Preconditions.checkState(relation.getOutputs().size() > 0, "relation must have at least one output node");
        relation.getOutputs().forEach(s2 -> {
            Preconditions.checkNotNull(s2, "node id in outputs is null");
            Node outputNode = (Node)nodeMap.get(s2);
            Preconditions.checkNotNull(outputNode, "can not find any node by node id " + s2);
            this.parseInputNodes(relation, nodeMap, relationMap);
            this.parseSingleNode(outputNode, relation, nodeMap);
            if (outputNode instanceof LoadNode) {
                this.insertSqls.add(this.genLoadNodeInsertSql((LoadNode)outputNode, relation, nodeMap));
            }
        });
        log.info("parse node relation success, relation:{}", (Object)relation);
    }

    private void parseInputNodes(NodeRelation relation, Map<String, Node> nodeMap, Map<String, NodeRelation> relationMap) {
        for (String upstreamNodeId : relation.getInputs()) {
            if (this.hasParsedSet.contains(upstreamNodeId)) continue;
            Node upstreamNode = nodeMap.get(upstreamNodeId);
            Preconditions.checkNotNull(upstreamNode, "can not find any node by node id " + upstreamNodeId);
            this.parseSingleNode(upstreamNode, relationMap.get(upstreamNodeId), nodeMap);
        }
    }

    private void registerTableSql(Node node, String sql) {
        if (node instanceof ExtractNode) {
            this.extractTableSqls.add(sql);
        } else if (node instanceof TransformNode) {
            this.transformTableSqls.add(sql);
        } else if (node instanceof LoadNode) {
            this.loadTableSqls.add(sql);
        } else {
            throw new UnsupportedOperationException("Only support [ExtractNode|TransformNode|LoadNode]");
        }
    }

    private void parseSingleNode(Node node, NodeRelation relation, Map<String, Node> nodeMap) {
        if (this.hasParsedSet.contains(node.getId())) {
            log.warn("the node has already been parsed, node id:{}", (Object)node.getId());
            return;
        }
        if (node instanceof ExtractNode) {
            log.info("start parse node, node id:{}", (Object)node.getId());
            String sql = this.genCreateSql(node);
            log.info("node id:{}, create table sql:\n{}", (Object)node.getId(), (Object)MaskDataUtils.maskSensitiveMessage(sql));
            this.registerTableSql(node, sql);
            this.hasParsedSet.add(node.getId());
        } else {
            Preconditions.checkNotNull(relation, "relation is null");
            if (node instanceof LoadNode) {
                String createSql = this.genCreateSql(node);
                log.info("node id:{}, create table sql:\n{}", (Object)node.getId(), (Object)MaskDataUtils.maskSensitiveMessage(createSql));
                this.registerTableSql(node, createSql);
                this.hasParsedSet.add(node.getId());
            } else if (node instanceof TransformNode) {
                TransformNode transformNode = (TransformNode)node;
                Preconditions.checkNotNull(transformNode.getFieldRelations(), "field relations is null");
                Preconditions.checkState(!transformNode.getFieldRelations().isEmpty(), "field relations is empty");
                String createSql = this.genCreateSql(node);
                log.info("node id:{}, create table sql:\n{}", (Object)node.getId(), (Object)MaskDataUtils.maskSensitiveMessage(createSql));
                String selectSql = this.genTransformSelectSql(transformNode, relation, nodeMap);
                log.info("node id:{}, transform sql:\n{}", (Object)node.getId(), (Object)MaskDataUtils.maskSensitiveMessage(selectSql));
                this.registerTableSql(node, createSql + " AS\n" + selectSql);
                this.hasParsedSet.add(node.getId());
            }
        }
        log.info("parse node success, node id:{}", (Object)node.getId());
    }

    private String genTransformSelectSql(TransformNode transformNode, NodeRelation relation, Map<String, Node> nodeMap) {
        String selectSql;
        if (relation instanceof JoinRelation) {
            JoinRelation joinRelation = (JoinRelation)relation;
            selectSql = this.genJoinSelectSql(transformNode, transformNode.getFieldRelations(), joinRelation, transformNode.getFilters(), transformNode.getFilterStrategy(), nodeMap);
        } else if (relation instanceof UnionNodeRelation) {
            Preconditions.checkState(transformNode.getFilters() == null || transformNode.getFilters().isEmpty(), "Filter is not supported when union");
            Preconditions.checkState(transformNode.getClass() == TransformNode.class, String.format("union is not supported for %s", transformNode.getClass().getSimpleName()));
            UnionNodeRelation unionRelation = (UnionNodeRelation)relation;
            selectSql = this.genUnionNodeSelectSql(transformNode, transformNode.getFieldRelations(), unionRelation, nodeMap);
        } else {
            Preconditions.checkState(relation.getInputs().size() == 1, "simple transform only support one input node");
            Preconditions.checkState(relation.getOutputs().size() == 1, "join node only support one output node");
            selectSql = this.genSimpleSelectSql(transformNode, transformNode.getFieldRelations(), relation, transformNode.getFilters(), transformNode.getFilterStrategy(), nodeMap);
        }
        return selectSql;
    }

    private String genUnionNodeSelectSql(Node node, List<FieldRelation> fieldRelations, UnionNodeRelation unionRelation, Map<String, Node> nodeMap) {
        Preconditions.checkState(unionRelation.getInputs().size() > 1, "union must have more than one input nodes");
        Preconditions.checkState(unionRelation.getOutputs().size() == 1, "union node only support one output node");
        HashMap<String, Map<String, FieldRelation>> fieldRelationMap = new HashMap<String, Map<String, FieldRelation>>(unionRelation.getInputs().size());
        fieldRelations.forEach(s2 -> {
            String nodeId = s2.getOutputField().getNodeId();
            if (StringUtils.isBlank(nodeId)) {
                nodeId = unionRelation.getInputs().get(0);
            }
            fieldRelationMap.computeIfAbsent(nodeId, k -> new HashMap()).put(s2.getOutputField().getName(), s2);
        });
        StringBuilder sb = new StringBuilder();
        sb.append(this.genUnionSingleSelectSql(unionRelation.getInputs().get(0), nodeMap.get(unionRelation.getInputs().get(0)).genTableName(), node.getFields(), fieldRelationMap, (Map)fieldRelationMap.get(unionRelation.getInputs().get(0)), node));
        String relationFormat = unionRelation.format();
        for (int i = 1; i < unionRelation.getInputs().size(); ++i) {
            String inputId = unionRelation.getInputs().get(i);
            sb.append("\n").append(relationFormat).append("\n").append(this.genUnionSingleSelectSql(inputId, nodeMap.get(inputId).genTableName(), node.getFields(), fieldRelationMap, (Map)fieldRelationMap.get(unionRelation.getInputs().get(0)), node));
        }
        return sb.toString();
    }

    private String genUnionSingleSelectSql(String inputId, String tableName, List<FieldInfo> fields, Map<String, Map<String, FieldRelation>> fieldRelationMap, Map<String, FieldRelation> defaultFieldRelationMap, Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        Map<String, FieldRelation> fieldRelations = fieldRelationMap.get(inputId);
        if (fieldRelations == null) {
            fieldRelations = defaultFieldRelationMap;
        }
        if (node instanceof HbaseLoadNode) {
            HbaseLoadNode hbaseLoadNode = (HbaseLoadNode)node;
            this.parseHbaseLoadFieldRelation(hbaseLoadNode.getRowKey(), fieldRelations.values(), sb);
        } else {
            this.parseFieldRelations(fields, fieldRelations, sb);
        }
        sb.append(" FROM `").append(tableName).append("` ");
        return sb.toString();
    }

    private String genJoinSelectSql(Node node, List<FieldRelation> fieldRelations, JoinRelation relation, List<FilterFunction> filters, FilterStrategy filterStrategy, Map<String, Node> nodeMap) {
        Preconditions.checkState(relation.getInputs().size() > 1, "join must have more than one input nodes");
        Preconditions.checkState(relation.getOutputs().size() == 1, "join node only support one output node");
        HashMap<String, String> tableNameAliasMap = new HashMap<String, String>(relation.getInputs().size());
        relation.getInputs().forEach(s2 -> {
            Node inputNode = (Node)nodeMap.get(s2);
            Preconditions.checkNotNull(inputNode, String.format("input node is not found by id:%s", s2));
            tableNameAliasMap.put((String)s2, String.format("t%s", s2));
        });
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        HashMap<String, FieldRelation> fieldRelationMap = new HashMap<String, FieldRelation>(fieldRelations.size());
        fieldRelations.forEach(s2 -> {
            this.fillOutTableNameAlias(Collections.singletonList(s2.getInputField()), tableNameAliasMap);
            fieldRelationMap.put(s2.getOutputField().getName(), (FieldRelation)s2);
        });
        if (node instanceof HbaseLoadNode) {
            HbaseLoadNode hbaseLoadNode = (HbaseLoadNode)node;
            this.parseHbaseLoadFieldRelation(hbaseLoadNode.getRowKey(), hbaseLoadNode.getFieldRelations(), sb);
        } else {
            this.parseFieldRelations(node.getFields(), fieldRelationMap, sb);
        }
        if (node instanceof DistinctNode) {
            DistinctNode distinctNode = (DistinctNode)node;
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>(distinctNode.getDistinctFields());
            params.add(distinctNode.getOrderField());
            this.fillOutTableNameAlias(params, tableNameAliasMap);
            this.genDistinctSql(distinctNode, sb);
        }
        sb.append(" FROM `").append(nodeMap.get(relation.getInputs().get(0)).genTableName()).append("` ").append((String)tableNameAliasMap.get(relation.getInputs().get(0)));
        Map<String, List<FilterFunction>> conditionMap = relation.getJoinConditionMap();
        if (relation instanceof TemporalJoinRelation) {
            this.parseTemporalJoin((TemporalJoinRelation)relation, nodeMap, tableNameAliasMap, conditionMap, sb);
        } else if (relation instanceof IntervalJoinRelation) {
            Preconditions.checkState(filters == null || filters.isEmpty(), String.format("filters must be empty for %s", relation.getClass().getSimpleName()));
            this.parseIntervalJoin((IntervalJoinRelation)relation, nodeMap, tableNameAliasMap, sb);
            List conditions = conditionMap.values().stream().findFirst().orElse(null);
            Preconditions.checkState(conditions != null && !conditions.isEmpty(), String.format("Join conditions must no be empty for %s", relation.getClass().getSimpleName()));
            this.fillOutTableNameAlias(new ArrayList<FunctionParam>(conditions), tableNameAliasMap);
            this.parseFilterFields(FilterStrategy.RETAIN, conditions, sb);
        } else {
            this.parseRegularJoin(relation, nodeMap, tableNameAliasMap, conditionMap, sb);
        }
        if (filters != null && !filters.isEmpty()) {
            this.fillOutTableNameAlias(new ArrayList<FunctionParam>(filters), tableNameAliasMap);
            this.parseFilterFields(filterStrategy, filters, sb);
        }
        if (node instanceof DistinctNode) {
            sb = this.genDistinctFilterSql(node.getFields(), sb);
        }
        return sb.toString();
    }

    private void parseIntervalJoin(IntervalJoinRelation relation, Map<String, Node> nodeMap, Map<String, String> tableNameAliasMap, StringBuilder sb) {
        for (int i = 1; i < relation.getInputs().size(); ++i) {
            String inputId = relation.getInputs().get(i);
            sb.append(", ").append(nodeMap.get(inputId).genTableName()).append(" ").append(tableNameAliasMap.get(inputId));
        }
    }

    private void parseRegularJoin(JoinRelation relation, Map<String, Node> nodeMap, Map<String, String> tableNameAliasMap, Map<String, List<FilterFunction>> conditionMap, StringBuilder sb) {
        for (int i = 1; i < relation.getInputs().size(); ++i) {
            String inputId = relation.getInputs().get(i);
            sb.append("\n      ").append(relation.format()).append(" ").append(nodeMap.get(inputId).genTableName()).append(" ").append(tableNameAliasMap.get(inputId)).append("\n    ON ");
            this.parseJoinConditions(inputId, conditionMap, tableNameAliasMap, sb);
        }
    }

    private void parseTemporalJoin(TemporalJoinRelation relation, Map<String, Node> nodeMap, Map<String, String> tableNameAliasMap, Map<String, List<FilterFunction>> conditionMap, StringBuilder sb) {
        if (StringUtils.isBlank(relation.getSystemTime().getNodeId())) {
            relation.getSystemTime().setNodeId(relation.getInputs().get(0));
        }
        relation.getSystemTime().setTableNameAlias(tableNameAliasMap.get(relation.getSystemTime().getNodeId()));
        String systemTimeFormat = String.format("FOR SYSTEM_TIME AS OF %s ", relation.getSystemTime().format());
        for (int i = 1; i < relation.getInputs().size(); ++i) {
            String inputId = relation.getInputs().get(i);
            sb.append("\n      ").append(relation.format()).append(" ").append(nodeMap.get(inputId).genTableName()).append(" ");
            sb.append(systemTimeFormat);
            sb.append(tableNameAliasMap.get(inputId)).append("\n    ON ");
            this.parseJoinConditions(inputId, conditionMap, tableNameAliasMap, sb);
        }
    }

    private void parseJoinConditions(String inputId, Map<String, List<FilterFunction>> conditionMap, Map<String, String> tableNameAliasMap, StringBuilder sb) {
        List<FilterFunction> conditions = conditionMap.get(inputId);
        Preconditions.checkNotNull(conditions, String.format("join condition is null for node id:%s", inputId));
        for (FilterFunction filter : conditions) {
            this.fillOutTableNameAlias(filter.getParams(), tableNameAliasMap);
            sb.append(" ").append(filter.format());
        }
    }

    private void fillOutTableNameAlias(List<FunctionParam> params, Map<String, String> tableNameAliasMap) {
        for (FunctionParam param : params) {
            if (param instanceof Function) {
                this.fillOutTableNameAlias(((Function)param).getParams(), tableNameAliasMap);
                continue;
            }
            if (!(param instanceof FieldInfo)) continue;
            FieldInfo fieldParam = (FieldInfo)param;
            Preconditions.checkNotNull(fieldParam.getNodeId(), "node id of field is null when exists more than two input nodes");
            String tableNameAlias = tableNameAliasMap.get(fieldParam.getNodeId());
            Preconditions.checkNotNull(tableNameAlias, String.format("can not find any node by node id:%s of field:%s", fieldParam.getNodeId(), fieldParam.getName()));
            fieldParam.setTableNameAlias(tableNameAlias);
        }
    }

    private StringBuilder genDistinctFilterSql(List<FieldInfo> fields, StringBuilder sb) {
        String subSql = sb.toString();
        sb = new StringBuilder("SELECT ");
        for (FieldInfo field : fields) {
            sb.append("\n    `").append(field.getName()).append("`,");
        }
        sb.deleteCharAt(sb.length() - 1).append("\n    FROM (").append(subSql).append(")\nWHERE row_num = 1");
        return sb;
    }

    private void genDistinctSql(DistinctNode distinctNode, StringBuilder sb) {
        Preconditions.checkNotNull(distinctNode.getDistinctFields(), "distinctField is null");
        Preconditions.checkState(!distinctNode.getDistinctFields().isEmpty(), "distinctField is empty");
        Preconditions.checkNotNull(distinctNode.getOrderField(), "orderField is null");
        sb.append(",\n    ROW_NUMBER() OVER (PARTITION BY ");
        for (FieldInfo distinctField : distinctNode.getDistinctFields()) {
            sb.append(distinctField.format()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ORDER BY ").append(distinctNode.getOrderField().format()).append(" ").append(distinctNode.getOrderDirection().name()).append(") AS row_num");
    }

    private String genSimpleSelectSql(Node node, List<FieldRelation> fieldRelations, NodeRelation relation, List<FilterFunction> filters, FilterStrategy filterStrategy, Map<String, Node> nodeMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        HashMap<String, FieldRelation> fieldRelationMap = new HashMap<String, FieldRelation>(fieldRelations.size());
        fieldRelations.forEach(s2 -> fieldRelationMap.put(s2.getOutputField().getName(), (FieldRelation)s2));
        if (node instanceof HbaseLoadNode) {
            HbaseLoadNode hbaseLoadNode = (HbaseLoadNode)node;
            this.parseHbaseLoadFieldRelation(hbaseLoadNode.getRowKey(), hbaseLoadNode.getFieldRelations(), sb);
        } else {
            this.parseFieldRelations(node.getFields(), fieldRelationMap, sb);
        }
        if (node instanceof DistinctNode) {
            this.genDistinctSql((DistinctNode)node, sb);
        }
        sb.append("\n    FROM `").append(nodeMap.get(relation.getInputs().get(0)).genTableName()).append("` ");
        this.parseFilterFields(filterStrategy, filters, sb);
        if (node instanceof DistinctNode) {
            sb = this.genDistinctFilterSql(node.getFields(), sb);
        }
        return sb.toString();
    }

    private void parseFilterFields(FilterStrategy filterStrategy, List<FilterFunction> filters, StringBuilder sb) {
        if (filters != null && !filters.isEmpty()) {
            sb.append("\nWHERE ");
            String subSql = StringUtils.join((Iterable)filters.stream().map(FunctionParam::format).collect(Collectors.toList()), "\n    ");
            if (filterStrategy == FilterStrategy.REMOVE) {
                sb.append("not (").append(subSql).append(")");
            } else {
                sb.append(subSql);
            }
        }
    }

    private void parseFieldRelations(List<FieldInfo> fields, Map<String, FieldRelation> fieldRelationMap, StringBuilder sb) {
        for (FieldInfo field : fields) {
            FieldRelation fieldRelation = fieldRelationMap.get(field.getName());
            FormatInfo fieldFormatInfo = field.getFormatInfo();
            if (fieldRelation == null) {
                String targetType = TableFormatUtils.deriveLogicalType(fieldFormatInfo).asSummaryString();
                sb.append("\n    CAST(NULL as ").append(targetType).append(") AS ").append(field.format()).append(",");
                continue;
            }
            boolean complexType = fieldFormatInfo instanceof RowFormatInfo || fieldFormatInfo instanceof ArrayFormatInfo || fieldFormatInfo instanceof MapFormatInfo;
            FunctionParam inputField = fieldRelation.getInputField();
            if (inputField instanceof FieldInfo) {
                boolean sameType;
                FieldInfo fieldInfo = (FieldInfo)inputField;
                FormatInfo formatInfo = fieldInfo.getFormatInfo();
                FieldInfo outputField = fieldRelation.getOutputField();
                boolean bl = sameType = formatInfo != null && outputField != null && outputField.getFormatInfo() != null && outputField.getFormatInfo().getTypeInfo().equals(formatInfo.getTypeInfo());
                if (complexType || sameType || fieldFormatInfo == null) {
                    sb.append("\n    ").append(inputField.format()).append(" AS ").append(field.format()).append(",");
                    continue;
                }
                String targetType = TableFormatUtils.deriveLogicalType(fieldFormatInfo).asSummaryString();
                sb.append("\n    CAST(").append(inputField.format()).append(" as ").append(targetType).append(") AS ").append(field.format()).append(",");
                continue;
            }
            String targetType = TableFormatUtils.deriveLogicalType(field.getFormatInfo()).asSummaryString();
            sb.append("\n    CAST(").append(inputField.format()).append(" as ").append(targetType).append(") AS ").append(field.format()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    private String genLoadNodeInsertSql(LoadNode loadNode, NodeRelation relation, Map<String, Node> nodeMap) {
        Preconditions.checkNotNull(loadNode.getFieldRelations(), "field relations is null");
        Preconditions.checkState(!loadNode.getFieldRelations().isEmpty(), "field relations is empty");
        String selectSql = this.genLoadSelectSql(loadNode, relation, nodeMap);
        return "INSERT INTO `" + loadNode.genTableName() + "`\n    " + selectSql;
    }

    private String genLoadSelectSql(LoadNode loadNode, NodeRelation relation, Map<String, Node> nodeMap) {
        String selectSql;
        if (relation instanceof JoinRelation) {
            JoinRelation joinRelation = (JoinRelation)relation;
            selectSql = this.genJoinSelectSql(loadNode, loadNode.getFieldRelations(), joinRelation, loadNode.getFilters(), loadNode.getFilterStrategy(), nodeMap);
        } else if (relation instanceof UnionNodeRelation) {
            Preconditions.checkState(loadNode.getFilters() == null || loadNode.getFilters().isEmpty(), "Filter is not supported when union");
            UnionNodeRelation unionRelation = (UnionNodeRelation)relation;
            selectSql = this.genUnionNodeSelectSql(loadNode, loadNode.getFieldRelations(), unionRelation, nodeMap);
        } else {
            Preconditions.checkState(relation.getInputs().size() == 1, "simple transform only support one input node");
            Preconditions.checkState(relation.getOutputs().size() == 1, "join node only support one output node");
            selectSql = this.genSimpleSelectSql(loadNode, loadNode.getFieldRelations(), relation, loadNode.getFilters(), loadNode.getFilterStrategy(), nodeMap);
        }
        return selectSql;
    }

    private void parseHbaseLoadFieldRelation(String rowkey, Collection<FieldRelation> fieldRelations, StringBuilder sb) {
        sb.append("CAST(").append(rowkey).append(" AS STRING) AS rowkey,\n");
        Map<String, List<FieldRelation>> columnFamilyMapFields = this.genColumnFamilyMapFieldRelations(fieldRelations);
        for (Map.Entry<String, List<FieldRelation>> entry : columnFamilyMapFields.entrySet()) {
            StringBuilder fieldAppend = new StringBuilder(" ROW(");
            for (FieldRelation fieldRelation : entry.getValue()) {
                FieldInfo outputField = fieldRelation.getOutputField();
                String targetType = TableFormatUtils.deriveLogicalType(outputField.getFormatInfo()).asSummaryString();
                fieldAppend.append("CAST(").append(fieldRelation.getInputField().format()).append(" AS ").append(targetType).append(")").append(", ");
            }
            if (fieldAppend.length() > 0) {
                fieldAppend.delete(fieldAppend.lastIndexOf(","), fieldAppend.length());
            }
            fieldAppend.append("),");
            sb.append((CharSequence)fieldAppend);
        }
        sb.delete(sb.lastIndexOf(","), sb.length());
    }

    private String genCreateSql(Node node) {
        ExtractNode extractNode;
        if (node instanceof TransformNode) {
            return this.genCreateTransformSql(node);
        }
        if (node instanceof HbaseLoadNode) {
            return this.genCreateHbaseLoadSql((HbaseLoadNode)node);
        }
        StringBuilder sb = new StringBuilder("CREATE TABLE `");
        sb.append(node.genTableName()).append("`(\n");
        String filterPrimaryKey = this.getFilterPrimaryKey(node);
        sb.append(this.genPrimaryKey(node.getPrimaryKey(), filterPrimaryKey));
        sb.append(this.parseFields(node.getFields(), node, filterPrimaryKey));
        if (node instanceof ExtractNode && (extractNode = (ExtractNode)node).getWatermarkField() != null) {
            sb.append(",\n     ").append(extractNode.getWatermarkField().format());
        }
        sb.append(")");
        if (node.getPartitionFields() != null && !node.getPartitionFields().isEmpty()) {
            sb.append(String.format("\nPARTITIONED BY (%s)", StringUtils.join(this.formatFields(node.getPartitionFields()), ",")));
        }
        sb.append(this.parseOptions(node.tableOptions()));
        return sb.toString();
    }

    private String getFilterPrimaryKey(Node node) {
        if (node instanceof MongoExtractNode && null != node.getProperties().get(SOURCE_MULTIPLE_ENABLE_KEY) && node.getProperties().get(SOURCE_MULTIPLE_ENABLE_KEY).equals("true")) {
            return node.getPrimaryKey();
        }
        return null;
    }

    private String genCreateHbaseLoadSql(HbaseLoadNode node) {
        StringBuilder sb = new StringBuilder("CREATE TABLE `");
        sb.append(node.genTableName()).append("`(\n");
        sb.append("rowkey STRING,\n");
        Map<String, List<FieldRelation>> columnFamilyMapFields = this.genColumnFamilyMapFieldRelations(node.getFieldRelations());
        for (Map.Entry<String, List<FieldRelation>> entry : columnFamilyMapFields.entrySet()) {
            sb.append(entry.getKey());
            StringBuilder fieldsAppend = new StringBuilder(" Row<");
            for (FieldRelation fieldRelation : entry.getValue()) {
                fieldsAppend.append(fieldRelation.getOutputField().getName().split(":")[1]).append(" ").append(TableFormatUtils.deriveLogicalType(fieldRelation.getOutputField().getFormatInfo()).asSummaryString()).append(",");
            }
            if (fieldsAppend.length() > 0) {
                fieldsAppend.delete(fieldsAppend.lastIndexOf(","), fieldsAppend.length());
                fieldsAppend.append(">,\n");
            }
            sb.append((CharSequence)fieldsAppend);
        }
        sb.append("PRIMARY KEY (rowkey) NOT ENFORCED\n) ");
        sb.append(this.parseOptions(node.tableOptions()));
        return sb.toString();
    }

    private Map<String, List<FieldRelation>> genColumnFamilyMapFieldRelations(Collection<FieldRelation> fieldRelations) {
        LinkedHashMap<String, List<FieldRelation>> columnFamilyMapFields = new LinkedHashMap<String, List<FieldRelation>>(16);
        HashSet<String> nameSet = new HashSet<String>();
        for (FieldRelation fieldRelation : fieldRelations) {
            String columnFamily = fieldRelation.getOutputField().getName().split(":")[0];
            if (!nameSet.add(fieldRelation.getOutputField().getName())) continue;
            columnFamilyMapFields.computeIfAbsent(columnFamily, v -> new ArrayList()).add(fieldRelation);
        }
        return columnFamilyMapFields;
    }

    private String genCreateTransformSql(Node node) {
        return String.format("CREATE VIEW `%s` (%s)", node.genTableName(), this.parseTransformNodeFields(node.getFields()));
    }

    private String parseOptions(Map<String, String> options) {
        StringBuilder sb = new StringBuilder();
        if (options != null && !options.isEmpty()) {
            sb.append("\n    WITH (");
            for (Map.Entry<String, String> kv : options.entrySet()) {
                sb.append("\n    '").append(kv.getKey()).append("' = '").append(kv.getValue()).append("'").append(",");
            }
            if (sb.length() > 0) {
                sb.delete(sb.lastIndexOf(","), sb.length());
            }
            sb.append("\n)");
        }
        return sb.toString();
    }

    private String parseTransformNodeFields(List<FieldInfo> fields) {
        StringBuilder sb = new StringBuilder();
        for (FieldInfo field : fields) {
            sb.append("\n    `").append(field.getName()).append("`,");
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(","), sb.length());
        }
        return sb.toString();
    }

    private String parseFields(List<FieldInfo> fields, Node node, String filterPrimaryKey) {
        StringBuilder sb = new StringBuilder();
        for (FieldInfo field : fields) {
            if (StringUtils.isNotBlank(filterPrimaryKey) && field.getName().equals(filterPrimaryKey)) continue;
            sb.append("    `").append(field.getName()).append("` ");
            if (field instanceof MetaFieldInfo) {
                if (!(node instanceof Metadata)) {
                    throw new IllegalArgumentException(String.format("Node: %s is not instance of Metadata", node.getClass().getSimpleName()));
                }
                MetaFieldInfo metaFieldInfo = (MetaFieldInfo)field;
                Metadata metadataNode = (Metadata)((Object)node);
                if (!metadataNode.supportedMetaFields().contains((Object)metaFieldInfo.getMetaField())) {
                    throw new UnsupportedOperationException(String.format("Unsupported meta field for %s: %s", new Object[]{metadataNode.getClass().getSimpleName(), metaFieldInfo.getMetaField()}));
                }
                sb.append(metadataNode.format(metaFieldInfo.getMetaField()));
            } else {
                sb.append(TableFormatUtils.deriveLogicalType(field.getFormatInfo()).asSummaryString());
            }
            sb.append(",\n");
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(","), sb.length());
        }
        return sb.toString();
    }

    private String genPrimaryKey(String primaryKey, String filterPrimaryKey) {
        boolean checkPrimaryKeyFlag = StringUtils.isNotBlank(primaryKey) && (StringUtils.isBlank(filterPrimaryKey) || !primaryKey.equals(filterPrimaryKey));
        primaryKey = checkPrimaryKeyFlag ? String.format("    PRIMARY KEY (%s) NOT ENFORCED,\n", StringUtils.join(this.formatFields(primaryKey.split(",")), ",")) : "";
        return primaryKey;
    }

    private List<String> formatFields(String ... fields) {
        ArrayList<String> formatFields = new ArrayList<String>(fields.length);
        for (String field : fields) {
            if (!field.contains("`")) {
                formatFields.add(String.format("`%s`", field.trim()));
                continue;
            }
            formatFields.add(field);
        }
        return formatFields;
    }

    private List<String> formatFields(List<FieldInfo> fields) {
        ArrayList<String> formatFields = new ArrayList<String>(fields.size());
        for (FieldInfo field : fields) {
            formatFields.add(field.format());
        }
        return formatFields;
    }
}

