/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.kv;

import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.util.StringUtils;

public final class KvSerializationSchema
implements SerializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character entryDelimiter;
    @Nonnull
    private final Character kvDelimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;

    public KvSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral) {
        this.rowFormatInfo = rowFormatInfo;
        this.charset = charset;
        this.entryDelimiter = entryDelimiter;
        this.kvDelimiter = kvDelimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    public KvSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "UTF-8", Character.valueOf('&'), Character.valueOf('='), null, null, null);
    }

    public byte[] serialize(Row row) {
        if (row == null) {
            return null;
        }
        String[] fieldNames = this.rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
        if (row.getArity() != fieldFormatInfos.length) {
            throw new RuntimeException("The number of fields mismatches: " + fieldFormatInfos.length + " expected, but was " + row.getArity() + ".");
        }
        String[] fieldTexts = new String[row.getArity()];
        for (int i = 0; i < row.getArity(); ++i) {
            String fieldText;
            Object field = row.getField(i);
            fieldTexts[i] = fieldText = TableFormatUtils.serializeBasicField(fieldNames[i], fieldFormatInfos[i], field, this.nullLiteral);
        }
        String text = StringUtils.concatKv(fieldNames, fieldTexts, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar);
        return text.getBytes(Charset.forName(this.charset));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvSerializationSchema that = (KvSerializationSchema)o;
        return Objects.equals(this.rowFormatInfo, that.rowFormatInfo) && Objects.equals(this.charset, that.charset) && Objects.equals(this.entryDelimiter, that.entryDelimiter) && Objects.equals(this.kvDelimiter, that.kvDelimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.charset, this.entryDelimiter, this.kvDelimiter, this.escapeChar, this.quoteChar, this.nullLiteral);
    }

    public static class Builder {
        private final RowFormatInfo rowFormatInfo;
        private String charset = "UTF-8";
        private char entryDelimiter = (char)38;
        private char kvDelimiter = (char)61;
        private Character escapeChar = null;
        private Character quoteChar = null;
        private String nullLiteral = null;

        public Builder(RowFormatInfo rowFormatInfo) {
            this.rowFormatInfo = rowFormatInfo;
        }

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setEntryDelimiter(char delimiter) {
            this.entryDelimiter = delimiter;
            return this;
        }

        public Builder setKvDelimiter(char delimiter) {
            this.kvDelimiter = delimiter;
            return this;
        }

        public Builder setEscapeCharacter(char escapeChar) {
            this.escapeChar = Character.valueOf(escapeChar);
            return this;
        }

        public Builder setQuoteCharacter(char quoteChar) {
            this.quoteChar = Character.valueOf(quoteChar);
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            this.nullLiteral = nullLiteral;
            return this;
        }

        public KvSerializationSchema build() {
            return new KvSerializationSchema(this.rowFormatInfo, this.charset, Character.valueOf(this.entryDelimiter), Character.valueOf(this.kvDelimiter), this.escapeChar, this.quoteChar, this.nullLiteral);
        }
    }
}

