/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.canal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.formats.json.canal.CanalJsonEnhancedSerializationSchema;

public class CanalJsonEnhancedEncodingFormat
implements EncodingFormat<SerializationSchema<RowData>> {
    private final TimestampFormat timestampFormat;
    private final JsonOptions.MapNullKeyMode mapNullKeyMode;
    private final String mapNullKeyLiteral;
    private List<String> metadataKeys;
    private boolean encodeDecimalAsPlainNumber;

    public CanalJsonEnhancedEncodingFormat(TimestampFormat timestampFormat, JsonOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber) {
        this.timestampFormat = timestampFormat;
        this.mapNullKeyMode = mapNullKeyMode;
        this.mapNullKeyLiteral = mapNullKeyLiteral;
        this.encodeDecimalAsPlainNumber = encodeDecimalAsPlainNumber;
        this.metadataKeys = Collections.emptyList();
    }

    public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType physicalDataType) {
        List<WriteableMetadata> writeableMetadata = this.metadataKeys.stream().map(k -> Stream.of(WriteableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        return new CanalJsonEnhancedSerializationSchema(physicalDataType, writeableMetadata, this.timestampFormat, this.mapNullKeyMode, this.mapNullKeyLiteral, this.encodeDecimalAsPlainNumber);
    }

    public Map<String, DataType> listWritableMetadata() {
        return Arrays.stream(WriteableMetadata.values()).collect(Collectors.toMap(m3 -> m3.key, m3 -> m3.dataType));
    }

    public void applyWritableMetadata(List<String> metadataKeys) {
        this.metadataKeys = metadataKeys;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    static enum WriteableMetadata {
        DATABASE("database", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD((String)"database", (DataType)DataTypes.STRING()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getString(pos);
            }
        }),
        TABLE("table", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD((String)"table", (DataType)DataTypes.STRING()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getString(pos);
            }
        }),
        SQL_TYPE("sql-type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INT().nullable())).nullable(), DataTypes.FIELD((String)"sqlType", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INT().nullable()))), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getMap(pos);
            }
        }),
        PK_NAMES("pk-names", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()).nullable(), DataTypes.FIELD((String)"pkNames", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getArray(pos);
            }
        }),
        INGESTION_TIMESTAMP("ingestion-timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), DataTypes.FIELD((String)"ts", (DataType)DataTypes.BIGINT()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getTimestamp(pos, 3).getMillisecond();
            }
        }),
        EVENT_TIMESTAMP("event-timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), DataTypes.FIELD((String)"es", (DataType)DataTypes.BIGINT()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getTimestamp(pos, 3).getMillisecond();
            }
        }),
        TYPE("type", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getString(pos);
            }
        }),
        OP_TYPE("op-type", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD((String)"opType", (DataType)DataTypes.STRING()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getString(pos);
            }
        }),
        IS_DDL("is-ddl", (DataType)DataTypes.BOOLEAN().nullable(), DataTypes.FIELD((String)"isDdl", (DataType)DataTypes.BOOLEAN()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getBoolean(pos);
            }
        }),
        MYSQL_TYPE("mysql-type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable(), DataTypes.FIELD((String)"mysqlType", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getMap(pos);
            }
        }),
        BATCH_ID("batch-id", (DataType)DataTypes.BIGINT().nullable(), DataTypes.FIELD((String)"batchId", (DataType)DataTypes.BIGINT()), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getLong(pos);
            }
        }),
        UPDATE_BEFORE("update-before", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable())).nullable(), DataTypes.FIELD((String)"updateBefore", (DataType)DataTypes.ARRAY((DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()))), new CanalJsonEnhancedSerializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(RowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getArray(pos);
            }
        });

        final String key;
        final DataType dataType;
        final DataTypes.Field requiredJsonField;
        final CanalJsonEnhancedSerializationSchema.MetadataConverter converter;

        private WriteableMetadata(String key, DataType dataType, DataTypes.Field requiredJsonField, CanalJsonEnhancedSerializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.requiredJsonField = requiredJsonField;
            this.converter = converter;
        }
    }
}

