/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatDeserializer;
import org.apache.inlong.sort.formats.base.TableFormatDeserializerFactory;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgMixedFormatFactory;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgMixedValidator;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgValidator;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvMixedFormatConverter;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvMixedFormatDeserializer;

public final class InLongMsgCsvFormatFactory
extends TableFormatFactoryBase<Row>
implements TableFormatDeserializerFactory,
InLongMsgMixedFormatFactory {
    public InLongMsgCsvFormatFactory() {
        super("inlongmsgcsv", 1, true);
    }

    public List<String> supportedFormatProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.charset");
        properties.add("format.delimiter");
        properties.add("format.escape-character");
        properties.add("format.quote-character");
        properties.add("format.null-literal");
        properties.add("format.delete-head-delimiter");
        properties.add("format.schema");
        properties.add("format.time-field-name");
        properties.add("format.attributes-field-name");
        properties.add("format.ignore-errors");
        return properties;
    }

    @Override
    public TableFormatDeserializer createFormatDeserializer(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        InLongMsgValidator validator = new InLongMsgValidator();
        validator.validate(descriptorProperties);
        RowFormatInfo rowFormatInfo = InLongMsgUtils.getDataFormatInfo(descriptorProperties);
        String timeFieldName = descriptorProperties.getOptionalString("format.time-field-name").orElse("inlongmsg_time");
        String attributesFieldName = descriptorProperties.getOptionalString("format.attributes-field-name").orElse("inlongmsg_attributes");
        InLongMsgUtils.validateFieldNames(timeFieldName, attributesFieldName, rowFormatInfo);
        String charset = descriptorProperties.getOptionalString("format.charset").orElse("UTF-8");
        Character delimiter = descriptorProperties.getOptionalCharacter("format.delimiter").orElse(Character.valueOf(','));
        Character escapeCharacter = descriptorProperties.getOptionalCharacter("format.escape-character").orElse(null);
        Character quoteCharacter = descriptorProperties.getOptionalCharacter("format.quote-character").orElse(null);
        String nullLiteral = descriptorProperties.getOptionalString("format.null-literal").orElse(null);
        Boolean deleteHeadDelimiter = descriptorProperties.getOptionalBoolean("format.delete-head-delimiter").orElse(true);
        boolean ignoreErrors = descriptorProperties.getOptionalBoolean("format.ignore-errors").orElse(false);
        return new InLongMsgCsvFormatDeserializer(rowFormatInfo, timeFieldName, attributesFieldName, charset, delimiter, escapeCharacter, quoteCharacter, nullLiteral, deleteHeadDelimiter, ignoreErrors);
    }

    @Override
    public InLongMsgCsvMixedFormatDeserializer createMixedFormatDeserializer(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        InLongMsgMixedValidator validator = new InLongMsgMixedValidator();
        validator.validate(descriptorProperties);
        String charset = descriptorProperties.getOptionalString("format.charset").orElse("UTF-8");
        Character delimiter = descriptorProperties.getOptionalCharacter("format.delimiter").orElse(Character.valueOf(','));
        Character escapeCharacter = descriptorProperties.getOptionalCharacter("format.escape-character").orElse(null);
        Character quoteCharacter = descriptorProperties.getOptionalCharacter("format.quote-character").orElse(null);
        Boolean deleteHeadDelimiter = descriptorProperties.getOptionalBoolean("format.delete-head-delimiter").orElse(true);
        boolean ignoreErrors = descriptorProperties.getOptionalBoolean("format.ignore-errors").orElse(false);
        return new InLongMsgCsvMixedFormatDeserializer(charset, delimiter, escapeCharacter, quoteCharacter, deleteHeadDelimiter, ignoreErrors);
    }

    @Override
    public InLongMsgCsvMixedFormatConverter createMixedFormatConverter(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        RowFormatInfo rowFormatInfo = InLongMsgUtils.getDataFormatInfo(descriptorProperties);
        String timeFieldName = descriptorProperties.getOptionalString("format.time-field-name").orElse("inlongmsg_time");
        String attributesFieldName = descriptorProperties.getOptionalString("format.attributes-field-name").orElse("inlongmsg_attributes");
        InLongMsgUtils.validateFieldNames(timeFieldName, attributesFieldName, rowFormatInfo);
        String nullLiteral = descriptorProperties.getOptionalString("format.null-literal").orElse(null);
        boolean ignoreErrors = descriptorProperties.getOptionalBoolean("format.ignore-errors").orElse(false);
        return new InLongMsgCsvMixedFormatConverter(rowFormatInfo, timeFieldName, attributesFieldName, nullLiteral, ignoreErrors);
    }
}

