/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgcsv;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.inlongmsg.AbstractInLongMsgFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgUtils;
import org.apache.inlong.sort.formats.inlongmsgcsv.InLongMsgCsvUtils;

public final class InLongMsgCsvFormatDeserializer
extends AbstractInLongMsgFormatDeserializer {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String timeFieldName;
    @Nonnull
    private final String attributesFieldName;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character delimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;
    private final boolean deleteHeadDelimiter;

    public InLongMsgCsvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String timeFieldName, @Nonnull String attributesFieldName, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, boolean deleteHeadDelimiter, boolean ignoreErrors) {
        super(ignoreErrors);
        this.rowFormatInfo = rowFormatInfo;
        this.timeFieldName = timeFieldName;
        this.attributesFieldName = attributesFieldName;
        this.delimiter = delimiter;
        this.charset = charset;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
        this.deleteHeadDelimiter = deleteHeadDelimiter;
    }

    public InLongMsgCsvFormatDeserializer(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "inlongmsg_time", "inlongmsg_attributes", "UTF-8", Character.valueOf(','), null, null, null, true, false);
    }

    public TypeInformation<Row> getProducedType() {
        return InLongMsgUtils.buildRowType(this.timeFieldName, this.attributesFieldName, this.rowFormatInfo);
    }

    @Override
    protected InLongMsgHead parseHead(String attr) {
        return InLongMsgUtils.parseHead(attr);
    }

    @Override
    protected InLongMsgBody parseBody(byte[] bytes) {
        return InLongMsgCsvUtils.parseBody(bytes, this.charset, this.delimiter.charValue(), this.escapeChar, this.quoteChar, this.deleteHeadDelimiter);
    }

    @Override
    protected Row convertRow(InLongMsgHead head, InLongMsgBody body) {
        return InLongMsgCsvUtils.buildRow(this.rowFormatInfo, this.nullLiteral, head.getTime(), head.getAttributes(), head.getPredefinedFields(), body.getFields());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InLongMsgCsvFormatDeserializer that = (InLongMsgCsvFormatDeserializer)o;
        return this.deleteHeadDelimiter == that.deleteHeadDelimiter && this.rowFormatInfo.equals(that.rowFormatInfo) && this.timeFieldName.equals(that.timeFieldName) && this.attributesFieldName.equals(that.attributesFieldName) && this.charset.equals(that.charset) && this.delimiter.equals(that.delimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rowFormatInfo, this.timeFieldName, this.attributesFieldName, this.charset, this.delimiter, this.escapeChar, this.quoteChar, this.nullLiteral, this.deleteHeadDelimiter);
    }
}

