/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgDecodingFormat;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgOptions;

public final class InLongMsgFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "inlong-msg";
    public static final String INLONG_PREFIX = "inlong-msg.";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        InLongMsgOptions.validateDecodingFormatOptions(formatOptions);
        DeserializationFormatFactory innerFactory = (DeserializationFormatFactory)FactoryUtil.discoverFactory((ClassLoader)context.getClassLoader(), DeserializationFormatFactory.class, (String)((String)formatOptions.get(InLongMsgOptions.INNER_FORMAT)));
        Configuration allOptions = Configuration.fromMap((Map)context.getCatalogTable().getOptions());
        String innerFormatMetaPrefix = (String)formatOptions.get(InLongMsgOptions.INNER_FORMAT) + ".";
        String innerFormatPrefix = INLONG_PREFIX + innerFormatMetaPrefix;
        DecodingFormat innerFormat = innerFactory.createDecodingFormat(context, (ReadableConfig)new DelegatingConfiguration(allOptions, innerFormatPrefix));
        boolean ignoreErrors = (Boolean)formatOptions.get(InLongMsgOptions.IGNORE_PARSE_ERRORS);
        return new InLongMsgDecodingFormat((DecodingFormat<DeserializationSchema<RowData>>)innerFormat, innerFormatMetaPrefix, ignoreErrors);
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        throw new RuntimeException("Do not support inlong format serialize.");
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(InLongMsgOptions.INNER_FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(InLongMsgOptions.IGNORE_PARSE_ERRORS);
        return options;
    }
}

