/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.util.ListCollector;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Collector;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.sort.formats.base.collectors.TimestampedCollector;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongMsgDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InLongMsgDeserializationSchema.class);
    private final DeserializationSchema<RowData> deserializationSchema;
    private final MetadataConverter[] metadataConverters;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean ignoreErrors;

    public InLongMsgDeserializationSchema(DeserializationSchema<RowData> schema, MetadataConverter[] metadataConverters, TypeInformation<RowData> producedTypeInfo, boolean ignoreErrors) {
        this.deserializationSchema = schema;
        this.metadataConverters = metadataConverters;
        this.producedTypeInfo = producedTypeInfo;
        this.ignoreErrors = ignoreErrors;
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    public RowData deserialize(byte[] bytes) {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        InLongMsg inLongMsg = InLongMsg.parseFrom(message);
        for (String attr : inLongMsg.getAttrs()) {
            InLongMsgHead head;
            try {
                head = InLongMsgUtils.parseHead(attr);
            }
            catch (Throwable t) {
                if (this.ignoreErrors) {
                    LOGGER.warn("Ignore inlong msg attr({})parse error.", (Object)attr, (Object)t);
                    continue;
                }
                throw new IOException("Failed to deserialize InLongMsg row '" + new String(message) + "'.", t);
            }
            Iterator<byte[]> iterator = inLongMsg.getIterator(attr);
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                byte[] bodyBytes = iterator.next();
                long bodyLength = bodyBytes == null ? 0L : (long)bodyBytes.length;
                if (bodyLength == 0L) continue;
                if (out instanceof TimestampedCollector) {
                    ((TimestampedCollector)out).resetTimestamp(head.getTime().getTime());
                }
                ArrayList list = new ArrayList();
                ListCollector collector = new ListCollector(list);
                this.deserializationSchema.deserialize(bodyBytes, (Collector)collector);
                list.forEach(rowdata -> this.emitRow(head, (GenericRowData)rowdata, out));
            }
        }
    }

    public boolean isEndOfStream(RowData rowData) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InLongMsgDeserializationSchema)) {
            return false;
        }
        InLongMsgDeserializationSchema that = (InLongMsgDeserializationSchema)o;
        return this.ignoreErrors == that.ignoreErrors && Objects.equal(Arrays.stream(this.metadataConverters).collect(Collectors.toList()), Arrays.stream(that.metadataConverters).collect(Collectors.toList())) && Objects.equal(this.deserializationSchema, that.deserializationSchema) && Objects.equal(this.producedTypeInfo, that.producedTypeInfo);
    }

    public int hashCode() {
        return Objects.hashCode(this.deserializationSchema, this.metadataConverters, this.producedTypeInfo, this.ignoreErrors);
    }

    private void emitRow(InLongMsgHead head, GenericRowData physicalRow, Collector<RowData> out) {
        if (this.metadataConverters.length == 0) {
            out.collect((Object)physicalRow);
            return;
        }
        int metadataArity = this.metadataConverters.length;
        int physicalArity = physicalRow.getArity();
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), physicalArity + metadataArity);
        for (int physicalPos = 0; physicalPos < physicalArity; ++physicalPos) {
            producedRow.setField(physicalPos, physicalRow.getField(physicalPos));
        }
        for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
            producedRow.setField(physicalArity + metadataPos, this.metadataConverters[metadataPos].read(head));
        }
        out.collect((Object)producedRow);
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(InLongMsgHead var1);
    }
}

