/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgDeserializationSchema;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;

public class InLongMsgDecodingFormat
implements DecodingFormat<DeserializationSchema<RowData>> {
    private final String innerFormatMetaPrefix;
    private final DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat;
    private List<String> metadataKeys;
    private final boolean ignoreErrors;

    public InLongMsgDecodingFormat(DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat, String innerFormatMetaPrefix, boolean ignoreErrors) {
        this.innerDecodingFormat = innerDecodingFormat;
        this.innerFormatMetaPrefix = innerFormatMetaPrefix;
        this.metadataKeys = Collections.emptyList();
        this.ignoreErrors = ignoreErrors;
    }

    public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType) {
        InLongMsgDeserializationSchema.MetadataConverter[] metadataConverters = (InLongMsgDeserializationSchema.MetadataConverter[])Arrays.stream(ReadableMetadata.values()).filter(metadata -> this.metadataKeys.contains(metadata.key)).map(metadata -> metadata.converter).toArray(InLongMsgDeserializationSchema.MetadataConverter[]::new);
        List readableMetadata = this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        List metadataFields = readableMetadata.stream().map(m3 -> DataTypes.FIELD((String)m3.key, (DataType)m3.dataType)).collect(Collectors.toList());
        DataType producedDataType = DataTypeUtils.appendRowFields((DataType)physicalDataType, metadataFields);
        TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
        return new InLongMsgDeserializationSchema((DeserializationSchema<RowData>)((DeserializationSchema)this.innerDecodingFormat.createRuntimeDecoder(context, physicalDataType)), metadataConverters, (TypeInformation<RowData>)producedTypeInfo, this.ignoreErrors);
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        this.innerDecodingFormat.listReadableMetadata().forEach((key, value) -> metadataMap.putIfAbsent(this.innerFormatMetaPrefix + key, (DataType)value));
        Stream.of(ReadableMetadata.values()).forEachOrdered(m3 -> metadataMap.putIfAbsent(m3.key, m3.dataType));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> metadataKeys) {
        List innerFormatMetadataKeys = metadataKeys.stream().filter(k -> k.startsWith(this.innerFormatMetaPrefix)).collect(Collectors.toList());
        ArrayList<String> formatMetadataKeys = new ArrayList<String>(metadataKeys);
        formatMetadataKeys.removeAll(innerFormatMetadataKeys);
        this.metadataKeys = formatMetadataKeys;
        Map formatMetadata = this.innerDecodingFormat.listReadableMetadata();
        if (formatMetadata.size() > 0) {
            List requestedFormatMetadataKeys = innerFormatMetadataKeys.stream().map(k -> k.substring(this.innerFormatMetaPrefix.length())).collect(Collectors.toList());
            this.innerDecodingFormat.applyReadableMetadata(requestedFormatMetadataKeys);
        }
    }

    public ChangelogMode getChangelogMode() {
        return this.innerDecodingFormat.getChangelogMode();
    }

    static enum ReadableMetadata {
        CREATE_TIME("create-time", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE().notNull(), new InLongMsgDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(InLongMsgHead head) {
                return TimestampData.fromTimestamp((Timestamp)head.getTime());
            }
        }),
        STREAM_ID("stream-id", (DataType)DataTypes.STRING().notNull(), new InLongMsgDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(InLongMsgHead head) {
                return StringData.fromString((String)head.getTid());
            }
        });

        final String key;
        final DataType dataType;
        final InLongMsgDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, InLongMsgDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

