/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.sort.formats.base.TableFormatDeserializer;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInLongMsgFormatDeserializer
implements TableFormatDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInLongMsgFormatDeserializer.class);
    @Nonnull
    protected final Boolean ignoreErrors;

    public AbstractInLongMsgFormatDeserializer(@Nonnull Boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    protected abstract InLongMsgHead parseHead(String var1) throws Exception;

    protected abstract InLongMsgBody parseBody(byte[] var1) throws Exception;

    protected abstract Row convertRow(InLongMsgHead var1, InLongMsgBody var2) throws Exception;

    public void flatMap(byte[] bytes, Collector<Row> collector) throws Exception {
        InLongMsg inLongMsg = InLongMsg.parseFrom(bytes);
        for (String attr : inLongMsg.getAttrs()) {
            InLongMsgHead head;
            Iterator<byte[]> iterator = inLongMsg.getIterator(attr);
            if (iterator == null) continue;
            try {
                head = this.parseHead(attr);
            }
            catch (Exception e) {
                if (this.ignoreErrors.booleanValue()) {
                    LOG.warn("Cannot properly parse the head {}.", (Object)attr, (Object)e);
                    continue;
                }
                throw e;
            }
            while (iterator.hasNext()) {
                Row row;
                InLongMsgBody body;
                byte[] bodyBytes = iterator.next();
                if (bodyBytes == null || bodyBytes.length == 0) continue;
                try {
                    body = this.parseBody(bodyBytes);
                }
                catch (Exception e) {
                    if (this.ignoreErrors.booleanValue()) {
                        LOG.warn("Cannot properly parse the body {}.", (Object)Arrays.toString(bodyBytes), (Object)e);
                        continue;
                    }
                    throw e;
                }
                try {
                    row = this.convertRow(head, body);
                }
                catch (Exception e) {
                    if (this.ignoreErrors.booleanValue()) {
                        LOG.warn("Cannot properly convert the inlongmsg ({}, {}) to row.", head, body, e);
                        continue;
                    }
                    throw e;
                }
                if (row == null) continue;
                collector.collect((Object)row);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInLongMsgFormatDeserializer that = (AbstractInLongMsgFormatDeserializer)o;
        return this.ignoreErrors.equals(that.ignoreErrors);
    }

    public int hashCode() {
        return Objects.hash(this.ignoreErrors);
    }
}

