/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.csv;

import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.util.StringUtils;

public class CsvSerializationSchema
implements SerializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character delimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;

    public CsvSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral) {
        this.rowFormatInfo = rowFormatInfo;
        this.charset = charset;
        this.delimiter = delimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    public CsvSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "UTF-8", Character.valueOf(','), null, null, null);
    }

    public byte[] serialize(Row row) {
        if (row == null) {
            return null;
        }
        String[] fieldNames = this.rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
        if (row.getArity() != fieldFormatInfos.length) {
            throw new IllegalStateException("The number of fields mismatches: " + fieldFormatInfos.length + " expected, but was " + row.getArity() + ".");
        }
        String[] fieldTexts = new String[row.getArity()];
        for (int i = 0; i < row.getArity(); ++i) {
            String fieldText;
            fieldTexts[i] = fieldText = TableFormatUtils.serializeBasicField(fieldNames[i], fieldFormatInfos[i], row.getField(i), this.nullLiteral);
        }
        String result = StringUtils.concatCsv(fieldTexts, this.delimiter, this.escapeChar, this.quoteChar);
        return result.getBytes(Charset.forName(this.charset));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvSerializationSchema that = (CsvSerializationSchema)o;
        return Objects.equals(this.rowFormatInfo, that.rowFormatInfo) && Objects.equals(this.charset, that.charset) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.charset, this.delimiter, this.escapeChar, this.quoteChar, this.nullLiteral);
    }

    public static class Builder {
        private final RowFormatInfo rowFormatInfo;
        private char delimiter = (char)44;
        private String charset = "UTF-8";
        private Character escapeChar = null;
        private Character quoteChar = null;
        private String nullLiteral = null;

        public Builder(RowFormatInfo rowFormatInfo) {
            this.rowFormatInfo = rowFormatInfo;
        }

        public Builder setDelimiter(char delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setEscapeCharacter(char escapeChar) {
            this.escapeChar = Character.valueOf(escapeChar);
            return this;
        }

        public Builder setQuoteCharacter(char quoteChar) {
            this.quoteChar = Character.valueOf(quoteChar);
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            this.nullLiteral = nullLiteral;
            return this;
        }

        public CsvSerializationSchema build() {
            return new CsvSerializationSchema(this.rowFormatInfo, this.charset, Character.valueOf(this.delimiter), this.escapeChar, this.quoteChar, this.nullLiteral);
        }
    }
}

