/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.DefaultTableFormatDeserializer;
import org.apache.inlong.sort.formats.base.DefaultTableFormatSerializer;
import org.apache.inlong.sort.formats.base.ProjectedDeserializationSchemaFactory;
import org.apache.inlong.sort.formats.base.ProjectedSerializationSchemaFactory;
import org.apache.inlong.sort.formats.base.TableFormatDeserializer;
import org.apache.inlong.sort.formats.base.TableFormatDeserializerFactory;
import org.apache.inlong.sort.formats.base.TableFormatSerializer;
import org.apache.inlong.sort.formats.base.TableFormatSerializerFactory;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.common.BasicFormatInfo;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.csv.CsvDeserializationSchema;
import org.apache.inlong.sort.formats.csv.CsvSerializationSchema;
import org.apache.inlong.sort.formats.csv.CsvValidator;

public final class CsvFormatFactory
extends TableFormatFactoryBase<Row>
implements DeserializationSchemaFactory<Row>,
SerializationSchemaFactory<Row>,
ProjectedDeserializationSchemaFactory,
ProjectedSerializationSchemaFactory,
TableFormatDeserializerFactory,
TableFormatSerializerFactory {
    public CsvFormatFactory() {
        super("tdcsv", 1, true);
    }

    public List<String> supportedFormatProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.schema");
        properties.add("format.charset");
        properties.add("format.delimiter");
        properties.add("format.escape-character");
        properties.add("format.quote-character");
        properties.add("format.null-literal");
        properties.add("format.ignore-errors");
        return properties;
    }

    public CsvDeserializationSchema createDeserializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = TableFormatUtils.getRowFormatInfo(descriptorProperties);
        return CsvFormatFactory.buildDeserializationSchema(descriptorProperties, rowFormatInfo);
    }

    public CsvSerializationSchema createSerializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = TableFormatUtils.getRowFormatInfo(descriptorProperties);
        return CsvFormatFactory.buildSerializationSchema(descriptorProperties, rowFormatInfo);
    }

    @Override
    public DeserializationSchema<Row> createProjectedDeserializationSchema(Map<String, String> properties, int[] fields) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = TableFormatUtils.getRowFormatInfo(descriptorProperties);
        RowFormatInfo projectedRowFormatInfo = TableFormatUtils.projectRowFormatInfo(rowFormatInfo, fields);
        return CsvFormatFactory.buildDeserializationSchema(descriptorProperties, projectedRowFormatInfo);
    }

    @Override
    public SerializationSchema<Row> createProjectedSerializationSchema(Map<String, String> properties, int[] fields) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = TableFormatUtils.getRowFormatInfo(descriptorProperties);
        RowFormatInfo projectedRowFormatInfo = TableFormatUtils.projectRowFormatInfo(rowFormatInfo, fields);
        return CsvFormatFactory.buildSerializationSchema(descriptorProperties, projectedRowFormatInfo);
    }

    @Override
    public TableFormatDeserializer createFormatDeserializer(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = TableFormatUtils.getRowFormatInfo(descriptorProperties);
        CsvDeserializationSchema deserializationSchema = CsvFormatFactory.buildDeserializationSchema(descriptorProperties, rowFormatInfo);
        boolean ignoreErrors = descriptorProperties.getOptionalBoolean("format.ignore-errors").orElse(false);
        return new DefaultTableFormatDeserializer(deserializationSchema, ignoreErrors);
    }

    @Override
    public TableFormatSerializer createFormatSerializer(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = CsvFormatFactory.getValidatedProperties(properties);
        RowFormatInfo rowFormatInfo = TableFormatUtils.getRowFormatInfo(descriptorProperties);
        CsvSerializationSchema serializationSchema = CsvFormatFactory.buildSerializationSchema(descriptorProperties, rowFormatInfo);
        boolean ignoreErrors = descriptorProperties.getOptionalBoolean("format.ignore-errors").orElse(false);
        return new DefaultTableFormatSerializer(serializationSchema, ignoreErrors);
    }

    public static DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        CsvValidator validator = new CsvValidator();
        validator.validate(descriptorProperties);
        return descriptorProperties;
    }

    private static CsvDeserializationSchema buildDeserializationSchema(DescriptorProperties descriptorProperties, RowFormatInfo rowFormatInfo) {
        for (FormatInfo formatInfo : rowFormatInfo.getFieldFormatInfos()) {
            if (formatInfo instanceof BasicFormatInfo) continue;
            throw new ValidationException("Currently only basic formats are supported in csv formats.");
        }
        CsvDeserializationSchema.Builder builder = new CsvDeserializationSchema.Builder(rowFormatInfo);
        descriptorProperties.getOptionalString("format.charset").ifPresent(builder::setCharset);
        descriptorProperties.getOptionalCharacter("format.delimiter").ifPresent(builder::setDelimiter);
        descriptorProperties.getOptionalCharacter("format.escape-character").ifPresent(builder::setEscapeCharacter);
        descriptorProperties.getOptionalCharacter("format.quote-character").ifPresent(builder::setQuoteCharacter);
        descriptorProperties.getOptionalString("format.null-literal").ifPresent(builder::setNullLiteral);
        return builder.build();
    }

    private static CsvSerializationSchema buildSerializationSchema(DescriptorProperties descriptorProperties, RowFormatInfo rowFormatInfo) {
        for (FormatInfo formatInfo : rowFormatInfo.getFieldFormatInfos()) {
            if (formatInfo instanceof BasicFormatInfo) continue;
            throw new ValidationException("Currently only basic formats are supported in csv formats.");
        }
        CsvSerializationSchema.Builder builder = new CsvSerializationSchema.Builder(rowFormatInfo);
        descriptorProperties.getOptionalString("format.charset").ifPresent(builder::setCharset);
        descriptorProperties.getOptionalCharacter("format.delimiter").ifPresent(builder::setDelimiter);
        descriptorProperties.getOptionalCharacter("format.escape-character").ifPresent(builder::setEscapeCharacter);
        descriptorProperties.getOptionalCharacter("format.quote-character").ifPresent(builder::setQuoteCharacter);
        descriptorProperties.getOptionalString("format.null-literal").ifPresent(builder::setNullLiteral);
        return builder.build();
    }
}

