/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.csv;

import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvDeserializationSchema
implements DeserializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CsvDeserializationSchema.class);
    @Nonnull
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character delimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;

    public CsvDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral) {
        this.rowFormatInfo = rowFormatInfo;
        this.charset = charset;
        this.delimiter = delimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    public CsvDeserializationSchema(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "UTF-8", Character.valueOf(','), null, null, null);
    }

    public TypeInformation<Row> getProducedType() {
        return TableFormatUtils.getType(this.rowFormatInfo.getTypeInfo());
    }

    public boolean isEndOfStream(Row t) {
        return false;
    }

    public Row deserialize(byte[] bytes) {
        String text = new String(bytes, Charset.forName(this.charset));
        String[] fieldNames = this.rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
        String[] fieldTexts = StringUtils.splitCsv(text, this.delimiter, this.escapeChar, this.quoteChar);
        if (fieldTexts.length != fieldNames.length) {
            LOG.warn("The number of fields mismatches: " + fieldNames.length + " expected, but was " + fieldTexts.length + ".");
        }
        Row row = new Row(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            if (i >= fieldTexts.length) {
                row.setField(i, null);
                continue;
            }
            Object field = TableFormatUtils.deserializeBasicField(fieldNames[i], fieldFormatInfos[i], fieldTexts[i], this.nullLiteral);
            row.setField(i, field);
        }
        return row;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvDeserializationSchema that = (CsvDeserializationSchema)o;
        return this.rowFormatInfo.equals(that.rowFormatInfo) && Objects.equals(this.charset, that.charset) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.charset, this.delimiter, this.escapeChar, this.quoteChar, this.nullLiteral);
    }

    public static class Builder {
        private final RowFormatInfo rowFormatInfo;
        private char delimiter = (char)44;
        private String charset = "UTF-8";
        private Character escapeChar = null;
        private Character quoteChar = null;
        private String nullLiteral = null;

        public Builder(RowFormatInfo rowFormatInfo) {
            this.rowFormatInfo = rowFormatInfo;
        }

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setDelimiter(char delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder setEscapeCharacter(char escapeChar) {
            this.escapeChar = Character.valueOf(escapeChar);
            return this;
        }

        public Builder setQuoteCharacter(char quoteChar) {
            this.quoteChar = Character.valueOf(quoteChar);
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            this.nullLiteral = nullLiteral;
            return this;
        }

        public CsvDeserializationSchema build() {
            return new CsvDeserializationSchema(this.rowFormatInfo, this.charset, Character.valueOf(this.delimiter), this.escapeChar, this.quoteChar, this.nullLiteral);
        }
    }
}

