/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.common.TimeFormats;
import org.apache.flink.formats.json.JsonRowSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JsonRowDeserializationSchema
implements DeserializationSchema<Row> {
    private static final long serialVersionUID = -228294330688809195L;
    private final RowTypeInfo typeInfo;
    private boolean failOnMissingField;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private DeserializationRuntimeConverter runtimeConverter;
    private final boolean ignoreParseErrors;

    private JsonRowDeserializationSchema(TypeInformation<Row> typeInfo, boolean failOnMissingField, boolean ignoreParseErrors) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information");
        Preconditions.checkArgument((boolean)(typeInfo instanceof RowTypeInfo), (Object)"Only RowTypeInfo is supported");
        if (ignoreParseErrors && failOnMissingField) {
            throw new IllegalArgumentException("JSON format doesn't support failOnMissingField and ignoreParseErrors are both true.");
        }
        this.typeInfo = (RowTypeInfo)typeInfo;
        this.failOnMissingField = failOnMissingField;
        this.runtimeConverter = this.createConverter((TypeInformation<?>)this.typeInfo);
        this.ignoreParseErrors = ignoreParseErrors;
        RowType rowType = (RowType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)this.typeInfo).getLogicalType();
        boolean hasDecimalType = LogicalTypeChecks.hasNested((LogicalType)rowType, t -> t.getTypeRoot().equals((Object)LogicalTypeRoot.DECIMAL));
        if (hasDecimalType) {
            this.objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        }
    }

    @Deprecated
    public JsonRowDeserializationSchema(TypeInformation<Row> typeInfo) {
        this(typeInfo, false, false);
    }

    @Deprecated
    public JsonRowDeserializationSchema(String jsonSchema) {
        this(JsonRowSchemaConverter.convert((String)Preconditions.checkNotNull((Object)jsonSchema)), false, false);
    }

    @Deprecated
    public void setFailOnMissingField(boolean failOnMissingField) {
        this.failOnMissingField = failOnMissingField;
        this.runtimeConverter = this.createConverter((TypeInformation<?>)this.typeInfo);
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            JsonNode root = this.objectMapper.readTree(message);
            return (Row)this.runtimeConverter.convert(this.objectMapper, root);
        }
        catch (Throwable t) {
            if (this.ignoreParseErrors) {
                return null;
            }
            throw new IOException(String.format("Failed to deserialize JSON '%s'.", new String(message)), t);
        }
    }

    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    public TypeInformation<Row> getProducedType() {
        return this.typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRowDeserializationSchema that = (JsonRowDeserializationSchema)o;
        return Objects.equals(this.typeInfo, that.typeInfo) && Objects.equals(this.failOnMissingField, that.failOnMissingField) && Objects.equals(this.ignoreParseErrors, that.ignoreParseErrors);
    }

    public int hashCode() {
        return Objects.hash(this.typeInfo, this.failOnMissingField, this.ignoreParseErrors);
    }

    private DeserializationRuntimeConverter createConverter(TypeInformation<?> typeInfo) {
        DeserializationRuntimeConverter baseConverter = this.createConverterForSimpleType(typeInfo).orElseGet(() -> this.createContainerConverter(typeInfo).orElseGet(() -> this.createFallbackConverter(typeInfo.getTypeClass())));
        return this.wrapIntoNullableConverter(baseConverter);
    }

    private DeserializationRuntimeConverter wrapIntoNullableConverter(DeserializationRuntimeConverter converter) {
        return (mapper, jsonNode) -> {
            if (jsonNode.isNull()) {
                return null;
            }
            try {
                return converter.convert(mapper, jsonNode);
            }
            catch (Throwable t) {
                if (!this.ignoreParseErrors) {
                    throw t;
                }
                return null;
            }
        };
    }

    private Optional<DeserializationRuntimeConverter> createContainerConverter(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof RowTypeInfo) {
            return Optional.of(this.createRowConverter((RowTypeInfo)typeInfo));
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            return Optional.of(this.createObjectArrayConverter(((ObjectArrayTypeInfo)typeInfo).getComponentInfo()));
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            return Optional.of(this.createObjectArrayConverter(((BasicArrayTypeInfo)typeInfo).getComponentInfo()));
        }
        if (this.isPrimitiveByteArray(typeInfo)) {
            return Optional.of(this.createByteArrayConverter());
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            return Optional.of(this.createMapConverter(mapTypeInfo.getKeyTypeInfo(), mapTypeInfo.getValueTypeInfo()));
        }
        return Optional.empty();
    }

    private DeserializationRuntimeConverter createMapConverter(TypeInformation keyType, TypeInformation valueType) {
        DeserializationRuntimeConverter valueConverter = this.createConverter(valueType);
        DeserializationRuntimeConverter keyConverter = this.createConverter(keyType);
        return (mapper, jsonNode) -> {
            Iterator<Map.Entry<String, JsonNode>> fields = jsonNode.fields();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> entry = fields.next();
                Object key = keyConverter.convert(mapper, TextNode.valueOf(entry.getKey()));
                Object value = valueConverter.convert(mapper, entry.getValue());
                result.put(key, value);
            }
            return result;
        };
    }

    private DeserializationRuntimeConverter createByteArrayConverter() {
        return (mapper, jsonNode) -> {
            try {
                return jsonNode.binaryValue();
            }
            catch (IOException e) {
                throw new JsonParseException("Unable to deserialize byte array.", e);
            }
        };
    }

    private boolean isPrimitiveByteArray(TypeInformation<?> typeInfo) {
        return typeInfo instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)typeInfo).getComponentType() == Types.BYTE;
    }

    private DeserializationRuntimeConverter createObjectArrayConverter(TypeInformation elementTypeInfo) {
        DeserializationRuntimeConverter elementConverter = this.createConverter(elementTypeInfo);
        return this.assembleArrayConverter(elementTypeInfo, elementConverter);
    }

    private DeserializationRuntimeConverter createRowConverter(RowTypeInfo typeInfo) {
        List<DeserializationRuntimeConverter> fieldConverters = Arrays.stream(typeInfo.getFieldTypes()).map(this::createConverter).collect(Collectors.toList());
        return this.assembleRowConverter(typeInfo.getFieldNames(), fieldConverters);
    }

    private DeserializationRuntimeConverter createFallbackConverter(Class<?> valueType) {
        return (mapper, jsonNode) -> {
            try {
                return mapper.treeToValue(jsonNode, valueType);
            }
            catch (JsonProcessingException e) {
                throw new JsonParseException(String.format("Could not convert node: %s", jsonNode), e);
            }
        };
    }

    private Optional<DeserializationRuntimeConverter> createConverterForSimpleType(TypeInformation<?> simpleTypeInfo) {
        if (simpleTypeInfo == Types.VOID) {
            return Optional.of((mapper, jsonNode) -> null);
        }
        if (simpleTypeInfo == Types.BOOLEAN) {
            return Optional.of(this::convertToBoolean);
        }
        if (simpleTypeInfo == Types.STRING) {
            return Optional.of(this::convertToString);
        }
        if (simpleTypeInfo == Types.INT) {
            return Optional.of(this::convertToInt);
        }
        if (simpleTypeInfo == Types.LONG) {
            return Optional.of(this::convertToLong);
        }
        if (simpleTypeInfo == Types.DOUBLE) {
            return Optional.of(this::convertToDouble);
        }
        if (simpleTypeInfo == Types.FLOAT) {
            return Optional.of((mapper, jsonNode) -> Float.valueOf(Float.parseFloat(jsonNode.asText().trim())));
        }
        if (simpleTypeInfo == Types.SHORT) {
            return Optional.of((mapper, jsonNode) -> Short.parseShort(jsonNode.asText().trim()));
        }
        if (simpleTypeInfo == Types.BYTE) {
            return Optional.of((mapper, jsonNode) -> Byte.parseByte(jsonNode.asText().trim()));
        }
        if (simpleTypeInfo == Types.BIG_DEC) {
            return Optional.of(this::convertToBigDecimal);
        }
        if (simpleTypeInfo == Types.BIG_INT) {
            return Optional.of(this::convertToBigInteger);
        }
        if (simpleTypeInfo == Types.SQL_DATE) {
            return Optional.of(this::convertToDate);
        }
        if (simpleTypeInfo == Types.SQL_TIME) {
            return Optional.of(this::convertToTime);
        }
        if (simpleTypeInfo == Types.SQL_TIMESTAMP) {
            return Optional.of(this::convertToTimestamp);
        }
        if (simpleTypeInfo == Types.LOCAL_DATE) {
            return Optional.of(this::convertToLocalDate);
        }
        if (simpleTypeInfo == Types.LOCAL_TIME) {
            return Optional.of(this::convertToLocalTime);
        }
        if (simpleTypeInfo == Types.LOCAL_DATE_TIME) {
            return Optional.of(this::convertToLocalDateTime);
        }
        return Optional.empty();
    }

    private String convertToString(ObjectMapper mapper, JsonNode jsonNode) {
        if (jsonNode.isContainerNode()) {
            return jsonNode.toString();
        }
        return jsonNode.asText();
    }

    private boolean convertToBoolean(ObjectMapper mapper, JsonNode jsonNode) {
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        return Boolean.parseBoolean(jsonNode.asText().trim());
    }

    private int convertToInt(ObjectMapper mapper, JsonNode jsonNode) {
        if (jsonNode.canConvertToInt()) {
            return jsonNode.asInt();
        }
        return Integer.parseInt(jsonNode.asText().trim());
    }

    private long convertToLong(ObjectMapper mapper, JsonNode jsonNode) {
        if (jsonNode.canConvertToLong()) {
            return jsonNode.asLong();
        }
        return Long.parseLong(jsonNode.asText().trim());
    }

    private double convertToDouble(ObjectMapper mapper, JsonNode jsonNode) {
        if (jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        return Double.parseDouble(jsonNode.asText().trim());
    }

    private BigDecimal convertToBigDecimal(ObjectMapper mapper, JsonNode jsonNode) {
        if (jsonNode.isBigDecimal()) {
            return jsonNode.decimalValue();
        }
        return new BigDecimal(jsonNode.asText().trim());
    }

    private BigInteger convertToBigInteger(ObjectMapper mapper, JsonNode jsonNode) {
        if (jsonNode.isBigInteger()) {
            return jsonNode.bigIntegerValue();
        }
        return new BigInteger(jsonNode.asText().trim());
    }

    private LocalDate convertToLocalDate(ObjectMapper mapper, JsonNode jsonNode) {
        return DateTimeFormatter.ISO_LOCAL_DATE.parse(jsonNode.asText()).query(TemporalQueries.localDate());
    }

    private Date convertToDate(ObjectMapper mapper, JsonNode jsonNode) {
        return Date.valueOf(this.convertToLocalDate(mapper, jsonNode));
    }

    private LocalDateTime convertToLocalDateTime(ObjectMapper mapper, JsonNode jsonNode) {
        TemporalAccessor parsedTimestamp = TimeFormats.RFC3339_TIMESTAMP_FORMAT.parse(jsonNode.asText());
        ZoneOffset zoneOffset = parsedTimestamp.query(TemporalQueries.offset());
        if (zoneOffset != null && zoneOffset.getTotalSeconds() != 0) {
            throw new IllegalStateException("Invalid timestamp format. Only a timestamp in UTC timezone is supported yet. Format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
        LocalTime localTime = parsedTimestamp.query(TemporalQueries.localTime());
        LocalDate localDate = parsedTimestamp.query(TemporalQueries.localDate());
        return LocalDateTime.of(localDate, localTime);
    }

    private Timestamp convertToTimestamp(ObjectMapper mapper, JsonNode jsonNode) {
        return Timestamp.valueOf(this.convertToLocalDateTime(mapper, jsonNode));
    }

    private LocalTime convertToLocalTime(ObjectMapper mapper, JsonNode jsonNode) {
        TemporalAccessor parsedTime = TimeFormats.RFC3339_TIME_FORMAT.parse(jsonNode.asText());
        ZoneOffset zoneOffset = parsedTime.query(TemporalQueries.offset());
        LocalTime localTime = parsedTime.query(TemporalQueries.localTime());
        if (zoneOffset != null && zoneOffset.getTotalSeconds() != 0 || localTime.getNano() != 0) {
            throw new IllegalStateException("Invalid time format. Only a time in UTC timezone without milliseconds is supported yet.");
        }
        return localTime;
    }

    private Time convertToTime(ObjectMapper mapper, JsonNode jsonNode) {
        return Time.valueOf(this.convertToLocalTime(mapper, jsonNode));
    }

    private DeserializationRuntimeConverter assembleRowConverter(String[] fieldNames, List<DeserializationRuntimeConverter> fieldConverters) {
        return (mapper, jsonNode) -> {
            ObjectNode node = (ObjectNode)jsonNode;
            int arity = fieldNames.length;
            Row row = new Row(arity);
            for (int i = 0; i < arity; ++i) {
                String fieldName = fieldNames[i];
                JsonNode field = node.get(fieldName);
                Object convertField = this.convertField(mapper, (DeserializationRuntimeConverter)fieldConverters.get(i), fieldName, field);
                row.setField(i, convertField);
            }
            return row;
        };
    }

    private Object convertField(ObjectMapper mapper, DeserializationRuntimeConverter fieldConverter, String fieldName, JsonNode field) {
        if (field == null) {
            if (this.failOnMissingField) {
                throw new IllegalStateException("Could not find field with name '" + fieldName + "'.");
            }
            return null;
        }
        return fieldConverter.convert(mapper, field);
    }

    private DeserializationRuntimeConverter assembleArrayConverter(TypeInformation<?> elementType, DeserializationRuntimeConverter elementConverter) {
        Class elementClass = elementType.getTypeClass();
        return (mapper, jsonNode) -> {
            ArrayNode node = (ArrayNode)jsonNode;
            Object[] array = (Object[])Array.newInstance(elementClass, node.size());
            for (int i = 0; i < node.size(); ++i) {
                JsonNode innerNode = node.get(i);
                array[i] = elementConverter.convert(mapper, innerNode);
            }
            return array;
        };
    }

    private static final class JsonParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JsonParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    private static interface DeserializationRuntimeConverter
    extends Serializable {
        public Object convert(ObjectMapper var1, JsonNode var2);
    }

    public static class Builder {
        private final RowTypeInfo typeInfo;
        private boolean failOnMissingField = false;
        private boolean ignoreParseErrors = false;

        public Builder(TypeInformation<Row> typeInfo) {
            Preconditions.checkArgument((boolean)(typeInfo instanceof RowTypeInfo), (Object)"Only RowTypeInfo is supported");
            this.typeInfo = (RowTypeInfo)typeInfo;
        }

        public Builder(String jsonSchema) {
            this(JsonRowSchemaConverter.convert((String)Preconditions.checkNotNull((Object)jsonSchema)));
        }

        public Builder failOnMissingField() {
            this.failOnMissingField = true;
            return this;
        }

        public Builder ignoreParseErrors() {
            this.ignoreParseErrors = true;
            return this;
        }

        public JsonRowDeserializationSchema build() {
            return new JsonRowDeserializationSchema((TypeInformation)this.typeInfo, this.failOnMissingField, this.ignoreParseErrors);
        }
    }
}

