/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.csv.AbstractCsvInputFormat;
import org.apache.flink.formats.csv.CsvRowDeserializationSchema;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class RowCsvInputFormat
extends AbstractCsvInputFormat<Row> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation[] fieldTypes;
    private final String[] selectedFieldNames;
    private final boolean ignoreParseErrors;
    private transient CsvRowDeserializationSchema.RuntimeConverter runtimeConverter;
    private transient MappingIterator<JsonNode> iterator;
    private transient boolean end;

    private RowCsvInputFormat(Path[] filePaths, TypeInformation[] fieldTypes, CsvSchema csvSchema, int[] selectedFields, boolean ignoreParseErrors) {
        super(filePaths, csvSchema);
        this.fieldTypes = (TypeInformation[])Preconditions.checkNotNull((Object)fieldTypes);
        Preconditions.checkArgument((fieldTypes.length == csvSchema.size() ? 1 : 0) != 0);
        this.ignoreParseErrors = ignoreParseErrors;
        this.selectedFieldNames = (String[])Arrays.stream((int[])Preconditions.checkNotNull((Object)selectedFields)).mapToObj(csvSchema::columnName).toArray(String[]::new);
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.prepareConverter();
        this.iterator = new CsvMapper().readerFor(JsonNode.class).with(this.csvSchema).readValues(this.csvInputStream);
    }

    private void prepareConverter() {
        CsvRowDeserializationSchema.RuntimeConverter[] fieldConverters = CsvRowDeserializationSchema.createFieldRuntimeConverters(this.ignoreParseErrors, this.fieldTypes);
        this.runtimeConverter = node -> {
            int nodeSize = node.size();
            CsvRowDeserializationSchema.validateArity(this.csvSchema.size(), nodeSize, this.ignoreParseErrors);
            Row row = new Row(this.selectedFieldNames.length);
            for (int i = 0; i < Math.min(this.selectedFieldNames.length, nodeSize); ++i) {
                row.setField(i, fieldConverters[i].convert(node.get(this.selectedFieldNames[i])));
            }
            return row;
        };
    }

    public boolean reachedEnd() {
        return this.end;
    }

    public Row nextRecord(Row record) throws IOException {
        Row returnRecord = null;
        do {
            try {
                JsonNode root = this.iterator.nextValue();
                returnRecord = (Row)this.runtimeConverter.convert(root);
            }
            catch (NoSuchElementException e) {
                this.end = true;
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) continue;
                throw new IOException("Failed to deserialize CSV row.", t);
            }
        } while (returnRecord == null && !this.reachedEnd());
        return returnRecord;
    }

    public static Builder builder(TypeInformation<Row> typeInfo, Path ... filePaths) {
        return new Builder((TypeInformation)typeInfo, filePaths);
    }

    public static class Builder
    implements Serializable {
        private final Path[] filePaths;
        private final TypeInformation[] fieldTypes;
        private CsvSchema csvSchema;
        private boolean ignoreParseErrors;
        private int[] selectedFields;

        private Builder(TypeInformation<Row> typeInfo, Path ... filePaths) {
            Preconditions.checkNotNull((Object)filePaths, (String)"File paths must not be null.");
            Preconditions.checkNotNull(typeInfo, (String)"Type information must not be null.");
            if (!(typeInfo instanceof RowTypeInfo)) {
                throw new IllegalArgumentException("Row type information expected.");
            }
            this.filePaths = filePaths;
            this.fieldTypes = ((RowTypeInfo)typeInfo).getFieldTypes();
            this.csvSchema = CsvRowSchemaConverter.convert((RowTypeInfo)typeInfo);
        }

        public Builder setFieldDelimiter(char delimiter) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(delimiter).build();
            return this;
        }

        public Builder setAllowComments(boolean allowComments) {
            this.csvSchema = this.csvSchema.rebuild().setAllowComments(allowComments).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Array element delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            Preconditions.checkNotNull((Object)nullLiteral, (String)"Null literal must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setNullValue(nullLiteral).build();
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public Builder setSelectedFields(int[] selectedFields) {
            this.selectedFields = selectedFields;
            return this;
        }

        public RowCsvInputFormat build() {
            if (this.selectedFields == null) {
                this.selectedFields = new int[this.fieldTypes.length];
                for (int i = 0; i < this.fieldTypes.length; ++i) {
                    this.selectedFields[i] = i;
                }
            }
            return new RowCsvInputFormat(this.filePaths, this.fieldTypes, this.csvSchema, this.selectedFields, this.ignoreParseErrors);
        }
    }
}

