/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.formats.csv.CsvToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@Internal
public final class CsvRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<RowData> resultTypeInfo;
    private final CsvToRowDataConverters.CsvToRowDataConverter runtimeConverter;
    private final CsvSchema csvSchema;
    private final ObjectReader objectReader;
    private final boolean ignoreParseErrors;

    private CsvRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, CsvSchema csvSchema, boolean ignoreParseErrors) {
        this.resultTypeInfo = resultTypeInfo;
        this.runtimeConverter = new CsvToRowDataConverters(ignoreParseErrors).createRowConverter(rowType, true);
        this.csvSchema = CsvRowSchemaConverter.convert(rowType);
        this.objectReader = new CsvMapper().readerFor(JsonNode.class).with(csvSchema);
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public RowData deserialize(@Nullable byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        try {
            JsonNode root = (JsonNode)this.objectReader.readValue(message);
            return (RowData)this.runtimeConverter.convert(root);
        }
        catch (Throwable t) {
            if (this.ignoreParseErrors) {
                return null;
            }
            throw new IOException("Failed to deserialize CSV row '" + new String(message) + "'.", t);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CsvRowDataDeserializationSchema that = (CsvRowDataDeserializationSchema)o;
        CsvSchema otherSchema = that.csvSchema;
        return this.resultTypeInfo.equals(that.resultTypeInfo) && this.ignoreParseErrors == that.ignoreParseErrors && this.csvSchema.getColumnSeparator() == otherSchema.getColumnSeparator() && this.csvSchema.allowsComments() == otherSchema.allowsComments() && this.csvSchema.getArrayElementSeparator().equals(otherSchema.getArrayElementSeparator()) && this.csvSchema.getQuoteChar() == otherSchema.getQuoteChar() && this.csvSchema.getEscapeChar() == otherSchema.getEscapeChar() && Arrays.equals(this.csvSchema.getNullValue(), otherSchema.getNullValue());
    }

    public int hashCode() {
        return Objects.hash(this.resultTypeInfo, this.ignoreParseErrors, Character.valueOf(this.csvSchema.getColumnSeparator()), this.csvSchema.allowsComments(), this.csvSchema.getArrayElementSeparator(), this.csvSchema.getQuoteChar(), this.csvSchema.getEscapeChar(), this.csvSchema.getNullValue());
    }

    @Internal
    public static class Builder {
        private final RowType rowType;
        private final TypeInformation<RowData> resultTypeInfo;
        private CsvSchema csvSchema;
        private boolean ignoreParseErrors;

        public Builder(RowType rowType, TypeInformation<RowData> resultTypeInfo) {
            Preconditions.checkNotNull((Object)rowType, (String)"RowType must not be null.");
            Preconditions.checkNotNull(resultTypeInfo, (String)"Result type information must not be null.");
            this.rowType = rowType;
            this.resultTypeInfo = resultTypeInfo;
            this.csvSchema = CsvRowSchemaConverter.convert(rowType);
        }

        public Builder setFieldDelimiter(char delimiter) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(delimiter).build();
            return this;
        }

        public Builder setAllowComments(boolean allowComments) {
            this.csvSchema = this.csvSchema.rebuild().setAllowComments(allowComments).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Array element delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder disableQuoteCharacter() {
            this.csvSchema = this.csvSchema.rebuild().disableQuoteChar().build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            Preconditions.checkNotNull((Object)nullLiteral, (String)"Null literal must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setNullValue(nullLiteral).build();
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public CsvRowDataDeserializationSchema build() {
            return new CsvRowDataDeserializationSchema(this.rowType, this.resultTypeInfo, this.csvSchema, this.ignoreParseErrors);
        }
    }
}

