/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(HostInterceptor.class);
    private final boolean preserveExisting;
    private final String header;
    private String host = null;

    private HostInterceptor(boolean preserveExisting, boolean useIP, String header) {
        this.preserveExisting = preserveExisting;
        this.header = header;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.host = useIP ? addr.getHostAddress() : addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("Could not get local host address. Exception follows.", (Throwable)e);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public Event intercept(Event event) {
        Map headers = event.getHeaders();
        if (this.preserveExisting && headers.containsKey(this.header)) {
            return event;
        }
        if (this.host != null) {
            headers.put(this.header, this.host);
        }
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    @Override
    public void close() {
    }

    public static class Constants {
        public static String HOST = "host";
        public static String PRESERVE = "preserveExisting";
        public static boolean PRESERVE_DFLT = false;
        public static String USE_IP = "useIP";
        public static boolean USE_IP_DFLT = true;
        public static String HOST_HEADER = "hostHeader";
    }

    public static class Builder
    implements Interceptor.Builder {
        private boolean preserveExisting = Constants.PRESERVE_DFLT;
        private boolean useIP = Constants.USE_IP_DFLT;
        private String header = Constants.HOST;

        @Override
        public Interceptor build() {
            return new HostInterceptor(this.preserveExisting, this.useIP, this.header);
        }

        @Override
        public void configure(Context context) {
            this.preserveExisting = context.getBoolean(Constants.PRESERVE, Boolean.valueOf(Constants.PRESERVE_DFLT));
            this.useIP = context.getBoolean(Constants.USE_IP, Boolean.valueOf(Constants.USE_IP_DFLT));
            this.header = context.getString(Constants.HOST_HEADER, Constants.HOST);
        }
    }
}

