/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.planner.plan.rules.logical.RankNumberColumnRemoveRule$;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001'\tQ\"+\u00198l\u001dVl'-\u001a:D_2,XN\u001c*f[>4XMU;mK*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ei\u0011A\u0006\u0006\u0003\u000f]Q!\u0001\u0007\b\u0002\u000f\r\fGnY5uK&\u0011!D\u0006\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u0015\t\u0003\u0001\"\u0011#\u0003\u001di\u0017\r^2iKN$\"aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\u000f\t{w\u000e\\3b]\")!\u0006\ta\u0001W\u0005!1-\u00197m!\t)B&\u0003\u0002.-\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0007\"B\u0018\u0001\t\u0003\u0002\u0014aB8o\u001b\u0006$8\r\u001b\u000b\u0003cQ\u0002\"\u0001\n\u001a\n\u0005M*#\u0001B+oSRDQA\u000b\u0018A\u0002-:QA\u000e\u0002\t\u0002]\n!DU1oW:+XNY3s\u0007>dW/\u001c8SK6|g/\u001a*vY\u0016\u0004\"a\b\u001d\u0007\u000b\u0005\u0011\u0001\u0012A\u001d\u0014\u0005aR\u0004C\u0001\u0013<\u0013\taTE\u0001\u0004B]f\u0014VM\u001a\u0005\u00069a\"\tA\u0010\u000b\u0002o!9\u0001\t\u000fb\u0001\n\u0003\t\u0015\u0001C%O'R\u000bejQ#\u0016\u0003yAaa\u0011\u001d!\u0002\u0013q\u0012!C%O'R\u000bejQ#!\u0001")
public class RankNumberColumnRemoveRule
extends RelOptRule {
    public static RankNumberColumnRemoveRule INSTANCE() {
        return RankNumberColumnRemoveRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        ConstantRankRange constantRankRange;
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(0);
        RankType rankType = rank.rankType();
        RankType rankType2 = RankType.ROW_NUMBER;
        boolean isRowNumber = !(rankType != null ? !rankType.equals(rankType2) : rankType2 != null);
        RankRange rankRange = rank.rankRange();
        boolean bl = rankRange instanceof ConstantRankRange ? (constantRankRange = (ConstantRankRange)rankRange).getRankStart() == constantRankRange.getRankEnd() : false;
        boolean constantRowNumber = bl;
        return isRowNumber && constantRowNumber && rank.outputRankNumber();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(0);
        long rowNumber = ((ConstantRankRange)rank.rankRange()).getRankStart();
        FlinkLogicalRank newRank = new FlinkLogicalRank(rank.getCluster(), rank.getTraitSet(), rank.getInput(), rank.partitionKey(), rank.orderKey(), rank.rankType(), rank.rankRange(), rank.rankNumberType(), false);
        RexBuilder rexBuilder = rank.getCluster().getRexBuilder();
        RexProgramBuilder programBuilder = new RexProgramBuilder(newRank.getRowType(), rexBuilder);
        int fieldCount = rank.getRowType().getFieldCount();
        List<String> fieldNames = rank.getRowType().getFieldNames();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fieldCount).foreach((Function1)new Serializable(this, rowNumber, rexBuilder, programBuilder, fieldCount, fieldNames){
            public static final long serialVersionUID = 0L;
            private final long rowNumber$1;
            private final RexBuilder rexBuilder$1;
            private final RexProgramBuilder programBuilder$1;
            private final int fieldCount$1;
            private final List fieldNames$1;

            public final RexLocalRef apply(int i) {
                RexLocalRef rexLocalRef;
                if (i < this.fieldCount$1 - 1) {
                    rexLocalRef = this.programBuilder$1.addProject(i, i, (String)this.fieldNames$1.get(i));
                } else {
                    RexLiteral rowNumberLiteral = this.rexBuilder$1.makeBigintLiteral(new BigDecimal(this.rowNumber$1));
                    rexLocalRef = this.programBuilder$1.addProject(i, rowNumberLiteral, (String)this.fieldNames$1.get(i));
                }
                return rexLocalRef;
            }
            {
                this.rowNumber$1 = rowNumber$1;
                this.rexBuilder$1 = rexBuilder$1;
                this.programBuilder$1 = programBuilder$1;
                this.fieldCount$1 = fieldCount$1;
                this.fieldNames$1 = fieldNames$1;
            }
        });
        RexProgram rexProgram = programBuilder.getProgram();
        FlinkLogicalCalc calc = FlinkLogicalCalc$.MODULE$.create(newRank, rexProgram);
        call.transformTo(calc);
    }

    public RankNumberColumnRemoveRule() {
        super(RelOptRule.operand(FlinkLogicalRank.class, RelOptRule.any()), "RankFunctionColumnRemoveRule");
    }
}

